// Angular App Definition
var mainscope = null, $L = window.opener.$L;
var app = angular.module('App', ['ngMaterial', 'ngMessages', 'ngRoute', 'ngSanitize', 'ngAnimate'])
	.controller('Ctrl', function ($scope, $window, $interval, $timeout, $mdDialog){
		mainscope = $scope;
		$scope.$L = $L;
		$scope.ready = false;
		$scope.graph = false;
		$scope.grid = false;
		$scope.wait = function() {
			if (window.scope) $scope.init();
			else if (window.chart) $scope.initChart();
			else $timeout($scope.wait, 100);
		};
		$scope.init = function() {
			$scope.grid = new GridBox({copy:scope.name});
			$scope.jump = scope.jumpVar;
			$scope.ready = true;
			document.title = scope.name.title;
		};
		$scope.initChart = function() {
			chart.init = $scope.copyChart;
			$scope.graph = chart;
			$scope.ready = true;
		};
		$scope.copyChart = function(id, pid) {
			console.log(chart.config);
			$scope.graph.chart = new Chart(id, chart.config);
			$('#'+pid).height(chart.config.data.datasets[0].data.length*48 + 96);
			$scope.graph.chart.update();
			if ($scope.$apply) $scope.$apply();
		};
		$scope.wait();
	});
EacAppSetup(app);
