window.onload = function () {
	try { window.opener.closeWindowFromChild();
	} catch (e) {}
	if (!isDebug()) {
		$("#debug2").hide();
		$("#debug").hide();
	}
};

async function LoadDashAsync(uid, $footer, outmgrShow) {
	let data={goals:[]}, ps={'@uid':uid}, eacVer='', modes = [];
	eacmodes = new EACModes();
	if (permissions.im) modes.push("Instructor");
	let queries=[["afb1e917-61fd-4fa2-8729-49dcfce73e75",ps,'terms',e=>{terms=e}],
			['586f6fac-c708-46d5-869b-2406d3eb1b65',ps,'ent',e=>{
				if (e[0].entcount>0 && permissions.em) modes.push('Enterprise');
			}], ['7C9C4451-CBB1-4C98-A0C9-198EB4F2F967',ps,'oa',e=>{
				if (e[0].outcount>0 && permissions.ot) oaUser=true;
			}], ['99677937-C5BD-4523-9709-002B2637CD45',ps,'domains',e=>{
				if (e.length<1 || !permissions.am) return;
				modes.push('Administrator');
				mode_pk1s=e.map(x=>x.node_pk1).join();
			}], ['179807ae-250e-490f-8bc6-21e6c70be8f9',ps,'version',e=>{ let x=e[0];
				eacVer=`${x.version_major}.${x.version_minor}.${x.version_patch}`;
				window.version=eacVer;
			}], ['4fb35c8b-76dd-4abc-96f5-5928afce5ba0',ps,'bbassess',e=>{
				bbassess=e.length>0;
			}]
		], goalp1=permissions.gg||permissions.gt, goalp2=permissions.ag||permissions.eg||permissions.ig, goalq2=!goalp1&&goalp2, p1done=!goalq2?2:0;
	if (goalp1) queries.unshift(['9637AAD6-3090-4F0E-B61B-93ECFFA90690',{},'goals']);
	await SQLPart(data, 0, p1done, queries);
	if (isDebug() && !modes.includes('Enterprise')) modes.push('Enterprise');
	if (goalq2) {
		if ((permissions.ag&&modes.includes('Administrator'))||(permissions.eg&&modes.includes('Enterprise'))||(permissions.ig&&modes.includes('Instructor'))) await SQLOne(data, 'goals', 1, 2, '9637AAD6-3090-4F0E-B61B-93ECFFA90690');
		else parseProgress.reset(true);
	}
	let ft=$footer.html().trim();
	$footer.html(`${ft} (${eacVer})`);
	eacmodes.makeModes(modes, outmgrShow);
	nReady=true;
	goalCats=data.goals;
	await Timer(10);
	if (bburl.includes('gvtc.')||bburl.includes('southernregional.')) {
		goalCats.forEach((goal,i)=>{
			let sep = goal.title.lastIndexOf(':'), desc = "";
			if (sep >= 0) desc = goal.title.substring(sep + 1).trim();
			else desc = goal.title;
			goal.desc = TAG(desc);
			goal.category=TAG(goal.category);
			let b=goal.desc.indexOf('('), e=goal.desc.indexOf(')');
			goal.unique_id=goal.realcat.split(' ')[0]+'.'+goal.desc.substring(b+1,e);
			goal.clppk1 = goal.pk1;
			goal.pk1 = '-' + goal.pk1;
		});
	} else {
		goalCats.forEach((goal,i)=>{
			let sep = goal.title.lastIndexOf(':'), desc = "";
			if (sep >= 0) desc = goal.title.substring(sep + 1).trim();
			else desc = goal.title;
			goal.desc = TAG(desc);
			goal.category = TAG(goal.category);
			goal.unique_id = TAG(goal.unique_id);
			goal.clppk1 = goal.pk1;
			goal.pk1 = '-' + goal.pk1;
		});
	}
	gReady=true;
	console.log(performance.now());
}

async function GetRubricsAsync (uid, td, fd, filter, rubric) {
	// Get rubric info
	let data={qdpk1s:{}},tdp=getSqlDate(td),fdp=getSqlDate(fd),parts=[[]];
	if (rubric) { await SQLOne(data,'p1',0,0,'607A250C-B30A-4DEB-A11F-B367813FC33E',{'@to_date':tdp,'@from_date':fdp,'@uid':uid,'--@E':filter.em,'--@A':filter.am,'$0$':filter.cf,'--@I':filter.im,'@gmTitles':filter.gm});
		data.p1=data.p1.map((x,i)=>{return {course_id:x.cid,course_name:x.cname,gmdate:x.rdate.split(' ')[0],gmpk1:x.gmpk1,title:x.gmtitle,rtitle:x.rname,qdpk1:x.rpk1,pk1:x.cpk1,rapk1:x.ra_pk1,term:x.term,index:i,rtype:x.rtype}; });
	} else { await SQLOne(data,'p1',0,0,'F07DB563-BFBD-44CA-B423-E4E198EA00B7',{'@to_date':tdp,'@from_date':fdp,'@uid':uid,'@filters':filter});
		data.p1 = data.p1.map((x,i)=>{ return {eis_pk1:x.eis_pk1,eis_title:x.eis_title,rapk1:x.ra_pk1,rdate:x.rdate.split(' ')[0],index:i,rname:x.rname,qdpk1:x.rpk1,rtype:x.rtype,pk1:1,course_name:'',course_id:'',id:x.rpk1}; });
	}
	if (data.p1.length==0) { mainscope.Cancel(); return; } // Get rubric row info
	data.p1.forEach((x,i)=>{
		if (!data.qdpk1s[x.qdpk1]) { data.qdpk1s[x.qdpk1] = [i];
			if (_.last(parts).length>24) parts.push([x.qdpk1]);
			else _.last(parts).push(x.qdpk1);
		} else data.qdpk1s[x.qdpk1].push(i);
	});
	await SQLChunk(data,'p2',1,0,'3BE446D6-4287-4A13-AB5A-50BCBAB33C8C',{},parts.map(x=>{ return {'@rpk1s':x.join()}; }));
	if (data.p2.length < 1) return;
	let cur_qdpk1=data.p2[0].pk1,rrows=[],cols=data.p2[0].cols,qtype='',SetRow=x=>{
		// Normalize rname values (which contain rrow content) by stripping whitespace and entities for consistent grouping
		const normalizeText = (text) => {
			return text.replace(/[\s\n\r\t]+/g, ' ').trim().replace(/&[a-zA-Z0-9#]+;/g, '').toLowerCase();
		};
		qtype = cols+'_'+rrows.map(x=>normalizeText(x.rname)).join('_');
		data.qdpk1s[cur_qdpk1].forEach(q=>{ data.p1[q].rrows = rrows;
			data.p1[q].qtype = rubric?qtype:data.p1[q].qdpk1;
			data.p1[q].ncols = cols; });
	}; // Merge row info
	for (let row of data.p2) {
		if (row.pk1 != cur_qdpk1) { SetRow();
			cur_qdpk1 = row.pk1;
			rrows = [];
			cols = row.cols;
		}
		rrows[row.position] = {rname:row.rrow, rrpk1:row.rr_pk1, pos:parseInt(row.position)+1};
	}
	SetRow();
	if (!rubric) return mainscope.Finish(data.p1) // return outcome list
	var mydata=[], ourdata=[];
	data.p1.forEach(x=>{ x.Course_ID=x.course_id; x.Course_Name=x.course_name;
		mydata.push(new rubricsListRow(x));
	})
	mydata.sort((a,b)=>(a.Date>b.Date)?-1:(a.Date<b.Date)?1:0).forEach((x,i)=>{
		x.Init(i); ourdata.push(_.clone(x)); });
	EacHomeInstructors(ourdata);
}

async function EacHomeInstructors (ary) {
	let ids=_.uniq(ary.map(x=>x.pk1)).join(),data={instructors:{},enrollment:{}};
	await SQLOne(data,'p3',2,1,'67CD55C2-f8AA-4300-A962-4DDB6D5581B4',{'@cpk1':ids});
	data.p3.forEach(x=>{
		if (x.course_id in data.instructors) data.instructors[x.course_id]+='; ';
		else data.instructors[x.course_id] = '';
		data.instructors[x.course_id] += x.lastname + ', ' + x.firstname;
		data.enrollment[x.course_id] = x.enrollment;
	});
	ary.forEach(dat=>{ dat.Instructors = data.instructors[dat.CourseID];
		dat.enrollment = parseInt(data.enrollment[dat.CourseID]); });
	mainscope.Finish(ary);
}

getAllTheTests2 = function (uid, mode, courseFilter, to_date, from_date, testNames, isOracle, domain_pk1) {
	parseProgress.update(0, 1);
	var q1='9F68263E-BB84-468C-91D9-F7D55FE4A9BC', td=getSqlDate(to_date);
	var q2='38806A34-F466-42AA-BDB7-1377E5A2D658', fd=getSqlDate(from_date);
	var fields=testNames.split('||'), fc=filterCourse(), url=getSqlUrl(bburl);
	fc.set_expression("gm.title");
	fc.set_textbox(fields[0]);
	var gmTitles = fc.getSql(), crs = [], css = addCourseFilter(fields[1]);
	if (css.length>0) gmTitles = (gmTitles.length>0 ? gmTitles+' ' : '') + css;
	var ps={'@to_date':td, '@from_date':fd, '@uid':uid, '@gmTitles':gmTitles};
	ps['$0$'] = courseFilter;
	ps['--@A'] = mode=='administrator' ? ' ' : ' -- ';
	ps['--@I'] = mode=='instructor' ? ' ' : ' -- ';
	ps['--@E'] = (mode=='enterprise' && !isDebug()) ? ' ' : ' -- ';
	var params = getParams(getHost(), bburl, q1, ps);
	aGetSql(url, params, true).done(function (xml) {
		var md=ParseXML(xml, {gmpk1:parseInt}, false), chunks=[], proms=[];
		if (md.length<1) return ParseCancel();
		chunks=arrayChunk(md.map(x=>x.gmpk1),30).map(y=>y.join(','));
		params.contents = fixObj(q2);
		parseProgress.resolve(1, chunks.length);
		for (let chunk of chunks) {
			params.ps = fixObj(JSON.stringify({'@gmpk1s':chunk}));
			proms.push(aGetSql(url, params, true).done(function(xml) {
				var cd=ParseXML(xml, {gmpk1:parseInt}), pd=[], p={};
				cd.forEach(c=>{
					if (parseInt(c.qtype) >= 19) {
						c.qtype = null; // Exclude kind_ids >= 19 from grouping
					} else {
						c.qtype=c.qtype=="17"?"2":(c.qtype=="3"?"1":c.qtype);
					}
				});
				cd=cd.filter(c => c.qtype !== null); // Filter out null qtype values before sorting
				cd=SortObjAry(cd, 'gmpk1', 'qtype');
				for (let c of cd) {
					if (c.gmpk1==p.gmpk1) p.qtype+='_'+c.qtype;
					else {p=c; pd.push(p);}
				}
				md = JoinSorted(md, pd, 'gmpk1');
				parseProgress.resolve();
			}));
		}
		Promise.all(proms).then(x=>parseTests(md.filter(y=>y.qtype!=undefined)));
	});
}

function parseTests(data, alltests, qdss) {
	waitForIt = false;
	alltests1 = alltests;
	qds = qdss;
	var tables = data;
	var qdpk0 = '';//tables[0].qdpk1;
	var mydata = new Array();
	//     courseListRow(qdpk1, title, qtype, pk1, Course_Name, Course_ID, avail, role, score, scored,  gmdate, possible, path, bburl, token, file)
	$(tables).each(function (i, elem) {
		if (qdpk0.length > 0) {
			mydata.push(new courseListRowPool(elem.qdpk1, elem.qdpk0,
				elem.title, elem.qtype, elem.cpk1,
				elem.Course_Name, elem.Course_ID, elem.avail,
				elem.role, elem.score,
				elem.scored, elem.gmdate,
				elem.possible, path, bburl, token, "/EacTests.html?id="));
		} else {
			mydata.push(new courseListRow(elem.qdpk1,
				elem.title, elem.qtype, elem.pk1,
				elem.course_name, elem.course_id, elem.avail,
				elem.role, elem.score,
				elem.scored, elem.gmdate,
				elem.possible,elem.ultrastatus, path, bburl, token, "/EacTests.html?id="));
		}

		if ((i % 5) === 0) {
			waitForIt = false;
		}
	});
	mydata = mydata.sort(function (a, b) {
		return (a.Date > b.Date) ? -1 : (a.Date < b.Date) ? 1 : 0;
	});
	var ourdata = [];
	for (var i = 0; i < mydata.length; i++) {
		arow = {};
		for (n in mydata[i]) {
			if (mydata[i].hasOwnProperty(n)) {
				arow[n] = mydata[i][n];
			}
		}
		//arow.Name = arow.title;
		ourdata.push(arow);
	}
	EacHomeInstructors(ourdata);
}

function getGoalsParts(uid, mode, courseFilter, termst, to_date, from_date, searchFilter, parts, goalsObj) {
	var recordnum=0, theUrl=getSqlUrl(bburl), params=getParams(host, bburl);
	var data=[], gms=[], detailPromise=[];
	var dataMap={}, newData={}, oldData={}, sqlPs={};
	var sqls=['3ACE6711-0A14-42DF-A7E5-AD3FC052379B', '5ED026D9-5A64-4707-B298-DF856A6C73FA'];
	if (mainscope.showOutcomes)sqls.push('D9506B0A-427C-4BBE-A6AD-A8036D16EED7');
	goalDetailData = [];
	goalDetailMap = {};
	parseProgress.update(0, parts.length*sqls.length);

	//sql = "A6B4D78E-891F-4469-8558-7C2C41703E34"; //GETALLGOALSSTUFF_TERMS;
	if (dbtype === 'pgsql') sqlPs['--@O'] = '';
	else if (dbtype === 'mssql') sqlPs['--@S'] = '';
	else sqlPs['--@O'] = '';
	sqlPs['@uid'] = uid;
	sqlPs['@courseFilter'] = courseFilter;
	if ($.type(to_date) !== "date") to_date = new Date(to_date);
	if ($.type(from_date) !== "date") from_date = new Date(from_date);
	sqlPs['@to_date'] = getSqlDate(to_date);
	sqlPs['@from_date'] = getSqlDate(from_date);
	sqlPs['--@I'] = mode=='instructor' ? ' ' : ' -- ';
	sqlPs['--@E'] = (mode=='enterprise' && !isDebug()) ? ' ' : ' -- ';
	sqlPs['--@D'] = isDebug() ? ' -- ' : ' ';
	
	if (typeof parts === 'undefined' || parts.length === 0) return true;
	let filters = parts.map(x=>'and ('+x+')');
	for (let filter of filters) {
		for (let sql of sqls) {
			sqlPs['@filters'] = filter;
			//console.log('goals stuff sql ' + sql);
			params.contents = fixObj(sql);
			params.ps = fixObj(JSON.stringify(sqlPs));
			detailPromise.push(aGetSql(theUrl,params,true).done(function(xml){
				var gmsx = $.xml2json(xml)["myTable"];
				if (typeof gmsx !== 'undefined') {
					if (typeof gmsx.length != 'undefined') gms = gmsx;
					else gms = $.makeArray(gmsx);
					
					var goal = '', descr = '', gpk1 = '';
					var foundGoal = null;
					var avg = 0, scored = 0, totscore = 0, score = 0, per = 0;
					for (var i = 0; i < gms.length; i++) {
						if (gms[i].errorcode) {
							console.log(gms);
							continue;
						} else if (goal.length == 0) {
							goal = gms[i].batch_uid;
							foundGoal=goalsObj.find(x=>x.pk1=='-'+gms[i].gpk1);
							if (foundGoal) descr = foundGoal.desc;
							else console.log({gms:gms[i], go:goalsObj});
							if (goal.match(/([\w\d]+\-)+[\w\d]+/)) goal = foundGoal.category;
							gpk1 = gms[i].gpk1;
						}
						
						if (!gms[i].rname) gms[i].rname = '--';
						gms[i].scored = parseInt(gms[i].scored);
						gms[i].date = gms[i].ndate.split(' ')[0];
						gms[i].average = parseFloat(gms[i].average);
						
						let x = gms[i];
						x.name = TAG(x.name);
						let key = x.gpk1 +'**'+ x.name +'**'+ x.course_id;
						if (goalDetailMap.hasOwnProperty(key)) {
							let a = goalDetailData[goalDetailMap[key]];
							let total = a.scored + x.scored;
							a.average = (a.average*a.scored + x.average*x.scored) / total;
							a.scored = total;
						} else {
							goalDetailMap[key] = goalDetailData.length;
							goalDetailData.push(x);
						}
						
						var tscore = gms[i].average * gms[i].scored;
						if (gms[i].batch_uid !== goal) {
							if (scored > 0) {
								avg = $.precision(totscore/scored, 1e-2);
								per = $.precision(100*totscore/scored, 1e-1);
								newData = {goal:goal, desc:descr, scored:scored, average:avg, percent:per, gpk1:gpk1};
								if (dataMap.hasOwnProperty(gpk1)) {
									oldData = data[dataMap[gpk1]];
									oldData.percent = $.precision(100*(oldData.scored*oldData.average+newData.scored*newData.average) / (oldData.scored+newData.scored), 1e-1);
									oldData.average = $.precision((oldData.scored*oldData.average+newData.scored*newData.average) / (oldData.scored+newData.scored), 1e-2);
									oldData.scored += newData.scored;
								} else {
									dataMap[gpk1] = data.length;
									data.push(newData);
								}
							}
							goal = gms[i].batch_uid;
							foundGoal=goalsObj.find(x=>x.pk1=='-'+gms[i].gpk1);
							if (foundGoal) descr = foundGoal.desc;
							else console.log({gms:gms[i], go:goalsObj});
							if (goal.match(/([\w\d]+\-)+[\w\d]+/)) goal = foundGoal.category;
							gpk1 = gms[i].gpk1;
							totscore = 0.0;
							scored = 0;
						}
						totscore += tscore;
						scored += gms[i].scored;
					}
					if (scored > 0) {
						avg = $.precision(totscore/scored, 1e-2);
						per = $.precision(100*totscore/scored, 1e-1);
						newData = {goal:goal, desc:descr, scored:scored, average:avg, percent:per, gpk1:gpk1};
						if (dataMap.hasOwnProperty(gpk1)) {
							oldData = data[dataMap[gpk1]];
							oldData.percent = $.precision(100*(oldData.scored*oldData.average+newData.scored*newData.average) / (oldData.scored+newData.scored), 1e-1);
							oldData.average = $.precision((oldData.scored*oldData.average+newData.scored*newData.average) / (oldData.scored+newData.scored), 1e-2);
							oldData.scored += newData.scored;
						} else {
							dataMap[gpk1] = data.length;
							data.push(newData);
						}
					}
				}
				parseProgress.resolve();
			}));
		}
	}
	$.when.apply(null, detailPromise).done(function () {
		parseProgress.reset();
		let dateRange=` (${mainscope.minDate.toLocaleDateString()} - ${mainscope.maxDate.toLocaleDateString()})`, overviewData=SortObjAry(data,'goal');
		mainscope.goalOverview.AddModel(overviewData);
		mainscope.goalOverview.grid.api.setRowData(overviewData);
		mainscope.goalOverview.AutoSize();
		mainscope.goalOverview.title = $L.h_goal_overview.title + dateRange;
		mainscope.changeGraph(false);
		mainscope.loading = false;
	});
}

///////////////////////////////////////////////////////////////

function popTestsPool(t, event, isOracle) {
	var qdpk1s = "";
	console.log("at popTests");
	var rows = selectedRowIDs;
	for (r = 0; r < rows.length; r++) {
		qdpk1s += '_' + courseList.jqGrid('getCell', rows[r], "qdpk1");
	}
	qdpk1s = qdpk1s.substring(1);
	console.log("qdpk1s " + qdpk1s);
	var parts;
	var uid;
	parts = $(t).attr("href").split("?");
	var title = $(t).attr("title");
	var queries = parts[1].split("&");
	var id = queries[queries.length - 1].split('=')[1];
	var d = new Date().getTime();
	var p = new Object();
	p["key"] = "t" + d;
	p["id"] = id + '###' + title;
	p["bburl"] = bburl;
	p["token"] = token;
	p["lang"] = lang;
	p["dbtype"] = dbtype;
	sessionStorage.setItem("t" + d, JSON.stringify(p));
	var path = EAC.ui + "/EacTests.html";
	var url = location.protocol + "//" + location.host + path;
	// console.log("url = " + url + "   bburl = " + bburl+"   location.host = "+location.host);
	var key = "t" + d;
	var windowName = key + ':::' + $.base64.encode(JSON.stringify(p));
	if (isDebug()) {
		windowName = key + ':::' + JSON.stringify(p);
	}
	var windowSize = windowSizeArray[0];
	window.open(url, windowName);
	event.preventDefault();
}

class courseListRowPool {
	constructor(qdpk1, qdpk0, title, qtype, pk1, Course_Name, Course_ID, avail, role, score, scored, gmdate, possible, path, bburl, token, file) {
		this.qdpk1 = qdpk1;
		var tip = stripLockDown(title);
		this.Name = tip;
		this.qdpk0 = qdpk0;
		this.N = 1;
		this.qtype = qtype;
		this.pk1 = pk1;
		this.CourseName = Course_Name;
		this.CourseID = Course_ID;
		this.avail = avail;
		this.role = role;
		this.score = score;
		this.Scored = scored;
		this.Date = gmdate.substring(0, 10);
		this.possible = possible;
		if (isDebug()) {
			this.Test = "<a style='white-space: normal;' title='" + _.escape(tip) + "' href='" + path + file + this.qdpk1 + "&bburl=" + bburl + "&token=" + token + "&qds=" + this.qdpk0 + "'  ' target='" + _.escape(tip) + "' class='popup' onclick='popTestsPool(this,event,isOracle); return false;'>" + _.escape(tip) + "</a>";
		}
		else {
			this.Test = "<a style='white-space: normal;' title='" + _.escape(tip) + "' href='" + path + file + this.qdpk1 + "&bburl=" + bburl + "&token=" + token + "&qds=" + this.qdpk0 + "'  ' target='" + _.escape(tip) + "' class='popup' onclick='popTestsPool(this,event,isOracle); return false;'>" + _.escape(tip) + "</a>";
		}
	}
}

var filterCourse = function () {
	// // console.log("at filterCourse");
	var expression = '';
	var textbox = '';
	return {
		set_expression: function (exp) {
			expression = String('UPPER(' + exp + ')');
			// // console.log("exp = " + expression);
		},
		set_textbox: function (tb) {
			textbox = tb.trim();
			// // console.log("textbox = " + textbox);
		},
		getSql: function () {
			var result='', tb=textbox.replace(/_/g, '^'), tokens = new Array();
			var tmps=(tb!==undefined && tb.length>0) ? tb.split(',') : null;
			if (tmps!==null && tmps.length>0) {
				for (var i=0; i<tmps.length; i++) {
					if (tmps[i].trim().toUpperCase()==="##ALL##") continue;
					tokens.push(tmps[i]);
				}
			}
			if (tokens.length > 0 && tokens[0].length > 0) {
				result = " and ( ";
				result += " (";
				for (var i = 0; i < tokens.length; i++) {
					if (i !== 0) {
						result += " ) or ( ";
					}
					var thisToken = tokens[i];
					if (thisToken.indexOf("^") !== -1) {
						var theseTokens = thisToken.split("^");
						for (var j = 0; j < theseTokens.length; j++) {
							if (j !== 0) {
								result += " ) and ( "
							}
							else {
								result += " ( "
							}
							result += "  " + expression + " like '%" + theseTokens[j].trim().toUpperCase() + "%'  escape '!' ";
						}
						result += ") "
						continue;
					}
					var starting = (thisToken[0] === "$") ? true : false;
					if (starting) {
						thisToken = thisToken.substring(1);
					}
					if (starting) {
						result += " " + expression + " like '" + thisToken.trim().toUpperCase() + "%'  escape '!' ";
					} else {
						result += "  " + expression + " like '%" + thisToken.trim().toUpperCase() + "%' escape '!'  ";
					}
				}
				if (expression.indexOf("course_name") !== -1) {
					result += ") or ("
					for (var i = 0; i < tokens.length; i++) {
						if (i !== 0) {
							result += " ) or ( ";
						}
						var thisToken = tokens[i];
						if (thisToken.indexOf("^") !== -1) {
							var theseTokens = thisToken.split("^");
							for (var j = 0; j < theseTokens.length; j++) {
								if (j !== 0) {
									result += " ) and ( "
								}
								else {
									result += " ( "
								}
								result += "  " + expression.replace("name", "id") + " like '%" + theseTokens[j].trim().toUpperCase() + "%'  escape '!' ";
							}
							result += ") "
							continue;
						}
						var starting = (thisToken[0] === "$") ? true : false;
						if (starting) {
							thisToken = thisToken.substring(1);
						}
						if (starting) {
							result += " " + expression.replace("name", "id") + " like '" + thisToken.trim().toUpperCase() + "%'  escape '!' ";
						} else {
							result += "  " + expression.replace("name", "id") + " like '%" + thisToken.trim().toUpperCase() + "%'  escape '!' ";
						}
					}
				}
				if (tokens.length > 0 && tokens[0].length > 0) {
					result += " )";
				}
			}
			if (result.length > 0) {
				result += " )";
			}
			return result;
		}
	};
};

function addCourseFilter(crs) { // courses is an array like ["x,y","z"]
	if (typeof crs === 'undefined' || crs === null || crs.length === 0) {
		return '';
	}
	var css = crs.split(',');
	cf = "";
	for (i = 0; i < css.length; i++) {
		var cs = css[i];
		cf += " or ( UPPER(c.course_name) like '%" + cs.toUpperCase().trim() + "%')  or  ( UPPER(c.course_id) like  '%" + cs.toUpperCase().trim() + "%' ) ";
	}
	if (cf.length > 0) {
		cf = cf.substring(3);
		cf = " and (" + cf + ")";
	}
	return cf;
}

function datenum(v, date1904) {
	if (date1904) v += 1462;
	var epoch = Date.parse(v);
	return (epoch - new Date(Date.UTC(1899, 11, 30))) / (24 * 60 * 60 * 1000);
}

function s2ab(s) {
	var buf = new ArrayBuffer(s.length);
	var view = new Uint8Array(buf);
	for (var i = 0; i != s.length; ++i) view[i] = s.charCodeAt(i) & 0xFF;
	return buf;
}

function getPath() {
	host = location.host;
	protocol = location.protocol;
	pathname = location.pathname;
	port = location.port;
	pathname = pathname.substring(0, pathname.lastIndexOf("/"));
	aUrl = protocol + "//" + host;
	if (port !== null && port.length > 0 && host.indexOf(":") < 0) {
		aUrl += ":" + port;
	}
	aUrl += pathname;
	return aUrl;
}

function stripLockDown(input) {
	return input.replace(/- Requires Respondus LockDown Browser/i, " - LockDown");
}

function getDts(d1, dn) {
	let dts = [], days30 = 30 * 24 * 60 * 60 * 1000;
	if (isLaureate(bburl)
	) {
		var dn = Date.parse(dn), d = Date.parse(d1);
		dts.push(getSqlDate(new Date(d)));
		while ((d - days30) > dn) {
			d = d - days30;
			dts.push(getSqlDate(new Date(d)));
		}
		dts.push(getSqlDate(new Date(dn)));
		return dts;
	} else {
		dts.push(getSqlDate(new Date(d1)));
		dts.push(getSqlDate(new Date(dn)));
		return dts;
	}
}

// add time and milliseconds to date object
function addTime (d, t, m) {
	let x = new Date(d.toDateString()+' '+t);
	x.setMilliseconds(m);
	return x;
}

///////////////////////////////////////////////////////////////////

class courseListRow {
	constructor(qdpk1, title, qtype, pk1, course_name, course_id, avail, role, score, scored, gmdate, possible, ultraStatus, path, bburl, token, file) {
		this.qdpk1 = qdpk1;
		var tip = stripLockDown(title);
		this.Name = tip;
		this.N = 1;
		this.qtype = qtype;
		this.pk1 = pk1;
		this.CourseName = course_name;
		this.CourseID = course_id;
		this.avail = avail;
		this.role = role;
		this.score = score;
		this.Scored = scored;
		this.Date = gmdate.substring(0, 10);
		this.possible = possible;
		this.ultraStatus = ultraStatus;
		if (isDebug()) {
			this.Test = "<a style='white-space: normal;' title='" + _.escape(tip) + "' href='" + path + file + this.qdpk1 + "&ultrastatus=" + ultraStatus + "&bburl=" + bburl + "&token=" + token + "'  ' target='" + _.escape(tip) + "' class='popup' onclick='popTests(this,event,isOracle); return false;'>" + _.escape(tip) + "</a>";
		}
		else {
			this.Test = "<a style='white-space: normal;' title='" + _.escape(tip) + "' href='" + path + file + this.qdpk1 + "&ultrastatus=" + ultraStatus + "'  ' target='" + _.escape(tip) + "' class='popup' onclick='popTests(this,event,isOracle); return false;'>" + _.escape(tip) + "</a>";
		}
	}
}

class rubricsListRow {
	constructor(x) {
		this.qdpk1 = x.qdpk1;
		this.rtip = x.rtitle;
		this.Name = x.rtitle;
		this.qtype = x.qtype;
		this.pk1 = x.pk1;
		this.title = x.title;
		this.CourseName = x.Course_Name;
		this.CourseID = x.Course_ID;
		this.avail = x.avail;
		this.score = x.score;
		this.Scored = x.scored;
		this.g = x.g;
		this.Date = x.gmdate.substring(0, 10);
		this.possible = x.possible;
		this.gmpk1 = x.gmpk1;
		this.ultraStatus = x.ultrastatus;
		this.Assignment = x.title;
		this.N = 1;
		this.id = x.qdpk1+'xxx'+x.gmpk1;
		this.rapk1 = x.rapk1;
		this.rrows = x.rrows;
		this.index = -1;
		this.service_level = x.service_level;
		this.rtitle = `<a>${this.rtip}</a>`;
		this.term = x.term;
		this.ncols = x.ncols;
		this.nrows = x.rrows.length;
		this.rtype = x.rtype;
	}
	Init(i) {
		this.index = i;
		this.rtitle = `<a style="white-space:normal;" title="${_.escape(this.rtip)}" href="${EAC.url}EacRubrics.html?report=${_.escape(this.Name)}" target="_blank" class="popup" onclick="popRubrics(this,event,${i})">${_.escape(this.rtip)}</a>`;
	}
}

function Destroy(...msg) {
	while (document.body.lastChild) document.body.removeChild(document.body.lastChild);
	var div = document.createElement('div');
	div.setAttribute('style', 'margin:auto');
	div.innerHTML = msg.map(x=>`<p>${x}</p>`).join('');
	document.body.appendChild(div);
	console.log(msg.join('\n'));
	return;
}
class EACModes {
	constructor() {
		this.modes = [];
		this.courses = [];
		this.node = true;
	}
	makeModes(modes, outmgrind) {
		this.modes=modes.sort();
		mainscope.modes = this.modes.map(x => x.toLowerCase());
		if (permissions.ot && (oaUser || mainscope.modes.includes('enterprise'))) {
			mainscope.showOutcomes = true;
			if (dashTabs.length==0 && nReady) mainscope.loadTab('outcomes');
		} else if (dashTabs.length==0) Destroy($L.msg.permission, $L.msg.contact);
		if (!mainscope.modes.includes(mainscope.settings.mode)){
			for (let mode of ['administrator', 'enterprise', 'instructor']) {
				if (mainscope.modes.includes(mode)) {
					mainscope.settings.mode = mode;
					mainscope.mode = mode;
					break;
				}
			}
		}
		outmgrShow = outmgrind;
		//options = "";
		//doptions = "";
		mainscope.programs = progs;
		mainscope.program = 0;
		mainscope.showNodes = progs.length>1&&(isDebug()||getShowDomains(bburl));
		mainscope.$apply();
	}
}
