/*
getInstructors
2dad64f6-97cd-4409-8370-a3cd43f22b33
getTheCats
2be01e59-3c48-4dbd-9dd4-385ea5583bca
54465048-20ce-4ffd-9468-92c01d89ec9d
getSimpleTest
2CED99A5-7A2F-4697-AE12-8818EC8E625F
4c87d0c2-9cee-4bb6-b89d-5ea137202f61
7d302cde-0965-4a63-9734-ddec8ce0ce8f
getSimpleTest_r_first
0D147BDB-2BF7-4223-9024-F21EB11CCC74
B10D2A7B-B5C9-4826-A85D-BEBF76B7F7A6
9B1491D7-AAA8-4475-AEFB-7E3251161AE9
getSimpleTest_r_first_gmpk1
C2D1ADD8-BC94-4E58-9299-3D8629E0DD5E
2A91482B-0598-426E-ACDB-431A168C56C1
ae46883d-87c3-4ac0-bbb8-0795bf80495d
getTestResults
b4e2e457-e27b-4d4f-ba2c-da8b23c5740b
143A4CC9-2029-4D03-B26C-D68832040682
668429ab-931b-4749-a02d-e2b2d1a91fc4
6AB6A813-2ED1-46A8-8A78-AC3FE621A598
B6B1AC7F-9F1A-4651-9CC7-855239B5183F
doCats
9af566f0-b771-4738-8518-beea00fce08f
32e4b538-7187-4174-bac2-0bd1fc4bc735
92778475-9765-486d-97e5-6787e098f1e9
c319573c-9159-4b03-a1d1-0dc7d3a1eddb
ae3f911d-4b49-4290-8b00-3e562a929329
f96583fc-5d9a-4e4b-9070-d91f2c36b2e6
21fefb1b-b388-490b-becf-92ff20655c94
0b9cb13d-710b-448e-bbf5-9266b0cf8f6f
af4cd664-51d8-4097-b77c-7dd894e89881
23659802-0377-43e5-aef5-09ea93e5be56
505a7958-1865-4680-9953-4493439f2159
29ec9258-8c3c-436a-82fd-b271334fce54
11ba2fed-94dc-4cb0-917b-59a05ef0b9c9
765ac036-6941-48a0-a3c1-89586bdb58ea
33d90389-e6ed-463f-9764-89f4596ad6eb
6421cbe5-d34b-4bcc-9b8b-bae2043c3c9b
0d3aa6ef-40d7-45ea-ad65-d2e1d5d7f536
*/

/* xml to json replacements
\$\(([\w\[\]\.]+)\)\.children\("([^"]+)"\)\.text\(\) -> $1.$2
\$\(([\w\[\]\.]+)\)\.children\("([^"]+)"\)\.text\(([^\(\)]+)\) -> $1.$2 = $3
*/

const EPSILON = 0.000001;

getInstructors = function (crsData, postCourse, qds, gmpk1) { // getInstructors(crsData, postCourse, qds, gmpk1);
	// C_INSTRUCTORS
	var user_id = [];
	var batch_uid = [];
	var cpk1s = [];
	var instructs = [];
	var cpk1 = Enumerable.from(crsData).select(function (x) {
		return x.cpk1;
	}).toArray().join(',');
	var csql = "2dad64f6-97cd-4409-8370-a3cd43f22b33";   //C_INSTRUCTORS
	var ps = {}; ps["@cpk1s"] = cpk1;
	var theUrl = getSqlUrl(bburl);
	var params = getParams(host, bburl);

	params.contents = fixObj(csql);
	params.ps = fixObj(JSON.stringify(ps));
	var prom = ajGetSql(theUrl, params, false).done((jary) => {
		jary.forEach((row, i) => {
			cpk1s.push(row.cpk1);
			instructs.push(row.lastname + ', ' + row.firstname);
			user_id.push(row.user_id);
			batch_uid.push(row.batch_uid);
		});
	});

	$.when(prom).done(function () {
		for (var i = 0, il = crsData.length; i < il; i++) {
			for (var j = 0, jl = cpk1s.length; j < jl; j++) {
				if (crsData[i].cpk1 == cpk1s[j]) {
					crsData[i].instructors += (crsData[i].instructors.length > 0) ? '; ' + instructs[j] : instructs[j];
					crsData[i].batch_uid.push(batch_uid[j]);
					crsData[i].user_id.push(user_id[j]);
					// break;
				}
			}
		}
		postCourse(crsData, qds, gmpk1);
	});
}

getTheCats = function (qdpks, holdQCats, qpk1_cpk1) {// getTheCats(qps, holdQCats, qpk1_cpk1);
	if ((bburl.indexOf('gvtc.') > -1 || bburl.indexOf('southernregional.') > -1)) {
		//getTheCatsGA(qdpks, holdQCats, qpk1_cpk1);
	} else {
		var host = getHost();
		var theUrl = getSqlUrl(bburl);
		var params = getParams(host, bburl);
		var theSql;
		var theQdpks = qdpks.split(',');
		var data = null;
		var sqls = [];
		var pps = [];
		var ps = {};
		var detailPromise = [];
		var theData = [];
		if (isDebug() && host.indexOf("eac") === -1) {
			console.log("bb cats  " + sql);
		}
		var ql = theQdpks.length;
		var max = 100;
		var qs = [];
		while (theQdpks.length > 0) {
			qs.push(theQdpks.shift());
			if (qs.length >= max) {

				sqls.push("2be01e59-3c48-4dbd-9dd4-385ea5583bca"); // GOALS_BY_QDPK1_MARSHALL
				ps["@qdpks"] = qs.join(',');
				pps.push(ps);
				ps = {};
				sqls.push("54465048-20ce-4ffd-9468-92c01d89ec9d");  //CATEGORY_BY_QDPK1_DEMO
				ps["@qdpks"] = qs.join(',');
				pps.push(ps);
				qs = [];
			}
		}
		if (qs.length > 0) {
			sqls.push("2be01e59-3c48-4dbd-9dd4-385ea5583bca"); // GOALS_BY_QDPK1_MARSHALL
			ps = {};
			ps["@qdpks"] = qs.join(',');
			pps.push(ps);
			ps = {};
			sqls.push("54465048-20ce-4ffd-9468-92c01d89ec9d");  // CATEGORY_BY_QDPK1_DEMO
			ps["@qdpks"] = qs.join(',');
			pps.push(ps);
		}
		for (var i = 0; i < sqls.length; i++) {
			params.contents = fixObj(sqls[i]);
			params.ps = fixObj(JSON.stringify(pps[i]));
			detailPromise.push(ajGetSql(theUrl, params, true).done((jary) => {
				theData = theData.concat(jary);
			}));
		}


		$.when.apply(null, detailPromise).done(function () {
			theData.sort(function (a, b) {
				return (a.category < b.category) ? -1 : (a.category > b.category) ? 1 : 0;
			});
			for (var i = 0; i < theData.length; i++) {
				var ccat = TAG(theData[i].category);
				if (ccat.lastIndexOf('$$') > -1) ccat = ccat.split('$$')[0];
				theData[i].category = ccat;
			}
			holdQCats(theData);
		});
	}
}

getSimpleTest = function (qdpk1, holdQData, rubricHeaders, domain_name, domain_pk1, allTests1, qds) {
	if (qdpk1.indexOf('*') > -1) {
		getSimpleTestPool(qdpk1, holdQData, rubricHeaders, domain_name, domain_pk1);
	} else {
		var dt;
		var _raw;
		var sql = '';
		var sqlPs = {};
		//if (dbtype === 'pgsql') {
		sql = "2CED99A5-7A2F-4697-AE12-8818EC8E625F"; //SIMPLE_TEST_PRE_QDD_POST;
		// } else {
		// 	sql = "5de35892-4598-4d40-95c1-2ea9ef10457d";  //SIMPLE_TEST_PRE_QDD;
		// }
		sqlPs['@qdpk1'] = qdpk1;
		sqlPs['@qddData'] = 'qdd.data';
		sqlPs['@qdData'] = 'qd.data';
		var sqlPromise;
		var detailPromisec = [];
		var cdata = [];
		var data = [];
		var theData = [];
		var mySqls = [];
		var qpks = [];
		var rbs;
		var qbs = [];;
		var newQpks = [];
		var assess = [];
		var mydata = [];
		params.contents = fixObj(sql);
		params.ps = fixObj(JSON.stringify(sqlPs));
		sqlPromise = ajGetSql(theUrl, params, true).done((jary) => {
			var tmp = jary.filter(x => x.kind_id < 19);
			tmp.forEach((el) => {
				if (el.maxscore <= 0) el.maxscore = EPSILON.toString();
				if (el.ultra_status === 'U') {
					el.kind_id = kindToUltra(el.kind_id);
				}
				var ar = qpks.filter((e) => el.pk1 === e.pk1 && el.gmpk1 === e.gmpk1);
				if (ar.length === 0) {
					el.gtitle = TAG(el.gtitle);
					qpks.push(el);
				}
			});
			assess = qpks.filter((e) => e.bbmd_asi_type == "1");
			if (assess.length > 0) {
				for (var i = 0, il = assess.length; i < il; i++) {
					var g = assess[i].cgmpk1;
					if (newQpks.indexOf(g) === -1) {
						assess[i].gtitle = TAG(assess[i].gtitle);
						newQpks.push(assess[i].gmpk1);
					}
				}
			}
			rbs = qpks.filter((e) => e.bbmd_sectiontype == "3");
			if (rbs.length === 0) {
				qbs = qpks.filter((e) => e.bbmd_sectiontype == "4");
			}
		});
		$.when(sqlPromise).done(function () {
			if (rbs.length > 0) {
				console.log("rbs found - doing getSimpleTest_r_first");
				getSimpleTest_r_first(qdpk1, holdQData, domain_name, domain_pk1);

			}
			else {
				if (assess.length > 0) {
					getSimpleTest_r_first_gmpk1(newQpks.join(','), holdQData, domain_name, domain_pk1);
					console.log("no rbs found - doing getSimpleTest_r_first");
				} else {
					if (qbs.length === 0) {
						var qrpairs = [];
						qpks.forEach((el) => {
							if (el.rpk1.length > 0) {//pk1
								qrpairs.push('(ae.qti_asi_data_pk1 =' + el.pk1 + ' and r.pk1 = ' + el.rpk1 + ')');
							}
						});
						if (qrpairs.length > 0) {
							var myproms = [];
							var rpk1sql = "4c87d0c2-9cee-4bb6-b89d-5ea137202f61"; //GETRCHOICES;
							rpk1sqlPs = {};
							rpk1sqlPs['@qrpairs'] = qrpairs.join(' or ');
							//  console.log("GETRCHOICES " + rpk1sql);
							params.contents = fixObj(rpk1sql);
							params.ps = fixObj(JSON.stringify(rpk1sqlPs));
							myproms.push(ajGetSql(theUrl, params, true).done((jary) => {
								var tmp = jary;
								var qdpk1s = [];
								var qdp = '';
								var rchoices = [];
								var qdp0 = tmp[0].qdpk1;
								qdpk1s.push(qdp);
								for (var r = 0; r < tmp.length; r++) {// qdpk1  rchoices 
									if (tmp[r].qdpk1 != qdp0) {
										var rcs = qdp0 + '__' + rchoices.join('**');
										for (var s = 0; s < qpks.length; s++) {
											if (qpks[s].pk1 == qdp0) {
												qpks[s].rchoices = rchoices.join('**');
												rchoices = [];
												qdp0 = tmp[r].qdpk1;
												break;
											}
										}
									}
									var rc = tmp[r].rchoices;
									rc = rc.replace('&lt;br&gt;', ' ');
									if (!(typeof rubricHeaders === 'undefined')) {
										rc = rc.replace('grid.column1.label', rubricHeaders['grid.column1.label']).replace('grid.column2.label', rubricHeaders['grid.column2.label']).replace('grid.column3.label', rubricHeaders['grid.column3.label']);
									} else {
										rc = rc.replace('grid.column1.label', 'DefaultColumn1').replace('grid.column2.label', 'DefaultColumn2').replace('grid.column3.label', 'DefaultColumn3');
									}
									if (rchoices.indexOf(rc) < 0) {
										rchoices.push(rc);
									}
								}
								if (rchoices.length > 0) {
									for (var s = 0; s < qpks.length; s++) {
										if (qpks[s].pk1 == qdp0) {
											qpks[s].rchoices = rchoices.join('**');
											break;
										}
									}
								}
								var r = 0;
								var qr = [];
								var count = 0;
								var qd0 = tmp[0].qdpk1;
								for (; r < tmp.length; r++) {// qdpk1  rchoices 
									if (qd0 !== tmp[r].qdpk1) {
										for (var j = 0; j < qpks.length; j++) {
											if (qpks[j].pk1 == qd0) {
												qpks[j].qr = qr.join('****');
												qr = [];
												qd0 = tmp[r].qdpk1;
												break;
											}
										}
									}
									var rubrow = tmp[r].qr;
									if (!(typeof rubricHeaders === 'undefined')) {
										for (n in rubricHeaders) {
											if (rubrow === n) {//rubricHeaders['grid.column1.label']
												rubrow = rubricHeaders[n];
												break;
											}
										}

									}
									var qqr = tmp[r].position + '. ' + rubrow;
									if (qr.indexOf(qqr) === -1) {
										qr.push(qqr);
									}
								}
								if (qr.length > 0) {
									for (var j = 0; j < qpks.length; j++) {
										if (qpks[j].pk1 == qd0) {
											qpks[j].qr = qr.join('****');
											break;
										}
									}
								}
							}));
							$.when.apply(null, myproms).done(function () {
								holdQData(qpks);
							});
						} else {
							holdQData(qpks);
						}
						return;
					} else {
						if (qbs.length > 0) {
							console.log("qbs were found");
							var proms = [];
							var rsql = [];
							var rsqls = [];
							var rsqlPs = {};
							var rsqlPss = [];
							var nsql = [];
							var qqds = [];
							for (var i = 0, il = qbs.length; i < il; i++) {
								var theData;
								var myData = qbs[i].data;
								if (myData.charAt(0) === '\\') {
									theData = hex2a(myData.substring(2));
								} else {
									if (myData.charAt(0) !== 'P') {
										theData = hex2a(myData);
									} else {
										if (typeof atob === 'undefined') {
											theData = $.base64.decode(myData);
										} else {
											theData = atob(myData);
										}
									}
								}
								var x = getXml(theData);
								var p = qbs[i].position;
								var gmpk = qbs[i].gmpk1;
								var ftNodes = x.getElementsByTagName('selection_metadata');
								for (var j = 0, jl = ftNodes.length; j < jl; j++) {
									qqds.push(ftNodes[j].textContent.split('_')[1]);
								}
								rsql = "7d302cde-0965-4a63-9734-ddec8ce0ce8f";
								rsqlPs['@qpks'] = qqds.join(',');
								if (rsqlPs['@qpks'].length === 0) {
									rsqlPs['@qpks'] = '0';
								}
								rsqlPs['@pos'] = p;
								rsqlPs['@gmpk1'] = gmpk;
								rsqls.push(rsql);
								rsqlPss.push(rsqlPs);
								var o = $.extend({}, qbs[i]);
								nsql.push(o);
								qqds = [];
							}
							qpks = $.except(qpks, qbs);
							for (i = 0, il = rsqls.length; i < il; i++) {
								var oldrow = nsql[i];
								var newrows = [];
								params.contents = fixObj(rsqls[i]);
								params.ps = fixObj(JSON.stringify(rsqlPss[i]));
								proms.push(ajGetSql(theUrl, params, true).done((jary) => {
									var newqs = jary;
									var n = 0;
									var nl = newqs.length;
									var process2 = function () {
										for (; n < nl; n++) {
											var nrow = $.extend({}, oldrow);
											var elem = newqs[n];
											nrow.pk1 = elem.pk1;
											nrow.position = elem.pos;
											nrow.gmpk1 = elem.gmpk1;
											nrow.kind_id = elem.kind_id;// bbmd_sectiontype
											nrow.bbmd_sectiontype = elem.bbmd_sectiontype;
											nrow.maxscore = elem.maxscore;
											nrow.data = elem.data;
											if (nrow.bbmd_sectiontype < 3) {
												newrows.push(nrow);
											}

											if (n + 1 < nl && n % 5 == 0) {
												console.log('pause');
												setTimeout(process2, 5);
											}
										}
									}
									process2();
									qpks = qpks.concat(newrows);
									newrows = [];
								}));
							}
							$.when.apply(null, proms).done(function () {
								console.log("proms done");
								qpks.sort(function (a, b) {
									var comp = (a.gmpk1 - b.gmpk1);
									if (comp === 0) {
										return (a.position - b.position);
									} else {
										return comp;
									}
								});
								holdQData(qpks);
							});
						}
					}

				}
			}

		});
	}
};

getSimpleTestPool = function (qdpk1, holdQData, rubricHeaders) {
	var dt;
	var _raw;
	//,148*8,149*8,154*9,155*9
	var qds = [];
	var gtitle = qdpk1.split('###')[1];
	gtitle = gtitle.replace(',', '_');
	var qtmp = qdpk1.split('###')[0].split(',');
	for (var i = 1; i < qtmp.length; i++) {
		qds.push(qtmp[i].split('*')[0]);
	}
	var sql = SIMPLE_TEST_PRE_QDD_POOL;
	sqlPs['@qdpk1'] = qds.join(',');
	sqlPs['@qddData'] = 'qdd.data';
	sqlPs['@qdData'] = 'qd.data';
	var sqlPromise;
	var detailPromisec = [];
	var cdata = [];
	var data = [];
	var theData = [];
	var mySqls = [];
	var qpks = [];
	var rbs;
	var qbs;
	var newQpks = [];
	var assess = [];
	console.log('getSimple 1 ' + sql);
	params.contents = fixObj(sql);
	sqlPromise = ajGetSql(theUrl, params, true).done((jary) => {
		jary.forEach((row) => {
			if (row.ultra_status === 'U') row.kind_id = kindToUltra(row.kind_id);
			var ar = qpks.filter((qpk) => row.pk1 === qpk.pk1 && row.gmpk1 === qpk.gmpk1);
			if (ar.length === 0) {
				row.gtitle = gtitle;
				qpks.push(row);
			}
		});
		assess = qpks.filter((qpk) => qpk.bbmd_asi_type == "1");
		if (assess.length > 0) {
			for (var i = 0, il = assess.length; i < il; i++) {
				if (newQpks.indexOf(assess[i].gmpk1) === -1) {
					assess[i].gtitle = TAG(assess[i].gtitle);
					newQpks.push(assess[i].gmpk1);
				}
			}
		}
		rbs = qpks.filter((qpk) => qpk.bbmd_sectiontype == "3");
		if (rbs.length === 0) {
			qbs = qpks.filter((qpk) => qpk.bbmd_sectiontype == "4");
		}
	});
	$.when(sqlPromise).done(function () {
		if (rbs.length > 0) {
			console.log("rbs found - doing getSimpleTest_r_first");
			getSimpleTest_r_first(qdpk1, holdQData);
		}
		else {
			if (assess.length > 0) {
				getSimpleTest_r_first_gmpk1(newQpks.join(','), holdQData);
				console.log("no rbs found - doing getSimpleTest_r_first");
			} else {
				if (qbs.length === 0) {
					// console.log("no qbs found");
					var qrpairs = [];
					qpks.forEach((qpk) => {
						//(ae.qti_asi_data_pk1 =92 and r.pk1 = 6 ) and (ae.qti_asi_data_pk1 =92 and r.pk1 = 6 ) " +
						if (qpk.rpk1.length > 0) {//pk1
							qrpairs.push(`(ae.qti_asi_data_pk1 = ${qpk.pk1} and r.pk1 = ${qpk.rpk1})`);
						}
					});
					if (qrpairs.length > 0) {
						var myproms = [];
						var rpk1sql = GETRCHOICES.replace('@qrpairs', qrpairs.join(' or ')); //@conop
						console.log("GETRCHOICES " + rpk1sql);
						params.contents = fixObj(rpk1sql);
						myproms.push(ajGetSql(theUrl, params, true).done((jary) => {
							var tmp = jary;
							var qdpk1s = [];
							var qdp = '';
							var rchoices = [];
							var qdp0 = tmp[0].qdpk1;
							qdpk1s.push(qdp);

							for (var r = 0; r < tmp.length; r++) {// qdpk1  rchoices 
								if (tmp[r].qdpk1 != qdp0) {
									var rcs = qdp0 + '__' + rchoices.join('**');
									for (var s = 0; s < qpks.length; s++) {
										if (qpks[s].pk1 == qdp0) {
											qpks[s].rchoices = rchoices.join('**');
											rchoices = [];
											qdp0 = tmp[r].qdpk1;
											break;
										}
									}
								}
								var rc = tmp[r].rchoices;
								rc = rc.replace('&lt;br&gt;', ' ');
								if (!(typeof rubricHeaders === 'undefined')) {
									rc = rc.replace('grid.column1.label', rubricHeaders['grid.column1.label']).replace('grid.column2.label', rubricHeaders['grid.column2.label']).replace('grid.column3.label', rubricHeaders['grid.column3.label']);
								} else {
									rc = rc.replace('grid.column1.label', 'DefaultColumn1').replace('grid.column2.label', 'DefaultColumn2').replace('grid.column3.label', 'DefaultColumn3');
								}
								if (rchoices.indexOf(rc) < 0) {
									rchoices.push(rc);
								}
							}
							if (rchoices.length > 0) {
								for (var s = 0; s < qpks.length; s++) {
									if (qpks[s].pk1 == qdp0) {
										qpks[s].rchoices = rchoices.join('**');
										break;
									}
								}
							}
							var r = 0;
							var qr = [];
							var count = 0;
							var qd0 = tmp[0].qdpk1;
							for (; r < tmp.length; r++) {// qdpk1  rchoices 
								if (qd0 !== tmp[r].qdpk1) {
									for (var j = 0; j < qpks.length; j++) {
										if (qpks[j].pk1 == qd0) {
											qpks[j].qr = qr.join('****');
											qr = [];
											qd0 = tmp[r].qdpk1;
											break;
										}
									}
								}
								var rubrow = tmp[r].qr;
								if (!(typeof rubricHeaders === 'undefined')) {
									for (n in rubricHeaders) {
										if (rubrow === n) {//rubricHeaders['grid.column1.label']
											rubrow = rubricHeaders[n];
											break;
										}
									}
								}
								var qqr = tmp[r].position + '. ' + rubrow;
								if (qr.indexOf(qqr) === -1) {
									qr.push(qqr);
								}
							}
							if (qr.length > 0) {
								for (var j = 0; j < qpks.length; j++) {
									if (qpks[j].pk1 == qd0) {
										qpks[j].qr = qr.join('****');
										break;
									}
								}
							}
						}));
						$.when.apply(null, myproms).done(function () {
							holdQData(qpks);
						});
					} else {
						holdQData(qpks);
					}
					return;
				} else {
					if (qbs.length > 0) {
						console.log("qbs were found");
						var proms = [];
						var rsql = [];
						var nsql = [];
						var qqds = [];
						for (var i = 0, il = qbs.length; i < il; i++) {
							var theData;
							var myData = qbs[i].data;
							if (myData.charAt(0) === '\\') {
								theData = hex2a(myData.substring(2));
							} else {

								if (myData.charAt(0) !== 'P') {
									theData = hex2a(myData);

								} else {
									if (typeof atob === 'undefined') {
										theData = $.base64.decode(myData);
									} else {
										theData = atob(myData);
									}
								}
							}
							var x = getXml(theData);
							var p = qbs[i].position;
							var gmpk = qbs[i].gmpk1;
							var ftNodes = x.getElementsByTagName('selection_metadata');
							for (var j = 0, jl = ftNodes.length; j < jl; j++) {
								qqds.push(ftNodes[j].textContent.split('_')[1]);
							}
							rsql.push(QBSQL.replace("@qpks", qqds.join(',')).replace("@pos", p).replace("@gmpk1", gmpk));
							nsql.push($(qbs[i]).clone());
							qqds = [];
						}
						qpks = $.except(qpks, qbs);
						for (i = 0, il = rsql.length; i < il; i++) {
							var oldrow = nsql[i];
							var newrows = [];
							params.contents = fixObj(rsql[i]);
							proms.push(ajGetSql(theUrl, params, true).done((jary) => {
								var newqs = jary
								var n = 0;
								var nl = newqs.length;
								var process2 = function () {
									for (; n < nl; n++) {
										var nrow = $(oldrow).clone();
										var elem = newqs[n];
										nrow.pk1 = elem.pk1;
										nrow.position = elem.pos;
										nrow.gmpk1 = elem.gmpk1;
										nrow.kind_id = elem.kind_id; // bbmd_sectiontype
										nrow.bbmd_sectiontype = elem.bbmd_sectiontype;
										nrow.maxscore = elem.maxscore;
										nrow.data = elem.data;
										newrows.push(nrow);
										if (n + 1 < nl && n % 5 == 0) {
											console.log('pause');
											setTimeout(process2, 5);
										}
									}
								}
								process2();
								qpks = qpks.concat(newrows);
								newrows = [];
							}));
						}
						$.when.apply(null, proms).done(function () {
							console.log("proms done");
							qpks.sort(function (a, b) {
								var comp = (a.gmpk1 - b.gmpk1);
								if (comp === 0) {
									return (a.position - b.position);
								} else {
									return comp;
								}
							});
							// console.log("final clause of simle test");
							holdQData(qpks);
						});
					}
				}
			}
		}
	});
};

getSimpleTest_r_first = function (qdpk1, holdQData, domain_name, domain_pk1) {
	var host = getHost();
	var theUrl = getSqlUrl(bburl);
	var params = getParams(host, bburl);
	var sql = isLaureate(bburl) ? "B10D2A7B-B5C9-4826-A85D-BEBF76B7F7A6" : "0D147BDB-2BF7-4223-9024-F21EB11CCC74";
	var sqlPs = {};
	sqlPs["@qdpk1"] = qdpk1;
	params.contents = fixObj(sql);
	params.ps = fixObj(JSON.stringify(sqlPs));
	ajGetSql(theUrl, params, true).done((jary) => {
		var data = [];
		var gmsx = jary;
		if (typeof gmsx !== 'undefined') {
			data = _.isArray(gmsx) ? gmsx : $.makeArray(gmsx);
			var qdpk1s = Enumerable.from(data).select(function (x) { return '(qd.pk1 = ' + x.qdpk1 + ' and gm.pk1 = ' + x.gmpk1 + ')'; }).toArray();
		}
		var sql = '9B1491D7-AAA8-4475-AEFB-7E3251161AE9';
		var sqlPs = {};
		sqlPs["@qdpk1"] = qdpk1s.join(' or');
		sqlPs["@qddData"] = "qdd.data";
		sqlPs["@qdData"] = "qd.data";
		var detailPromisec = [];
		var data = [];
		var theData = [];
		console.log('getSimple 1 ' + sql);
		params.contents = fixObj(sql);
		params.ps = fixObj(JSON.stringify(sqlPs));
		detailPromisec.push(ajGetSql(theUrl, params, true).done((jary) => {
			var mydatax = jary;
			if (_.isArray(mydatax) && mydatax.length) theData = mydatax;
			else alert($L.msg.no_qs);
		}));
		$.when.apply(null, detailPromisec).done(function () {
			holdQData(theData);
		});
	});
}

getSimpleTest_r_first_gmpk1 = function (gmpk1, holdQData, domain_name, domain_pk1) {
	var host = getHost();
	var theUrl = getSqlUrl(bburl);
	var params = getParams(host, bburl);
	var dt;
	var _raw;
	
	//n
	//SIMPLE_TEST_GMPK1
	var sql = "C2D1ADD8-BC94-4E58-9299-3D8629E0DD5E";
	var sql2 = "2A91482B-0598-426E-ACDB-431A168C56C1";
	
	var ps = {}; ps["@gmpk1"] = gmpk1;//     .replace("@gmpk1", gmpk1);
	var detailPromise = [];
	var detailPromisec = [];
	var cdata = [];
	var data = [];
	var theData = [];
	var mySqls = [];
	var qpks = [];
	var theSql = "ae46883d-87c3-4ac0-bbb8-0795bf80495d"; //Q_DATA;
	var qpk1s = [];
	var pps = [];
	var cpk1s = "";
	var count = 0;
	var proms = [], proms2 = [];
	var part1 = [], part2 = [];
	
	params.contents = fixObj(sql);
	params.ps = fixObj(JSON.stringify(ps));
	//  console.log('SIMPLE_TEST_GMPK1 = ' + sql);
	proms.push(ajGetSql(theUrl, params, true).done((jary) => {
		var dx = jary;
		if (typeof dx !== 'undefined') {
			if (typeof dx.length === 'undefined') {
				part1 = $.makeArray(dx);
			} else {
				part1 = dx;
			}
		}
	}));
	$.when.apply(null, proms).done(function () {
		var qrrpk1s = part1.map(x => x.qrrpk1);
		if (qrrpk1s.length > 0) {
			params.contents = fixObj(sql2);
			params.ps = fixObj(JSON.stringify({"@gmpk1":qrrpk1s.join()}));
			proms2.push(ajGetSql(theUrl, params, true).done((jary2) => {
				var dx2 = jary2
				if (typeof dx2 !== 'undefined') {
					if (typeof dx2.length === 'undefined') {
						part2 = $.makeArray(dx2);
					} else {
						part2 = dx2;
					}
					for (let p1 of part1) {
						let p2s = part2.filter(y => y.qrrpk1 == p1.qrrpk1);
						for (let p2 of p2s) {
							let q = {};
							Object.assign(q, p1, p2);
							delete q.qrrpk1;
							if (!qpks.some(x => _.isMatch(x, q)))qpks.push(q);
						}
					}
				}
				qpks.sort((a,b) => a.pk1-b.pk1 || a.cpk1-b.cpk1 || a.gmpk1-b.gmpk1);
				var ps = {};
				for (var i = 0, il = qpks.length; i < il; i++) {
					qpk1s.push(qpks[i].pk1);

					if (qpk1s.length >= BbMaxCourseAccess) {
						sql = theSql
						//.replace("@qpks", qpk1s.join(','));
						ps["@qpks"] = qpk1s.join(',');
						mySqls.push(sql);
						pps.push(ps);
						qpk1s = [];
						ps = {};
					}
				}
				if (qpk1s.length > 0) {
					sql = theSql;
					ps = {};
					ps["@qpks"] = qpk1s.join(',');
					mySqls.push(sql);
					pps.push(ps);
				}
			}));
			$.when.apply(null, proms2).done(function () {
				for (i = 0, sqls = mySqls.length; i < sqls; i++) {
					params.contents = fixObj(mySqls[i]);
					params.ps = fixObj(JSON.stringify(pps[i]));
					detailPromise.push(ajGetSql(theUrl, params, true).done((jary) => {
						var d = [];
						var dx = jary;
						if (typeof dx !== 'undefined') {
							if (typeof dx.length === 'undefined') {
								d = $.makeArray(dx);
							} else {
								d = dx;
							}
						}
						data = data.concat(d);
					}));
				}
				$.when.apply(null, detailPromise).done(function () {
					data.sort(function (a, b) {
						return comp = a.pk1 - b.pk1;
					});
					//quick_sort(theData);

					for (i = 0, il = qpks.length; i < il; i++) {
						qpks[i].data = data[i].data;
					}

					qpks.sort(function (a, b) {
						var comp = a.cpk1 - b.cpk1;
						if (comp === 0) {
							comp = a.gmpk1 - b.gmpk1;
						}
						if (comp === 0) {
							comp = a.parent_pk1 - b.parent_pk1;
						}
						if (comp === 0) {
							comp = a.position - b.position;
						}
						return comp;
					});
					holdQData(qpks);
				});
			});
		}
	});
};

getTestResults = function (gmpk1, qds, parseXMLR, isPool, domain_pk1, showDomains, to_date, from_date, allTests1, qds1) {
	notify('');
	var host = getHost();
	var theUrl = getSqlUrl(bburl);
	var params = getParams(host, bburl);
	var _raw;
	var theSql;
	var apk1s = [];
	var data = [];
	var mydata = [];
	var rdata = [];
	var theData = [];
	var sqls = [];
	var sqlPs = {};
	if (typeof to_date === 'undefined' || typeof from_date === 'undefined') { //date.setMonth(date.getMonth() – 12);
		to_date = new Date();
		from_date = new Date();
		from_date.setTime(to_date.getTime() - 10 * 365 * 24 * 60 * 60 * 1000);  //.setMsetMonth(from_date.getMonth - 120);
	}
	var td = getSqlDate(to_date);
	var fd = getSqlDate(from_date);
	if (gmpk1.indexOf(',') === ',') {
		gmpk1 = gmpk1.substring(1);
	}
	var sql = "b4e2e457-e27b-4d4f-ba2c-da8b23c5740b";            //SIMPLE_RESULTS_PART1
	var sqlPs = {}; sqlPs["@gmpk1"] = gmpk1;
	// if (bburl.indexOf("luonline") > -1) {
	// 	sqlPs["--@H"] = " ";
	// } else {
	// 	sqlPs["--@H"] = " -- ";
	// }
	if (survey) {
		sqlPs["--@S"] = " -- ";
	} else {
		sqlPs["--@S"] = "  ";
	}
	sqlPs["@from_date"] = fd;
	sqlPs["@to_date"] = td;
	if (showDomains) {
		if (domain_pk1 != 0) {
			var dd = makeDomain(domain_pk1);
			sqlPs['--@D'] = '  ';
			sqlPs['@domain_pk1'] = dd.split('***')[0];
		}
		else {
			sqlPs['--@D'] = ' -- ';
			sqlPs['@domain_pk1'] = 0;
		}
	} else {
		sqlPs['--@D'] = ' -- ';
		sqlPs['@domain_pk1'] = 0;
	}
	var detailPromise = [];
	var prom = [];
	if (isDebug() && host.indexOf("eac") === -1) {
		console.log("result part 1 " + sql);
	}
	params.contents = fixObj(sql);
	params.ps = fixObj(JSON.stringify(sqlPs));
	prom.push(ajGetSql(theUrl, params, true).done((jary) => {
		var mydatax = jary;
		if (typeof mydatax !== 'undefined') {
			if (typeof mydatax.length === 'undefined') {
				mydata = $.makeArray(mydatax);
			} else {
				mydata = mydatax;
			}
		}
		var qpks = mydata;
		qpks.forEach((elem) => {
			apk1s.push(elem.fbid);
		});
	}));
	var atmp = [];
	var count = 0;

	var theSqlPss = [];
	$.when.apply(null, prom).done(function () {
		var theSqlPs = {};
		for (var a = 0; a < apk1s.length; a++) {
			atmp.push(apk1s[a]);
			if ((atmp.length >= 4 * BbMaxCourseAccess / 2) || a == (apk1s.length - 1)) {
				theSqlPs = {};
				if (typeof isPool !== 'undefined' && isPool) {
					theSql = "143A4CC9-2029-4D03-B26C-D68832040682"; // SIMPLE_RESULTS_PART2_POOL;
					theSqlPs["@apk1s"] = atmp.join(','); //.replace("@qds", qdsString);
				} else {
					if (isLaureate(bburl)) {
						theSql = "668429ab-931b-4749-a02d-e2b2d1a91fc4";
						var laurob = " dbms_lob.substr(qr.data, 2000) as data1, dbms_lob.substr(qr.data, 2000, 2001) as data2, dbms_lob.substr(qr.data, 2000, 4001) as data3";
						theSqlPs["@qrdata"] = laurob;
					} else {
						theSql = "6AB6A813-2ED1-46A8-8A78-AC3FE621A598";
					}
					// SIMPLE_RESULTS_PART2;
					theSqlPs["@apk1s"] = atmp.join(',');
					if (dbtype === 'oracle' || dbtype === 'pgsql') {
						theSqlPs['--@O'] = ' ';
					} else {
						theSqlPs['--@S'] = ' ';
					}
					if (dbtype === 'pgsql') {
						theSqlPs['--AA@P'] = ' ';
					} else theSqlPs['--AA@P'] = ' -- ';
					if (dbtype === 'oracle') {
						theSqlPs['--AA@O'] = ' ';
					} else theSqlPs['--AA@O'] = ' -- ';
					if (domain_pk1 != 0) {
						var dd = makeDomain(domain_pk1);
						theSqlPs['--@G'] = ' '
						theSqlPs['@domain_name'] = '';
						theSqlPs['@domain_pk1'] = dd.split('***')[0];
						theSqlPs['@fs1'] = dd.split('***')[1];
						theSqlPs['@fs2'] = dd.split('***')[2];
						theSqlPs['@fs3'] = dd.split('***')[3];
					} else {
						theSqlPs['--@G'] = '-- '
						theSqlPs['@domain_name'] = '';
						theSqlPs['@domain_pk1'] = 0;
						theSqlPs['@fs1'] = 0;
						theSqlPs['@fs2'] = 0;
						theSqlPs['@fs3'] = 0;
					}
					if (showDomains) {
						theSqlPs['--@D'] = ' ';
					} else {
						theSqlPs['--@D'] = ' -- ';
					}
					theSqlPs['@to_date'] = td;
					theSqlPs['@from_date'] = fd;
					// if (bburl.indexOf("luonline") > -1) {
					// 	theSqlPs['--@H'] = ' ';
					// } else {
					// 	theSqlPs['--@H'] = ' -- ';
					// }
				}
				if (!isLaureate(bburl)) {
					var field = getSqlBigString("qr.data");
					theSqlPs['@qrdata'] = field;
				}
				theSqlPs['@gmpk1'] = gmpk1;
				if (isDebug()) {
					theSqlPs['@dems'] = ' ';
				} else {
					theSqlPs['@dems'] = ' -- ';
				}
				console.log("part 2 " + theSql);
				sqls.push(theSql);
				theSqlPss.push(theSqlPs);

				count = 0;
				atmp = [];
			}
		}
		theData = [];
		var mydata = [];
		for (i = 0, j = sqls.length; i < j; i++) {
			params.contents = fixObj(sqls[i]);
			params.ps = fixObj(JSON.stringify(theSqlPss[i]));
			detailPromise.push(ajGetSql(theUrl, params, true).done((jary) => {
				var mydatax = jary;
				if (typeof mydatax !== 'undefined') {
					if (typeof mydatax.length === 'undefined') {
						mydata = $.makeArray(mydatax);
					} else {
						mydata = mydatax;
					}
				}
				theData = theData.concat(mydata);
			}));
		}
		$.when.apply(null, detailPromise).done(function () {
			if (theData.length === 0) {
				if (UI == 2) {
					mainscope.Warn($L.msg.responses);
				}
				throw "No results! Have all responses been graded?";
			}
			let uniqRpk1s = _.uniq(theData.map(x => x.rpk1)).filter(x => x);
			if (uniqRpk1s.length === 0) {
				performATask(theData, parseXMLR);
				return;
			}
			var rprom = [];
			var sql = "B6B1AC7F-9F1A-4651-9CC7-855239B5183F";// TEST_RUBRIC_RESULTS_NEW;
			let param = { '@rpk1s': uniqRpk1s.join() };
			var dr = [];
			params.contents = fixObj(sql);
			params.ps = fixObj(JSON.stringify(param));
			rprom.push(ajGetSql(theUrl, params, true).done((jary) => {
				var mydatax = jary;
				if (typeof mydatax !== 'undefined') {
					mydata = _.isArray(mydatax) ? mydatax : $.makeArray(mydatax);
				}
				dr = mydata;
				var rpos = [];
				var thiscol = [];
				var bbmd_grade = 0;
				var tot = 0;
				var qpk1 = '';
				var qrpk1 = '';
				var rcols = null;
				for (var d = 0; d < dr.length; d++) {
					var md = dr[d];
					if (md.qrpk1 !== qrpk1) {
						rpos = [];
						thiscol = [];
						qrpk1 = md.qrpk1;
					}
					//  qrpk1 = md.qrpk1;
					qpk1 = md.qdpk1;
					rpos.push(md.rrow);
					thiscol.push(md.thiscol);
					for (var e = 0, dl = theData.length; e < dl; e++) {
						var mo = theData[e];
						if (mo.qrpk1 == qrpk1 &&
							mo.qpk1 == qpk1) {
							mo.rpos = rpos.join('*');
							mo.thiscol = thiscol.join('*');
							break;
						}
					}
				}
			}));
			$.when.apply(null, rprom).done(function () {
				theData.forEach((el) => {
					el.r_name = el.r_lastname + ', ' + el.r_firstname;
					if (isLaureate(bburl) && (typeof el.data1 !== 'undefined')) {
						el.data = el.data1 + el.data2 + el.data3;
					}
					if (showDomains && el.dbatch.length > 0) {
						el.program = fetchProgram(el.program);
					} else {
						el.program = '--';
					}
				});
				performATask(theData, parseXMLR);
			});
		});
	});
}

doCats = function (ctuples, dtuples, isOracle) {
	var params = getParams(getHost(), bburl);
	var getCrsMains;
	var allRows = [];
	var allTupleRows = [];
	var rows = "";
	var grows = [];
	var goals = [];
	var qdpk1s = [];
	var cpk1s = [];
	var gtuples = [];
	var allCtupleRows = "";
	var allCtupleGoals = "";
	var cpk1s;
	var cats;
	var newCatPk1s = [];
	var insSql = [];
	var newGetNextSql = [];
	var crsMainsMissing;
	var getItems;
	var itemsMissing;
	var cpk1s_cats = [];
	var cpk1s_cats_qpk1s = [];
	var catpk1s_qdpk1s = [];
	var gsql = '';
	var doingGs = false;
	ctuples.forEach((ctuple) => {
		if (ctuple.catpk1 < 0) {
			doingGs = true;

			var gpk1 = -1 * ctuple.catpk1;
			if (goals.indexOf(gpk1) < 0) {
				goals.push(gpk1);
			}
			if (qdpk1s.indexOf(ctuple.qpk1) < 0) {
				qdpk1s.push(ctuple.qpk1);
			}
			if (cpk1s.indexOf(ctuple.cpk1) < 0) {
				cpk1s.push(ctuple.cpk1);
			}

			var gtup = new gtuple();
			gtup.catpk1 = gpk1.toString();
			gtup.qdpk1 = ctuple.qpk1;
			gtup.cpk1 = ctuple.cpk1;
			gtuples.push(gtup);
		} else {

			var r = "(cat.category ='" + ctuple.category + "' and cat.crsmain_pk1=" + ctuple.cpk1 + ") or ";
			if (rows.indexOf(r) < 0) {
				rows += "(cat.category ='" + ctuple.category + "' and cat.crsmain_pk1=" + ctuple.cpk1 + ") or ";// qti_asi_data_pk1
				allRows.push(ctuple.cpk1 + "**" + ctuple.category);
			}
			allCtupleRows += "(cat.category ='" + ctuple.category + "' and cat.crsmain_pk1=" + ctuple.cpk1 + " and ic.qti_asi_data_pk1=" + ctuple.qpk1 + ") or ";
			allTupleRows.push(ctuple.cpk1 + "**" + ctuple.category + "**" + ctuple.qpk1);
		}
	});

	var step1 = [];
	var sql = ("9af566f0-b771-4738-8518-beea00fce08f");
	var gls = (goals.join(',').length > 0) ? goals.join(',') : -1;
	var qdls = (qdpk1s.join(',').length > 0) ? qdpk1s.join(',') : -1;
	var cls = (cpk1s.join(',').length > 0) ? cpk1s.join(',') : -1;
	var ps = {}; ps["@gpk1"] = gls; ps["@qdpk1s"] = qdls; ps["@cpk1s"] = cls;
	params.contents = fixObj(sql);
	params.ps = fixObj(JSON.stringify(ps));
	step1.push(ajGetSql(theUrl, params, true).always((jary) => {

		var gsteps2 = [];
		var icac = [];
		var icacPs = [];
		var icca = [];
		var chkgsql = [];
		var chkgsqlPs = [];
		var gdata = jary;
		for (var x = 0; x < gtuples.length; x++) {
			if ($.grep(gdata, function (el, i) {
				return el.qdpk1s == gtuples[x].qdpk1;
			}).length == 0) {
				if (dbtype === 'oracle') {
					icac.push(("32e4b538-7187-4174-bac2-0bd1fc4bc735"));
					var ps = {}; ps["@qdpk1"] = gtuples[x].qdpk1; ps["@cpk1"] = gtuples[x].cpk1;
					icacPs.push(ps);
				}
				else {
					if (dbtype === 'pgsql') {
						icac.push(("92778475-9765-486d-97e5-6787e098f1e9"));
						var ps = {}; ps["@qdpk1"] = gtuples[x].qdpk1; ps["@cpk1"] = gtuples[x].cpk1;
						icacPs.push(ps);

					} else {
						icac.push(("c319573c-9159-4b03-a1d1-0dc7d3a1eddb"));
						var ps = {}; ps["@qdpk1"] = gtuples[x].qdpk1; ps["@cpk1"] = gtuples[x].cpk1;
						icacPs.push(ps);
					}
				}
				var csql = ("ae3f911d-4b49-4290-8b00-3e562a929329");
				var ps = {}; ps["@catpk1"] = gtuples[x].catpk1; ps["@qdpk1"] = gtuples[x].qdpk1; ps["@cpk1"] = gtuples[x].cpk1;
				chkgsql.push(csql);
				chkgsqlPs.push(ps);
			}
		}
		for (var x = 0; x < icac.length; x++) {
			params.contents = fixObj(icac[x]);
			params.ps = fixObj(JSON.stringify(icacPs[x]));
			var pp = Object.assign({}, params);
			gsteps2.push(ajGetSql(theUrl, pp, true).always((jary) => { }));
		}
		$.when.apply(null, gsteps2).always(function () {
			for (var x = 0; x < chkgsql.length; x++) {
				params.contents = fixObj(chkgsql[x]);
				params.ps = fixObj(JSON.stringify(chkgsqlPs[x]));
				ajGetSql(theUrl, params, true).always((jary) => {
					var gr = jary[0];
					var sql = null;
					if (dbtype === 'oracle') {
						sql = ("f96583fc-5d9a-4e4b-9070-d91f2c36b2e6");
					} else {
						if (dbtype === 'pgsql') {
							sql = ("21fefb1b-b388-490b-becf-92ff20655c94");
						} else {
							sql = ("0b9cb13d-710b-448e-bbf5-9266b0cf8f6f");
						}
					}
					var ps = {}; ps["@clp_sog_pk1"] = gr.pk1;
					ps["@batch_uid"] = TAG(gr.batch_uid).replace("'","''");
					ps["@clp_alignable_content_pk1"] = gr.cacpk1;
					params.contents = fixObj(sql);
					params.ps = fixObj(JSON.stringify(ps));
					console.log('Does this get called?');
					ajGetSql(theUrl, params, true);
				});
			}
		});
	}));
	$.when.apply(null, step1).always(function () {
		console.log("when of step2 here");
		var catpk1Rows = "";
		var ps = {};
		sql = ("29ec9258-8c3c-436a-82fd-b271334fce54");
		ps["@alltuples"] = allCtupleRows;
		params.contents = fixObj(sql);
		params.ps = fixObj(JSON.stringify(ps));
		var step3 = ajGetSql(theUrl, params, true).always((jary) => {
			getItems = jary;
			getItems.forEach((cc) => {
				cpk1s_cats_qpk1s.push(cc.cpk1 + "**" + cc.category+"**"+cc.qpk1);
			});
			itemsMissing = $.except(allTupleRows, cpk1s_cats_qpk1s);
			itemsMissing.forEach((item) => {
				catpk1Rows += " (cat.crsmain_pk1 = " + item.split('**')[0] + " and cat.category ='" + item.split('**')[1] + "' ) or ";
			});
		});
		var step4 = [];
		$.when(step3).always(function () {
			console.log("when of step3 here");
			var pic = {};
			catpk1s_qdpk1s.forEach((pair) => {
				if (dbtype === 'oracle') {
					sql = ("11ba2fed-94dc-4cb0-917b-59a05ef0b9c9");
					pic["@catPk1"] = pair.split('**')[0]; pic["@qdpk"] = pair.split('**')[1];
				} else {
					if (dbtype === 'pgsql') {
						sql = ("765ac036-6941-48a0-a3c1-89586bdb58ea");
						pic["@catPk1"] = pair.split('**')[0]; pic["@qdpk"] = pair.split('**')[1];
					} else {
						sql = ("33d90389-e6ed-463f-9764-89f4596ad6eb");
						pic["@catPk1"] = pair.split('**')[0]; pic["@qdpk"] = pair.split('**')[1];
					}
				}
				params.contents = fixObj(sql);
				params.ps = fixObj(JSON.stringify(pic));
				step4.push(bjGetSql(theUrl, params, true, true).complete((jary) => {
					console.log("step3 complete here");
				}));
			});
			dtuples.forEach((dt) => {
				if (dt.catpk1 < 0) {
					// get clp_alignable_content_pk1
					var goal = -1 * dt.catpk1;
					var sql = ("9af566f0-b771-4738-8518-beea00fce08f");
					var pg = {};
					pg["@gpk1"] = goal; pg["@qdpk1s"] = dt.qpk1; pg["@cpk1s"] = dt.cpk1;
					console.log(sql);
					params.contents = fixObj(sql);
					params.ps = fixObj(JSON.stringify(pg));
					step4.push(ajGetSql(theUrl, params, true).always((jary) => {
						var cacpk1s = jary[0];
						var thePk1 = cacpk1s.ccapk1;
						var sql = ("6421cbe5-d34b-4bcc-9b8b-bae2043c3c9b");//6421cbe5-d34b-4bcc-9b8b-bae2043c3c9b
						var pc = {};
						pc["@ccapk1"] = thePk1;
						console.log(sql);
						params.contents = fixObj(sql);
						params.ps = fixObj(JSON.stringify(pc));
						ajGetSql(theUrl, params, true);
					}));
				} else {
					var sql = ("0d3aa6ef-40d7-45ea-ad65-d2e1d5d7f536");
					var pc = {};
					pc["@cpk1"] = dt.cpk1; pc["@cat"] = dt.category; pc["@qdpk"] = dt.qpk1;
					params.contents = fixObj(sql);
					params.ps = fixObj(JSON.stringify(pc));
					step4.push(ajGetSql(theUrl, params, true).always((jary) => { }));
				}
			});
			$.when.apply(null, step4).always(function () {
				console.log("when of step4 here");
			});
		});
	});
};

//////////////////////////////////////////////////////////////////////

function outBtn(outcomes, questions, add, del) {
	let ctuples = [], dtuples = [];
	for (let outcome of outcomes) {
		for (let question of questions) {
			let tuple = new ntuple(question.data.qpk1, question.data.cpk1, outcome.data.unique_id, outcome.data.pk1);
			var qid = parseInt(question.data.No)-1, foundCat = -1;
			var aQ = scoreQs[qid], uQ = uniqueQs[qid];
			let wCats = $.grep(souts, function (e, i) {
				if (e.cat === tuple.category) {
					foundCat = i;
					if ($.inArray(aQ.pk1, e.qpk1) !== -1) return true;
				}
			});
			if (wCats.length == 0) {
				if (!add) continue;
				for (let t of uQ.cqpks) {
					ctuples.push(new ntuple(t.qpk1, t.cpk1, outcome.data.unique_id, outcome.data.pk1));
				}
				//ctuples.push(tuple);
				if (foundCat < 0) souts.push(new nsout(outcome.data, question.data));
				else {
					souts[foundCat].Qs.push(question.data.No - 1);
					souts[foundCat].cpk1.push(question.data.cpk1);
					souts[foundCat].qpk1.push(question.data.qpk1);
					if (!souts[foundCat].position) souts[foundCat].position = [];
					souts[foundCat].position.push(question.data.No.toString());
					souts[foundCat].score += question.data.score;
					souts[foundCat].scored += question.data.scored;
				}
				nRemoveSout("Default", question.data);
			}
			else {
				if (!del) continue;
				for (let t of uQ.cqpks) {
					dtuples.push(new ntuple(t.qpk1, t.cpk1, outcome.data.unique_id, outcome.data.pk1));
				}
				//dtuples.push(tuple);
				nRemoveSout(tuple.category, question.data);
			}
		}
	}
	doCats(ctuples, dtuples, isOracle);
}

getSqlBigString = function (field) {
	if (dbtype === 'oracle') return 'dbms_lob.substr(' + field + ', 2000 )';
	return field;
}

batchToCat = function (batch) {
	var gparts = batch.split(/[-:*@_]/);
	var prefix = gparts.shift() + ":";
	var rest = gparts.join('_');
	return prefix + rest;
}

getData = function (myData, kind_id) {
	var theData = '';
	//  console.log("postgres data " + myData)
	if (myData.charAt(0) === '\\') {
		theData = mcq(hex2a(myData.substring(2)), kind_id);//"kind_id"
	} else {
		if (myData.charAt(0) !== 'P') {
			var str = hex2a(myData);
			theData = mcq(str, kind_id);
		} else {
			theData = mcq(Base64Decode(myData), kind_id);
		}
	}
	return theData;
}

function holdQData(xml) {
	waitForIt = false;
	rawQData = xml;
	qps = '';
	tables = xml;
	cpk1 = tables[0].cpk1;
	qpk1_cpk1 = '';
	var qs = [];
	for (var k = 0, kl = tables.length; k < kl; k++) {
		if (qs.indexOf(tables[k].pk1) < 0) {
			qps += ',' + tables[k].pk1;
			qs.push(tables[k].pk1);
			qpk1_cpk1 += ',' + tables[k].pk1 + '_' + tables[k].cpk1;
		}
	}
	qps = qps.substr(1, qps.length - 1);
	qpk1_cpk1 = qpk1_cpk1.substring(1);
	cats = window.opener.goalCats;
	getTheCats(qps, holdQCats, qpk1_cpk1);
}

function holdQCats(xml) {
	rawCData = xml;
	parseXML(rawQData);
}

function parseXML(xml) {
	ass = new Assessment();
	atables = xml;
	ass.title = atables[0].gtitle;
	// \bsurvey\b
	var m = ass.title.match(/\bsurvey\b/ig);
	if (m !== null) {
		survey = true;
	}
	$(document).attr("title", ass.title);
	var k = 0;
	var s = '';
	var theQs = "";
	var qp = 1;
	var qpos = [];
	var qsts = [];
	asspk1 = 0;
	var qds = [];
	atables.forEach((tab) => {
		var tabTitle = null;
		var aqd = tab.pk1;
		if ($.inArray(aqd, qds) === -1) {
			qds.push(aqd);
		}
		if (gmpk1.indexOf(tab.gmpk1) === -1) {
			gmpk1 += "," + tab.gmpk1;
		}
		if (crsData.length === 0 || crsData[crsData.length - 1].cpk1 !== tab.cpk1) {
			var c = new courseRow(tab.cpk1, role);
			c.course = tab.course_name + " (" + tab.course_id + ")";
			c.enrollment = parseInt(tab.enrollment);
			c.crs_batch_uid = tab.crs_batch_uid;
			c['gmpk1'] = tab.gmpk1;
			crsData.push(c);
		}
	});
	getInstructors(crsData, postCourse, qds, gmpk1);
}

function postCourse(xml, qds, gmpk1) {
	crsData = xml;
	gmpk1 = gmpk1.substring(1);
	getTestResults(gmpk1, qds, parseXMLR, isPool, domain_pk1, showDomains, dtod, dfod);// atables
	notify($L.loading.getting_responses); 
}

function getQs(atables) {
	ass.Qs = [];
	qno = 1;
	var t = 0;
	var tabl = atables.length;
	var process1 = function () {
		for (; t < tabl; t++) {
			var tab = atables[t];
			// atables.each(function (t, tab) {
			var tabTitle = null;
			if (isNotScoreable(tab.kind_id)) {
				qno++;
				return true; // continue
			}
			var theQ = new Mcq();
			theQ.position = t + 1;
			theQ.qno = qno++;
			theQ.cpk1 = tab.cpk1;
			theQ.ultra_status = tab.ultra_status;
			theQ.maxScore = tab.maxscore;
			theQ.kind_id = tab.kind_id;
			var qsubb = [];
			if (typeof tab.qr !== 'undefined') {
				qsubb = TAG(tab.qr);
			}

			if (qsubb.length > 0) {
				var qsub = qsubb.split('****');
				theQ.qsub = qsub;
			} else {
				theQ.qsub = null;
			}
			if (eKinds.indexOf(parseInt(theQ.kind_id)) === -1) {
				eKinds.push(parseInt(theQ.kind_id));
			}
			theQ.QTAbbre = getQTAbbr(theQ.kind_id, theQ.ultra_status);

			if (isNotScoreable(theQ.kind_id)) {
				ass.Ns.push(theQ);
			};
			var theData;
			var myData = tab.data;// $(elem).text();
			theData = getData(myData, theQ.kind_id);
			var nparts = theData.split("***");
			if (theQ.kind_id == 3 && theQ.ultra_status ==='U') {
				var anss = 0;
				var ccs = nparts[2].split('__');
				for (var j = 0; j < ccs.length; j++) {
					if (ccs[j].indexOf('rc') === 0) {
						anss++;
					}
				}
				if (anss === 1) {
					theQ.kind_id = 1;
					theQ.QTAbbre = getQTAbbr(theQ.kind_id, theQ.ultra_status);
				}
			}
			var fbc = nparts[nparts.length - 1];
			if (fbc.split('=')[0] == "feedback") {
				theQ.feedback = TAG(fbc.split('=')[1]);
			}
			theQ.theData = theData;
			theQ.pk1 = tab.pk1;
			theQ.rpk1 = tab.rpk1;
			theQ.rChoices = tab.rchoices.split('**');
			theQ.title = theData.split("***")[0].split("||")[1];
			theQ.q = theData.split("***")[1].split("||")[1];
			if (typeof theQ.q !== 'undefined') {
				theQ.q = theData.split("***")[1].split("||")[1].trim();
			}
			if (typeof theQ.q === 'undefined' || theQ.q.length === 0) {
				theQ.q = theQ.title.trim();
				if (theQ.q.length === 0) {
					theQ.q = 'Question ' + theQ.qno;
				}
			}
			for (var n in tab) {
				if (tab.hasOwnProperty(n)) {
					var item = tab[n];
					switch (n) {
						case "data": {
							s = '<br />';
							s += 'qdpk1 = ' + theQ.pk1 + '<br />';
							s += 'position =' + theQ.position + '<br />';
							s += 'kind =' + theQ.kind_id + '<br />';
							s += 'quest =' + theQ.q + '<br />';
							if (theQ.kind_id == 5) {
								/*theData  t||***q||Match the animal to its sound.******maxvalue=1||correct==1,2,3,4,5||identChoice==||choice==||rchoices== */
								var others = theData.split("***")[2];
								theQ.correct = others.split("||")[1].split("==")[1];//.replace(/\$\$\$/g, '**');
								theQ.correct = theQ.correct.replace(/\$\$\$/g, '**');
								// s += 'correct=' + theQ.correct + '\n';
								theQ.idents = others.split("||")[2].split("==")[1].split("__");
								s += 'idents=' + theQ.idents + '\n';
								theQ.choices = others.split("||")[3].split("==")[1].replace(/\$\$\$/g, '**').split("**");
								theQ.rChoices = others.split("||")[4].split("==")[1].split(":::");
								var corr = '';
								s += 'Choices=' + theQ.choices + '\n';
								s += 'rChoices=' + theQ.rChoices + '\n';
								s += 'correct=' + theQ.correct + '\n';
								//  console.log("MATching = " + s.replace(/<br \/>/g, '\n'));
							} else { //s += '||correct==' + correct.substring(2, correct.length)
								/*t||Months***q||Put months in order.***r_0_1_May__r_1_0_Feb__r_2_3_Sep__r_3_2_July__||correct==Feb,May,July,Sep***maxvalue=0.0*/
								if (theQ.kind_id == 12) {
									var others = theData.split("***");
									var other = '';
									for (var o = 0; o < others.length; o++) {
										if (others[o].indexOf('||correct==') > -1) {
											theQ.correct = other = others[o].split('==')[1];
											break;
										}
									}
									var choices = [];
								} else {
									if (theQ.kind_id == 13) {
										var parts = theData.split('***'); // 0 t||Jumbled Sentence 01
										var others = theData.split("***")[2];
										var sparts = theData.split("||");
										var sp = sparts[4].split("==")[1];
										var sps = sp.split('::');
										for (var u = 0; u < sps.length; u++) {
											sps[u] = sps[u].split('=')[0] + '=' + sps[u].split('**')[1];
										}
										theQ.correct = sps.join('::');    //sparts[4].split("==")[1];
										var choices = sparts[3].split("==")[1];
										var choicesTmp = choices.split('$$$');
										for (var i = 0; i < choicesTmp.length; i++) {
											choicesTmp[i].split('_');
											theQ.choices.push(choicesTmp[i].split('_')[0] + ':::' + choicesTmp[i].split('_')[2]);
											theQ.choicesText.push(choicesTmp[i].split('_')[1] + ':::' + choicesTmp[i].split('_')[2]);
										}
									}
									if (theQ.kind_id == 4) {
										/*t||Months***q||Put months in order.***r_0_1_May__r_1_0_Feb__r_2_3_Sep__r_3_2_July__||correct==Feb,May,July,Sep***maxvalue=0.0*/
										// console.log("theData " + theQ.theData);
										var others = theData.split("***")[2];
										theQ.correct = others.split("||")[1].split("==")[1];
										theQ.choices.push(theQ.correct);
									}
									else {
										if ((theQ.kind_id == 17 && theQ.ultra_status === 'U') ||
											(theQ.kind_id == 2 && theQ.ultra_status !== 'U')
										) {
											var others = theData.split("***")[2];
											others = others.substring(0, others.length - 2);
											// rc_0_true-false.true__r_1_true-false.false__
											theQ.choices = [];
											var corr = -1;
											var parts = others.split('__');
											for (var c = 0; c < parts.length; c++) {
												if (parts[c].indexOf('rc') > -1) {
													corr = c;
												}
												theQ.choices.push(parts[c].split('_')[2]);
											}
											theQ.correct = theQ.choices[corr];
										}
										else {
											if (theQ.kind_id == 6 || theQ.kind_id == 8) {
												theQ.correct = theData.split("***")[2].split("_")[2];
												if (typeof theQ.correct === 'undefined') {
													theQ.correct = theData.split("***")[3].split("_")[2];
												}
												if (theQ.kind_id == 8) {
													theQ.correct = parseFloat(theQ.correct);
												}

												theQ.choices.push(theQ.correct);
												theQ.other = theData.split("***")[3].toUpperCase();
											}
											else {
												if (theQ.kind_id == 11) {
													if (theQ.maxScore < 0) {
														try {
															var ms = theQ.theData.split('***')[3].split('=')[1];
															if (!isNaN(ms)) {
																theQ.maxScore = parseFloat(theQ.theData.split('***')[2]);
															}
														} catch (e) {
														}
													}
													theQ.correct = "0";
													theQ.choices = ["0", "1"];
												} else if (theQ.kind_id == 7 || theQ.kind_id == 10 || theQ.kind_id == 16) {
													var choices = [];
													if (survey && (theQ.kind_id == 7 || theQ.kind_id == 10 || theQ.kind_id == 16)) {
														choices = ['Answered', 'Unanswered'];
													} else if (theQ.rpk1.length > 0 && theQ.rChoices.length > 0 && theQ.qsub !== null) {
														if (theQ.qsub.length > 0) {
															for (var sb = 0; sb < theQ.qsub.length; sb++) {
																for (var c = 0; c < theQ.rChoices.length; c++) {
																	choices.push(theQ.qsub[sb] + ' - ' + theQ.rChoices[c]);
																}
															}
														} else {
															choices = theQ.rChoices;
														}
													} else {
														choices.push('0.0 < 0.20'); choices.push('0.20 < 0.40');
														choices.push('0.40 < 0.60'); choices.push('0.60 < 0.80');
														choices.push('0.80 <= 1.0');
													}
													theQ.choices = choices;
													theQ.correct = '';
												} else if (theQ.kind_id == 15) {
													var choices = theData.split("***")[2].split(":::");
													theQ.choices = choices;
													theQ.correct = '';
												} else {
													if (theQ.kind_id != 13) {
														var choices = theData.split("***")[2].split("__");
														var correct = '';
														for (var i = 0, il = choices.length - 1; i < il; i++) {
															try {
																theQ.choices[i] = choices[i].split('_')[2].trim();
															} catch (e) {
															}
															s += theQ.choices[i] + '<br />';
															if (choices[i].split('_')[0] === "rc") {
																if (theQ.kind_id == 3) {
																	correct += '::' + choices[i].split('_')[2].trim();
																} else {
																	correct += ', ' + choices[i].split('_')[2].trim();
																}
															}
														}
														theQ.correct = correct.substring(2);
														if (theQ.kind_id == 3 && theQ.correct.length === 0) {
															correct = '';
															for (var cc = 0; cc < choices.length; cc++) {
																if (choices[cc].indexOf('c') !== -1) {
																	correct += ", " + (cc + 1);
																}
															}
															theQ.correct = correct.substring(2);
														}
														if (theQ.kind_id == 3 && theQ.correct.split('::').length === 1 && theQ.ultra_status === 'U') {
															theQ.kind_id = "1";
															theQ.QTAbbre = getQTAbbr(theQ.kind_id);
														}
														s += 'correct=' + theQ.correct + '<br />';
													}
												}
											}
										}
									}
								}
								if (theQ.maxScore === -1) {
									theQ.maxScore = theData.split("***")[3].split('=')[1];
								}
								theQ.checkQ = theData.split("***")[5].split('=')[1];
								s += 'themaxscore=' + theData.split("***")[3] + '<br />';
								s += '<br /><br />';
							}
							break;
						}
						case "parent_pk1": { theQ.parent_pk1 = item; break; }
						case "gmpk1": { theQ.gmpk1 = item; break; }
						case "category": { theQ.categories = ((item == null || item.length == 0) ? "Default" : item); break; } // this line should no longer be hit
						case "gtitle": {
							ass.title = item;
							if (tabTitle == null) {
								$(document).attr("title", item);
								tabTitle = item;
							}
							break;
						}
						case "cpk1": {
							ass.cpk1 = item;
							break;
						}
						case "course_name": {
							ass.course_name = item;
							break;
						}
						case "course_id": {
							ass.course_id = item;
							break;
						}
						case "enrollment": {
							break;
						}
					}
				}
			};
			try {
				ass.Qs.push(theQ);
			} catch (e) {
				console.log(e);
			}
			if (t + 1 < tabl && t % 10 == 0) {
				setTimeout(process1, 5);
			}
			//#endregion
		};
	}
	process1();
	ass.demos = [];
	catPks = rawCData;
	souts = [];
	var cs = new sout();
	var category = catPks.length ? catPks[0].category : '';
	/*if ((bburl.indexOf('gvtc.') > -1 || bburl.indexOf('southernregional.') > -1)) {
		category = category.replace(':', '.');
	}*/
	cs.cat = category;
	cs.catpk1 = catPks.length ? parseInt(catPks[0].catpk1) : -1;
	var catys = [];
	for (var j = 0, jl = catPks.length; j < jl; j++) {
		if (catys.indexOf(catPks[j].category) === -1) {
			souts.push(cs);
			category = catPks[j].category;
			/*if ((bburl.indexOf('gvtc.') > -1 || bburl.indexOf('southernregional.') > -1)) {
				category = category.replace(':', '.');
			}*/
			catys.push(category);
			cs = new sout();
			cs.cat = category;
			cs.catPk1 = parseInt(catPks[j].catpk1);
		}
		cs.cpk1.push(catPks[j].cpk1);
		cs.qpk1.push(catPks[j].qpk1);
	}
	souts.push(cs);
	var demoSouts = $.grep(souts, function (e) {
		return e.cat.toUpperCase() === 'DEMOGRAPHIC';
	});
	var uqs = [];
	for (var d = 0, dl = demoSouts.length; d < dl; d++) {
		demoQs = $.union(demoQs, demoSouts[d].qpk1);
	}
	var theQ = null;

	for (var h = 0, hl = ass.Qs.length; h < hl; h++) {

		theQ = ass.Qs[h];

		if (demoQs.indexOf(theQ.pk1) !== -1) {
			continue;
		}

		uqs = $.grep(ass.Qs, function (e) {
			// adminluonline.
			var eq = null;
			if (bburl.indexOf("asu-pilot") > -1 || bburl.indexOf('104.42.105.207') > -1 || bburl.indexOf('partner-smoke-test-b') > -1) {
				var chk1 = theQ.checkQ.replace(/<!--RsQ_[0-9]+-->/, '').replace(/&nbsp;/g, ' ');
				var chk2 = e.checkQ.replace(/<!--RsQ_[0-9]+-->/, '').replace(/&nbsp;/g, ' ');;
				eq = (e.q.trim() === theQ.q.trim() && chk1.trim() === chk2.trim());

			} else {
				eq = (e.checkQ === theQ.checkQ && e.q === theQ.q && demoQs.indexOf(e.pk1) === -1 && !isNotScoreable(e.kind_id));
			}
			if (eq) {
				// console.log('e.checkQ=' + e.checkQ + ' theQ.checkQ=' + theQ.checkQ);
				if (e.choices.length !== 0 && theQ.choices.length === e.choices.length) {
					// console.log(e.choices + " === " + theQ.choices);
					if (arraysEqual(e.choices, theQ.choices)) {
						//  console.log('choices equal');
						return true;
					}
				} else {
					//return false;
					// let essay type qs in
					if (arraysEqual(e.choices, theQ.choices)) {
						//console.log('second off');
						return true;
					}
				}
			} else {
				//console.log('third off');
				return false;
			}
		});
		var ok = true;
		if (uniqueQs.length > 0) { // 12/10/24
			for (var r = 0; r < uniqueQs.length; r++) {
				var cqpk = { "cpk1": theQ.cpk1, "qpk1": theQ.pk1 };//{"cpk1":aq.cpk1,"qpk1":aq.pk1}
				if ((uniqueQs[r] !== undefined) &&
					($.grep(uniqueQs[r].cqpks, function (e) {
						if (e.cpk1 === cqpk.cpk1 && e.qpk1 === cqpk.qpk1) {
							return true;
						}
					}).length > 0)) {
					ok = false;
					break;
				}
			}
		}
		if (!ok) {
			continue;
		}
		var theQ = uqs[0];
		if (theQ === undefined) {
			continue;
		}
		var cqpks = [];
		for (var q = 0, ql = uqs.length; q < ql; q++) {
			var aq = uqs[q];
			cqpks.push({ "cpk1": aq.cpk1, "qpk1": aq.pk1 });
		}
		uniqueQs.push({ "theQ": theQ, "position": uniqueQs.length + 1, "cqpks": cqpks });
	}
}

function parseXMLR(xml) {
	rawScores = []; // qr.pk1,qr.position
	var tables = xml;//.find("myTable").get();
	var fbidObjs = Enumerable.from(tables).select(function (x) {
		return {
			"fbid": x.fbid
		}
	}).toArray();
	fbidObjs.forEach((el, n) => {
		fbidOrder.push({ "fbid": el, "n": n });
	});
	fbidOrder.sort(function (a, b) { return a.fbid - b.fbid; });
	getQs(atables);
	var k = 0;
	var theQs = "";
	var pos = 0;
	var users = [];
	var answer = "";
	var correctAns = 0;
	var totlen = 0;
	var needName = false;
	var s = 'scores_';
	var qc = 0;
	var pp = -10;
	var fbids = 0;
	var aQ = null;
	var theR;
	var dudFbids = [];
	var rpos = 0;
	var ok = true;
	var mok = true;
	var fbid = tables[fbidOrder[0].n].fbid;
	var cpk1 = tables[fbidOrder[0].n].cpk1;
	for (var cc = 0, ccl = crsData.length; cc < ccl; cc++) {
		if (crsData[cc].cpk1 === cpk1) {
			crsData[cc].fbids.push(fbid);
			crsData[cc].responses++;
			break;
		}
	}
	var k = 0, kl = tables.length;
	//#region forloop
	function next() {
		if (k <= kl) {
			try {
				var kk = fbidOrder[k].n; //  if (k >= kl) {
			} catch (e) {
				// k = k1 + 1;
				remainder(mok, dudFbids, rpos, ok, fbid, cpk1);
			}
			ok = true;
			// don't let essay type qs in
			if (isNotScoreable(tables[kk].kind_id)) {
				ok = false;
			}
			if (k % 10 === 0) {
				var percent = 100 * (k / kl);
				notify($L.loading.processing + ' ' + percent.toFixed(1) + "%");
				mainscope.progress = percent;
			}
			var q = '';
			theR = new Mcr();
			if (showDomains) {
				theR.program = tables[kk].program;
			}
			//  theR.qdata = tables[kk].qdata;
			theR.qpk1 = tables[kk].qpk1;
			theR.origQpk1 = theR.qpk1;
			theR.kind_id = tables[kk].kind_id;
			theR.pk1 = tables[kk].qrpk1;
			theR.cpk1 = tables[kk].cpk1;
			theR.rpk1 = tables[kk].rpk1;
			theR.usr_batch_uid = tables[kk].usr_batch_uid;
			theR.ultra_status = tables[kk].ultra_status;
			theR.student_id = tables[kk].student_id;
			theR.max_score = tables[kk].maxscore;
			if (theR.max_score == 0) {
				theR.max_score = 1.0;
			}
			theR.points = -1;//parseFloat(tables[kk].bbmd_grade) * theR.max_score;
			theR.upk1 = tables[kk].upk1;
			theR.email = tables[kk].email;
			var stime = tables[kk].starttime;
			var etime = tables[kk].endtime;
			theR.thiscol = -1;
			if (typeof tables[kk].rpos !== 'undefined') {
				var rpos = tables[kk].rpos.split('*');
				theR.rpos = rpos;
				theR.thiscol = tables[kk].thiscol.split('*');
			}
			theR.elapsed = parseFloat((Date.parse(etime) - Date.parse(stime)) / 1000);
			var thisQ = null;
			var found = false;
			if (!found) {//uniqueQs.push({ "theQ": theQ, "position": uniqueQs.length + 1 });
				for (var ss = 0, ssl = uniqueQs.length; ss < ssl; ss++) {
					var cqpk = { "cpk1": theR.cpk1, "qpk1": theR.qpk1 };
					if ($.grep(uniqueQs[ss].cqpks, function (e) {
						if (e.cpk1 === cqpk.cpk1 && e.qpk1 === cqpk.qpk1) {
							return true;
						}
					}).length > 0) {
						theR.position = ss;
						if (uniqueQs[ss].cqpks.length > 1) {
							var t = '';
							for (var w = 0; w < uniqueQs[ss].cqpks.length; w++) {
								t += "qpk1=" + uniqueQs[ss].cqpks[w].qpk1 + " cpk1=" + uniqueQs[ss].cqpks[w].cpk1 + '\n';
							}
						}
						theR.qpk1 = uniqueQs[ss].theQ.pk1;
						thisQ = uniqueQs[ss].theQ;
						theR.kind_id = thisQ.kind_id;
						if (thisQ.maxScore > 0.0) {
							theR.max_score = thisQ.maxScore;
						}
						uniqueQs[ss].theQ.responses++;
						found = true;
						break;
					}
				}
			}
			if (!found) {
				ok = false;
			}
			var s = '';
			needName = false;
			if (ok) {
				for (var n in tables[kk]) {
					if (tables[kk].hasOwnProperty(n)) {
						var item = tables[kk][n];
						switch (n) {
							case "data": {
								var myData = tables[kk].data;
								var theData = getRData(myData, theR.kind_id, thisQ);
								if (theR.kind_id == 11) {
									var score = theData.split('***')[1].split('_');
									if (typeof score !== 'undefined') {
										theR.score = parseFloat(score[1]) / parseFloat(score[2]);
										theR.skipped = false;
										theR.status = 1;
										theR.response = thisQ.choices[1 - theR.score];
									}
								}
								if(theR.kind_id == 9) {
									let rparts = theData.split('***');
									theR.response = rparts[0];
									theR.Correct_Ans = rparts[1];
									let sparts = rparts[2].split('_');
									theR.score = parseFloat(sparts[1]) / parseFloat(sparts[2]);
								}
								if (survey && (theR.kind_id == 7 || theR.kind_id == 10 || theR.kind_id == 16)) {
									theR.surv = theData.split('***')[0].replace('r_', '');
									theR.score = 0; theR.skipped = false;
									if (theR.surv.length === 0) {
										theR.surv = '--';
										theR.skipped = true;
									}
								} else if (theR.kind_id == 7 || theR.kind_id == 10 || theR.kind_id == 16) {
									theR.realAns = theData.split('***')[0].replace('r_', '');
								}
								if (theR.kind_id == 7 || theR.kind_id == 10 || theR.kind_id == 16) {
									theR.response_feedback = theData.split('***')[2] ? theData.split('***')[2] : '';
								}
								try {
									var scs = theData.split('***');
									var scores = scs.pop().split('_');
									theR.max_score = parseFloat(scores[2]);
									if (theR.max_score <= 0) theR.max_score = EPSILON;
									if (typeof scores[1] === 'undefined') {
										theR.skipped = true;
										theR.score = 0;
									} else {
										theR.score = parseFloat(scores[1]) / theR.max_score;
										theR.points = theR.score * theR.max_score;
										theR.skipped = false;
										theR.status = 1;
									}
								} catch (e) {
									theR.score = 0;
									theR.skipped = true;
									theR.status = 0;
									console.log(e.message);
								}
								resp = theData.split("***")[0];
								if (theR.kind_id == 15) {
									var r = theData.split("***")[0].split('_')[1];
									if (r.length > 0) {
										theR.response = parseInt(r);
									}
									console.log('theR.kind_id = 15 ' + theData);
								}
								var bbmdScore = tables[kk].bbmd_grade;
								// s += 'resp =' + resp + '\n';
								if (theR.kind_id == 1) {
									theR.response = resp.split('_')[1];
								}
								if (survey && (theR.kind_id == 7 || theR.kind_id == 10 || theR.kind_id == 16)) {
									theR.surv = theData.split('***')[0].replace('r_', '');
									if (theR.surv.length === 0) {
										theR.surv = '--';
										theR.response = 1;
										theR.skipped = true;
										theR.score = 0;
									} else {
										theR.response = 0;
										theR.skipped = false;
										theR.score = 1;
									}
									theR.points = theR.score * thisQ.maxScore;
								} else if (theR.kind_id == 7 || theR.kind_id == 10 || theR.kind_id == 16) {
									var scrs = theData.split("***")[1].split('_');
									theR.realAns = theData.split('***')[0].replace('r_', '');
									if (scrs.length == 3) {

										theR.max_score = parseFloat(scrs[2]);
										if (theR.max_score <= 0) theR.max_score = EPSILON;
										theR.score = parseFloat(scrs[1]) / theR.max_score;
										theR.skipped = false;
									}
									if ((theR.kind_id == 7 || theR.kind_id == 10 || theR.kind_id == 16) && thisQ.title === 'Demographic') {
										theR.choice_text = theData.split("***")[1].split('_')[1].trim();
										console.log('SR ' + 'Q' + thisQ.position + ' ' + theR.choice_text + ' len=' + theR.choice_text.length);
									}
									s = '\n';
									s += "pk1 = " + theR.pk1 + "\n";
									s += "qpk1 = " + theR.qpk1 + "\n";
									s += theR.lastname + '\n';
									s += "skipped =" + theR.skipped + '\n';
									s += 'position=' + theR.position + '\n';
									s += 'kind=' + theR.kind_id + '\n';
									s += 'name=' + theR.user_id + '\n';
									s += 'ultra_status=' + theR.ultra_status + '\n';
									s += 'theQ.kind_id=' + thisQ.kind_id + '\n';
									var myData = tables[kk].data;
									var theData = getRData(myData, theR.kind_id, thisQ);
									 var bbmdScore = tables[kk].bbmd_grade;
									s += 'bbmdScore=' + bbmdScore;
									s += 'theData=' + theData + '\n';
									s += 'maxscore ' + theR.max_score + '\n';
									s += 'score ' + theR.score + '\n';
									s += 'bbmd_grade= ' + theR.score + '\n';
									if (theR.pk1 == 26860990) {
										console.log(s);
									
										console.log('bbmdScore=' + bbmdScore);

									}
									var bbmdScore = tables[kk].bbmd_grade;
									if (isNaN(theR.max_score) || typeof theR.max_score === 'undefined') {
										var scrs = theData.split("***")[1].split('_');
										if (scrs.length == 3) {

											theR.max_score = parseFloat(scrs[2]);
											if (theR.max_score <= 0) theR.max_score = EPSILON;
											theR.score = parseFloat(scrs[1]) / theR.max_score;
											theR.skipped = false;
										} else {

											theR.max_score = parseFloat(thisQ.maxScore);
											if (theR.max_score <= 0) theR.max_score = EPSILON;
											theR.score = parseFloat(bbmdScore / theR.max_score);
											theR.skipped = false;

										}
										theR.points = theR.score * theR.max_score;
									}
									var sc = 0;
									var tot = 0;
									if (theR.rpk1 > 0 && thisQ.qsub !== null) {

										theR.response = [];
										for (var r = 0; r < thisQ.rChoices.length; r++) {
											if (typeof theR.thiscol[r] !== 'undefined') {
												theR.response.push(theR.thiscol[r]);
											} else {
												theR.response.push(0);
											}
										}
									} else {
										theR.response = '';
										var cl = thisQ.choices.length;
										for (var i = 0; i < cl; i++) {
											var lo = (i / cl);
											var hi = (i + 1) / (cl);
											if (theR.score >= (i / cl) && theR.score < (i + 1) / (cl)) {
												theR.response = thisQ.choices[i];
												break;
											}
										}
									}
									if (theR.response.length === 0 && theR.score == 1) {
										theR.response = thisQ.choices[cl - 1];
									}
									if (theR.response.length === 0) {
										theR.skipped = false;
									}
								}
								if (resp.split("_")[1] === '' || (theR.kind == 10 && theR.status === 1 && theData === theData.replace('r_***'))) {
									if (!(theR.kind_id == 7 || theR.kind_id == 10 || theR.kind_id == 16)) {
										theR.skipped = true;
										theR.score = 0;
									}
								} else {
									if (dudFbids.length > 0) {
										var jj = $.inArray(theR.fbid, dudFbids);
										if (jj > -1) {
											dudFbids.splice(jj, 1);
										}
									}
								}
								var rr = '';
								counter = 0;
								if (theR.kind_id == 5) {
									if (thisQ !== null) {
										//     console.log('5 ' + theData);
										var r = theData.split('***')[0];
										var rs = r.split(',');
										var qidents = thisQ.idents[0].split('$$$');
										response = '';
										for (var jj = 0; jj < rs.length; jj++) {
											var fr = rs[jj].split('::')[0];
											for (var yy = 0; yy < qidents.length; yy++) {
												var fq = qidents[yy].split('::')[0];
												if (fr === fq) {
													var p = qidents[yy].split('::')[1].split(',').indexOf(rs[jj].split('::')[1]);
													response += '**' + thisQ.choices[jj] + '::' + thisQ.rChoices[p];
													break;
												}
											}
										}
										if (thisQ.ultra_status === 'U') {
											response = response.substring(2);
											rr = response;
											theR.score = (response === thisQ.correct) ? 1.0 : 0.0;
											theR.response = response;
										} else {
											theR.response = response.substring(2);
											response = ',' + response.substring(2);
											rr = response;
										}
									}
								} else {
									if (theR.kind_id == 4) {
										if (thisQ !== null) {
											var rvals = thisQ.theData.split('***')[2].split('||')[0];
											rvals = rvals.substring(0, rvals.length - 2);
											var ans = resp.replace(/r_/g, "");
											ans = ans.substr(0, ans.length - 1);
											var ansr = ans.split('_');
											var response = '';
											var list = rvals.split('__');
											for (var i = 0; i < ansr.length; i++) {
												var p = ansr.indexOf(i.toString());
												try {
													response += ',' + list[p].split('_')[3];
												} catch (e) {
												}
											}
											rr = response;
											theR.response = response.substring(1);
										}
									} else {
										if (theR.kind_id == 12) {
											if (thisQ !== null) {
												theR.response = resp.trim();
												rr = ',' + theR.response;
											}
										}
										else if (theR.kind_id == 13) {
											if (thisQ !== null) {
												// scores s_2.00000_7.00000
												var ridents = resp.split('_');
												var idents = thisQ.choicesText;
												var responses = [];
												for (var r = 0; r < ridents.length; r++) {
													var p = ridents[r].split('=')[0]; // ax
													var pp = ridents[r].split('=')[1]; // lid

													var i1 = idents[r].split(':::')[0]; // lids
													var i1a = i1.split('*');// array of lids
													var names = idents[r].split(':::')[1]; // ans
													var mynames = names.split('*'); // array of names
													var q = i1a.indexOf(pp);
													responses.push(p + '=' + mynames[q]);
												}
												response = responses.join('::');
												rr = response;
												theR.response = rr;
												if (thisQ.kind_id == 1 && thisQ.ultra_status === 'U' /*&& [thisQ.correct].length === 1*/) {
													theR.kind_id = 1;
													for (var w = 0; w < thisQ.choices.length; w++) {
														if (theR.response == thisQ.choices[w]) {
															theR.response = w;
															break;
														}
													}
												}
											}
										} else {
											if (theR.kind_id == 3) {
												if (thisQ !== null) {
													resp = resp.substr(0, resp.length - 1);
													var ans = resp.replace(/r_/g, "");
													var ansr = ans.split('_');
													var response = '';
													var list = thisQ.theData.split('***')[2];
													list = thisQ.theData.split('***')[2].substring(0, list.length - 2);
													var lsts = list.split('__');
													for (var i = 0; i < ansr.length; i++) {
														if (ansr[i] == 1) {
															try {
																var len = lsts[i].split('_').length;
																if (len >= 3) {
																	response += '::' + lsts[i].split('_')[2].trim();
																}
																else {
																	// ansr = ["0", "0", "1", "1", "0"
																	if (ansr[i] === 1) {
																		response += '::' + (i + 1);
																	}
																}
															} catch (e) {
																console.log("MA Exception here is list " + list + " and ansr " + ans + " thisQ " + thisQ.pk1 + " position " + thisQ.position + " theR.pk1 " + theR.pk1);
															}
														}
													}
													if (response.length > 1) {
														response = response.substring(2);
													}
													rr = response;
													theR.response = response;
													if (thisQ.kind_id == 1 && thisQ.ultra_status === 'U' /* && [thisQ.correct].length === 1 */) {
														theR.kind_id = 1;
														for (var w = 0; w < thisQ.choices.length; w++) {
															if (theR.response == thisQ.choices[w]) {
																theR.response = w;
																break;
															}
														}
													}
												}
											} else {
												if (theR.kind_id == 8) {
													theR.response = parseFloat(resp.split(':::')[2]);
												} else {
													if (theR.kind_id == 6) {
														if (thisQ !== null) {
															var resp = theData.split('***')[0].split('_')[1];
															if (resp.length > 0) {
																theR.response = resp;
															} else {
																theR.skipped = true;
																theR.response = '';
															}
															var response = ',' + resp;
															var exact = thisQ.other.split('||')[0];
															var cs = thisQ.other.split('||')[1];
															switch (exact) {
																case "EXACT": {
																	if (cs === "YES") {
																		var tscore = 0;
																		var ors = thisQ.correct.split('||');
																		for (var or = 0; or < ors.length; or++) {
																			if (response === ',' + ors[or]) {
																				tscore++;
																			}
																		}
																	} else {
																		var tscore = 0;
																		var ors = thisQ.correct.split('||');
																		for (var or = 0; or < ors.length; or++) {

																			if (response.toUpperCase() === ',' + ors[or].toUpperCase()) {
																				tscore++;
																			}
																		}
																	}
																	break;
																}
																case "CONTAINS": {
																	if (cs === "YES") {
																		theR.score = ((response).indexOf(',' + thisQ.correct) !== -1 || (',' + thisQ.correct).indexOf(response) !== -1) ? 1.0 : 0.0;
																	} else {

																		theR.score = ((response.toUpperCase()).indexOf(',' + thisQ.correct.toUpperCase()) !== -1 || (',' + thisQ.correct.toUpperCase()).indexOf(response.toUpperCase()) !== -1) ? 1.0 : 0.0;
																	}
																	break;
																}
																case "MATCHES": {
																	if (cs === "YES") {
																		var re = new RegExp(',' + thisQ.correct, "g");
																		var res = response.match(re);
																		theR.score = (res !== null && res.length > 0) ? 1.0 : 0.0;
																	} else {
																		var re = new RegExp(',' + thisQ.correct, "gi");
																		var res = response.match(re);
																		theR.score = (res !== null && res.length > 0) ? 1.0 : 0.0;
																	}
																	break;
																}
															}
															rr = response;
															if (theR.score > 0) {
																response = ',' + thisQ.correct;
																theR.response = thisQ.correct;
																rr = response;
															}
														} else {
															var response = '';
															rr = response;
															theR.score = 0.0;
															theR.status = 0;
														}
													} else {
														if ((theR.kind_id == 2 && thisQ.ultra_status !== 'U') || (theR.kind_id == 17 && thisQ.ultra_status !== 'U')) {
															var resp = theData.split('***')[0].split('_')[1];
															if (resp.length > 0) {
																theR.response = thisQ.choices[resp];
															}
														}
														if ((theR.kind_id == 1 && thisQ.ultra_status !== 'U')) {
															for (var w = 1, wl = resp.split('_').length; w < wl; w += 2) {
																rr += "," + resp.split('_')[1];
															}
														} else {
															if (theR.kind_id == 11) {
																rr = (theR.score > 0) ? ",0" : ",1";
															} else {
																if (theR.kind_id == 17 && thisQ.ultra_status === 'U') {
																	var parts = theData.split('***');
																	var r = parseInt(parts[0].split('_')[1]);
																	theR.response = r;//thisQ.choices[r];
																} else {
																	for (var w = 1, wl = resp.split('_').length; w < wl; w += 2) {
																		if (resp.split('_')[w] === '1') {
																			rr += "," + counter.toString();
																		}
																		counter++;
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
								break;
							}
							case "qdata": { break; }
							case "position": {
								break;
							}
							case "totalscore": {
								theR.totalscore = item;
								break;
							}
							case "fbid": {
								theR.fbid = item;
								if (theR.fbid !== fbid) {
									fbids++;
									rpos = 1;
									fbid = theR.fbid;
									for (var cc = 0, ccl = crsData.length; cc < ccl; cc++) {
										if (crsData[cc].cpk1 === theR.cpk1) {
											if (crsData[cc].fbids.indexOf(fbid) === -1) {
												crsData[cc].fbids.push(fbid);
												crsData[cc].responses++;
												break;
											}
										}
									}
								} else {
									rpos++;
								}
								break;
							}
							case "pk1": {
								theR.pk1 = item;
								break;
							}
							case "grand_pk1": { theR.grand_pk1 = item; break; }
							case "kind_id": { theR.kind_id = item; break; }
							case "qpk1": {
								break;
							}
							case "user_id": {
								theR.user_id = item;
								break;
							}
							case "lastname": { theR.lastname = item; break; }
							case "firstname": { theR.firstname = item; break; }
							case "mdate": { theR.mdate = item.substring(0, 10); break; }
							case "status": {
								theR.status = item;
								break;
							}
							case "bbmd_grade": { break; }
						}
					}
				}
			}
		}
		if (ok) {
			if (demoQs.indexOf(theR.qpk1) === -1) {
				if (bburl.indexOf('luonline') > -1) {
					var tst = theR.cpk1 + '_' + theR.fbid + '_' + theR.position;
					if (tr.indexOf(tst) === -1) {
						rawScores.push(theR);
						tr.push(tst);
					}
				} else {
					rawScores.push(theR);
				}
			}
		}
		else {
			if (isDebug()) {
				console.log('Not ok q=' + q + " " + theR.firstname + " " + theR.position);
			}
		}
		k++;
		if (k >= kl) {
			tr = [];
			remainder(mok, dudFbids, rpos, ok, fbid, cpk1);
		}
		else {
			setTimeout(next, 0);
		}
	}
	//#endregion
	setTimeout(next, 0);
}

function remainder(mok, dudFbids, rpos, ok, fbid, cpk1) {
	phd = '<h1>' + ass.title;
	var delRecs = [];
	var countEx = 0;
	var qusers = [];
	// temporary
	scoreQs = [];
	for (var i = 0, il = uniqueQs.length; i < il; i++) {
		if (uniqueQs[i].theQ === 'undefined') continue;
		uniqueQs[i].theQ.position = uniqueQs[i].position;
		scoreQs.push(uniqueQs[i].theQ);
	}
	pos = scoreQs.length;
	scoreQs.forEach((el, i) => {
		maxRecs = (el.responses > maxRecs) ? el.responses : maxRecs;
		minRecs = (el.responses < minRecs) ? el.responses : minRecs;
		console.log("i = " + i + " position = " + el.position + " responses = " + el.responses + ' qpk1=' + el.pk1);
	});
	if (maxRecs !== minRecs) {
		mainscope.Warn($L.msg.test_differed, true);
		differed = true;
		doKr = false;
	}
	// remove duds
	if (dudFbids.length > 0) {
		var rawCopy = new Array();
		for (var d = 0, dl = rawScores.length; d < dl; d++) {
			if ($.inArray(rawScores[d].fbid, dudFbids) === -1) {
				rawCopy.push(rawScores[d]);
			}
		}
		rawScores = rawCopy;
	}
	poss = rawScores.length;
	var fbid = rawScores[0].fbid;
	var j = 0;
	var process = function () {
		for (; j < poss; j++) {
			var theR = rawScores[j];
			var matches = $.grep(fbidsRaw, function (e) { if (e.fbid === theR.fbid) { return true; } });
			if (matches.length === 0) {
				fbidsRaw.push(theR);
				continue;
			}
			if (j + 1 < poss && j % 100 == 0) setTimeout(process, 5);
		}
	}
	process();

	fbidsRaw.sort(function (a, b) {
		var comp = b.totalscore - a.totalscore;
		if (comp == 0) comp = a.fbid - b.fbid;
		return comp;
	});
	var fbTot = [];
	// 1480 here
	for (var i = 0; i < pos; i++) ptot.push(0);
	var rawCopy = new Array(fbidsRaw.length * pos);
	rawCopy.fill(0);
	var r = 0;
	grandTot = 0.0;
	var avs = [];
	var start = new Date().getTime();
	//console.log("start " + start);
	var process = function () {
		for (; r < fbidsRaw.length; r++) {
			var anR = fbidsRaw[r];
			var row = Enumerable.from(rawScores).where(function (x) {
				return x.fbid === anR.fbid;
			}).toArray();
			var av = 0.0;
			for (var rr = 0; rr < row.length; rr++) {
				var p = parseInt(row[rr].position);
				rawCopy[(r * pos) + p] = row[rr];
				av += (!row[rr].skipped) ? row[rr].score : 0;
				// grandTot += row[rr].score;
				scoreQs[p].scored++;
				scoreQs[p].score += row[rr].score;
				ptot[p] += row[rr].score;
				row[rr].status = 1;
				if (row[rr].skipped) {
					skips.push(new aSkip(r + 1, p + 6));
				}
			}
			avs.push(av);
			for (var q = 0; q < pos; q++) {
				if (rawCopy[(r * pos) + q] === 0) {
					var R = $.extend({}, anR);
					R.score = 0;
					R.skipped = true;
					R.status = 0;
					rawCopy[(r * pos) + q] = R;
				}
			}
			if (r + 1 < length && r % 50 == 0) setTimeout(process, 0);
		}
	}
	process();
	var tt = 0.0;
	for (var i = 0; i < avs.length; i++) tt += avs[i];
	grandTot = tt;
	var end = new Date().getTime();
	console.log("end " + (end - start));
	rawScores = rawCopy;
	performLongTask();
}

function performLongTask() {
	notify($L.loading.filling_grids);
	return $.Deferred(function(def){setTimeout(function(){fillGrids();},5)});
}

function makeOutsMgr() {
	myOutsMgr = new Array();
	for (var q = 0, ql = pos; q < ql; q++) {
		var aQ = scoreQs[q];
		var arow = new myOutsMgrRow(q, aQ);
		var row = new Object();
		for (n in arow) {
			if (arow.hasOwnProperty(n)) {
				switch (n) {
					case "No": { row[n] = arow[n]; break; }
					case "Outcome": { row[n] = arow[n]; break; }
					case "Question": { row[n] = arow[n]; break; }
					default: { row[n] = arow[n]; break; }
				}
			}
		}
		row.score = aQ.score;
		row.scored = aQ.scored;
		myOutsMgr.push(row);
	}
	return myOutsMgr;
}

function myOutsMgrRow(q, Mcq) {
	this.No = Mcq.position;
	this.Question = (Mcq.q.length > 500) ? Mcq.q.substring(0, 497) + '...' : Mcq.q;
	var cats = "", xcats = "";
	this.qpk1 = Mcq.pk1;
	this.cpk1 = Mcq.cpk1;
	for (var i = 0, il = souts.length; i < il; i++) {
		if (souts[i].cpk1.indexOf(this.cpk1) !== -1 && souts[i].qpk1.indexOf(this.qpk1) !== -1) {
			cats += souts[i].cat + '<br />';
			xcats += souts[i].cat + '; ';
		}
	}
	if (cats.length == 0) return;
	this.Outcome = cats.substring(0, cats.length - 6);
	this.xOutcome = xcats.substring(0, xcats.length - 2);
}

function doOutcomes(scoreQs) {  // does the scoring
	var ds = new sout();
	var sQs = scoreQs;
	for (var i = 0, il = souts.length; i < il; i++) {
		souts[i].score = 0;
		souts[i].scored = 0;
		souts[i].Qs = [];
	}
	for (var f = 0, fl = sQs.length; f < fl; f++) {
		var aQ = sQs[f];
		var csc = $.grep(souts, function (e) { return e.qpk1.indexOf(aQ.pk1) !== -1 && e.cpk1.indexOf(aQ.cpk1) !== -1; });
		if (csc.length > 0) {
			for (var g = 0, gl = csc.length; g < gl; g++) {
				csc[g].score += aQ.score;
				csc[g].scored += aQ.scored;
				csc[g].Qs.push(f);
			}
		} else {
			ds.score += aQ.score;
			ds.scored += aQ.scored;
			ds.Qs.push(f);
			ds.cpk1.push(aQ.cpk1);
			ds.qpk1.push(aQ.pk1);
		}
	}
	//souts.push(ds);
}

function calcPT(myGridDataS, passPercent, recs) { // calcPT(myGridDataS, passPercent)
	var myGridDataPT = [];
	var o = new Object();
	o["Threshhold"] = $.precision(passPercent, 1e-2);
	o["N"] = recs;
	var cats = 0;
	var oo = new Object();
	for (var n in myGridDataS[0]) {
		if (myGridDataS[0].hasOwnProperty(n)) {
			if (n !== "Respondent") {
				//// // console.log(n + " " + myGridDataS[0][n]);
				oo[n] = 0;
				oo[n + "count"] = 0;
				cats++;
			}
		}
	}
	// console.log("cats = " + cats);
	for (var i = 0; i < myGridDataS.length; i++) {
		for (var n in myGridDataS[i]) {
			if (myGridDataS[i].hasOwnProperty(n)) {
				if (!isNaN(myGridDataS[i][n])) {
					oo[n] += (myGridDataS[i][n] >= passPercent) ? 1 : 0;
					oo[n + "count"]++;
					//// console.log(n + " " + myGridDataS[i][n] + " " + oo[n] + " / " + oo[n + "count"]);
				}
			}
		}
	}
	// o[sout.cat] = $.precision(avg, 1e-2);
	for (var n in myGridDataS[0]) {
		if (myGridDataS[0].hasOwnProperty(n)) {
			if (n !== "Respondent") {
				o[n] = $.precision(100 * (oo[n] / oo[n + "count"]), 1e-1);
				// console.log(n + " " + o[n]);
			}
		}
	}
	myGridDataPT.push(o);
	return myGridDataPT;
}

function makeOutcomesData() {
	myOutsData = new Array();
	myOutsDatag = new Array();
	for (var cat = 0, catl = souts.length; cat < catl; cat++) {
		if (souts[cat].scored > 0) {
			var arow = new Object();
			var row = new outsData(souts[cat].cat, souts[cat].scored, $.precision(souts[cat].score / souts[cat].scored, 1e-2), passPercent);
			row["Percent Met"] = getRowPercent(row, myGridDataS);
			row["% Qs"] = $.precision(100 * (souts[cat].Qs.length / pos), 1e-1);
			row["# Qs"] = souts[cat].Qs.length;
			for (n in row) {
				if (row.hasOwnProperty(n)) {
					switch (n) {
						case "Avg": { arow[n] = row[n]; break; }
						case "Outcomes": { arow[n] = row[n]; break; }
						case "Percent Met": { arow[n] = row[n]; break; }
						case "# Qs": { arow[n] = row[n]; break; }
						case "% Qs": { arow[n] = row[n]; break; }
						case "Scored": { arow[n] = row[n]; break; }
						case "Threshhold": { arow[n] = row[n]; break; }
						default: { arow[n] = row[n]; break; }
					}
				}
			}
			let searched = cats.find(function(e){return e.unique_id==arow.Outcomes;});
			arow.desc = searched ? searched.desc : 'No attached goals';
			if (searched) myOutsData.push(arow);
			myOutsDatag.push(row);
		}
	}
	return myOutsData;
}

function getRowPercent(row, myGridDataS) {
	var count = 0//myGridDataS.length;
	var above = 0;
	for (var i = 0; i < myGridDataS.length; i++) {
		above += (myGridDataS[i][row.Outcomes] >= row.Threshhold) ? 1.0 : 0.0;
		count += (myGridDataS[i][row.Outcomes] != "--") ? 1.0 : 0.0
	}
	return $.precision(above / count, 1e-2);
}

function outsData(cat, scored, avg, passPercent) {
	this.Outcomes = cat;
	this.Scored = scored;
	this.Avg = avg;
	this.Threshhold = passPercent;
	this.percent = 0;
	this.percentQs = 0;
	this.Qs = 0;
}

// makeDistractorsTable
function GetDistractorsData(cols) {
	var colHeaders = cols;
	myGridData = new Array();
	quest = '';
	s = "";
	var sw = [];
	var uans;
	var pk1 = scoreQs[0].pk1;
	var ppk1 = 0;
	var qno = 1;
	for (var q = 0, ql = pos; q < ql; q++) {
		if (scoreQs[q].scored == 0) {
			duds.push(q);
			continue;
		}
		sw = [];
		var mm = distractors[q];
		total = scoreQs[q].scored;
		qs = scoreQs[q].q;
		pkk1 = scoreQs[q].pk1;
		// qno = scoreQs[q].qno;
		qno = scoreQs[q].position;
		uans = [];
		var arr = $.grep(rawScores, function (n, i) {
			var t = false;
			try {
				var t = (n.qpk1 === scoreQs[q].pk1);
			} catch (e) {
			}
			return t;
		});
		if (scoreQs[q].kind_id == 3) {
			fr = '';
			var isZero = false;
			var p = -1;
			var ch = scoreQs[q].choices;
			var corr = scoreQs[q].correct.split('::');
			var swc = '';
			for (var o = 0; o < ch.length; o++) {
				for (var t = 0; t < corr.length; t++) {
					try {
						if (ch[o].trim() === corr[t].trim())
							swc += ',' + o;
					} catch (e) {
						console.log("the position = " + q);
					}
				}
			}
			swc = swc.substring(1);
			swc += 'xxx';
			var rs = new Array(scoreQs[q].choices.length);
			for (var i = 0; i < scoreQs[q].choices.length; i++) {
				rs[i] = 0;
			}
			for (var e = 0, el = arr.length; e < el; e++) {
				var pieces = arr[e].response.split('::');
				for (var d = 0; d < scoreQs[q].choices.length; d++) {
					for (var p = 0; p < pieces.length; p++) {
						if (pieces[p].trim() === scoreQs[q].choices[d]) {
							rs[d]++;
						}
					}
				}
			}
			for (var r = 0; r < rs.length; r++) {
				swc += rs[r] + ',';
			}
			swc = swc.substring(0, swc.length - 1);
			var tresp = 0;
			for (var e = 0, el = arr.length; e < el; e++) {
				fr += arr[e].response;
				if (arr[e].response.trim() === scoreQs[q].correct.trim()) { isZero = true; }
				var found = false;
				for (var f = 0; f < uans.length; f++) {
					if (uans[f][0] == arr[e].response) {
						if (arr[e].status > 0) {
							uans[f][1]++;
						}
						found = true;
						break;
					}
				}
				if (!found) {
					var no = (arr[e].status > 0) ? 1 : 0;
					uans.push([arr[e].response.trim(), no]);
					found = false;
				}
			}
			uans.sort(function (a, b) {
				return b[1] - a[1];
			});
			if (!isZero) {
				uans.unshift([scoreQs[q].correct, 0]);
			}
			s += 'fr=' + fr;
			var cl = uans.length;
			var maxl = 4;
			var tresps = 0;
			//  var swc = correctChoices + "xxx" + mm.responses;
			for (var c = 0; c < cl; c++) {
				if (c > maxl) { break; }
				var drow = new Disrow();
				var name = "";
				if (quest !== qs || pk1 !== ppk1) {
					name = qs;
					quest = qs;
					pk1 = ppk1;
				}
				if (name.length > 0) {
					drow[colHeaders[0]] = qno;
					drow[colHeaders[1]] = scoreQs[q].QTAbbre;
					drow[colHeaders[2]] = name;
				}
				resps = uans[c][1];
				percent = $.precision(((resps / total) * 100), 1e-1);
				tresps += resps;
				value = resps + " (" + percent + "%)  ";
				tvalue = (uans[c][0].trim() === scoreQs[q].correct.trim()) ? true : false;
				ca = ' ';
				if (tvalue) {
					ca = $L.correct_value;
				}
				cf = '';
				var sw = uans[c][0].split(',');
				drow[colHeaders[5]] = value + " " + sw.join(',');
				drow[colHeaders[3]] = (survey) ? '' : ca;
				var pb = mm.pb[c];
				if (typeof pb === 'undefined' || pb === null || pb.length === 0) {
					pb = "--";
				}
				drow[colHeaders[4]] = pb;
				drow[colHeaders[6]] = swc;
				drow.n = resps;
				drow.percent = $.precision(percent / 100, 1e-2);
				myGridData.push(drow);
			}
			if (maxl < uans.length && c < uans.length) {
				var drow = new Disrow();
				var name = "";
				if (quest !== qs || pk1 !== ppk1) {
					name = qs;
					quest = qs;
					pk1 = ppk1;
				}
				if (name.length > 0) {
					drow[colHeaders[0]] = qno;
					drow[colHeaders[1]] = scoreQs[q].QTAbbre;
					drow[colHeaders[2]] = name;
				}
				resps = total - tresps;
				percent = $.precision(((resps / total) * 100), 1e-1);
				value = resps + " (" + percent + "%)  ";
				tvalue = (uans[c][0] === scoreQs[q].correct) ? true : false;
				ca = ' ';
				if (tvalue) {
					ca = $L.correct_value;
				}
				cf = $L.t_distractors.other_responses;
				drow[colHeaders[5]] = value + " " + cf;
				drow[colHeaders[3]] = (survey) ? '' : ca;
				var pb = mm.pb[c];
				if (typeof pb === 'undefined') {
					pb = "--";
				}
				drow[colHeaders[4]] = pb;
				drow[colHeaders[6]] = swc;
				drow.n = resps;
				drow.percent = $.precision(percent / 100, 1e-2);
				myGridData.push(drow);
			}
		}
		else
			if (scoreQs[q].kind_id == 13) {
				fr = '';
				var isZero = false;
				var p = -1;
				var ch = scoreQs[q].choices;
				var corr = scoreQs[q].correct.split('::');
				var swc = '';
				for (var o = 0; o < ch.length; o++) {
					for (var t = 0; t < corr.length; t++) {
						try {
							if (ch[o].trim() === corr[t].trim())
								swc += ',' + o;
						} catch (e) {
							console.log("the position = " + q);
						}
					}
				}
				swc = swc.substring(1);
				swc += 'xxx';
				var rs = new Array(scoreQs[q].choices.length);
				for (var i = 0; i < scoreQs[q].choices.length; i++) {
					rs[i] = 0;
				}
				for (var e = 0, el = arr.length; e < el; e++) {
					var pieces = arr[e].response.split('::');
					for (var d = 0; d < scoreQs[q].choices.length; d++) {
						for (var p = 0; p < pieces.length; p++) {
							if (pieces[p].trim() === scoreQs[q].choices[d]) {
								rs[d]++;
							}
						}
					}
				}
				for (var r = 0; r < rs.length; r++) {
					swc += rs[r] + ',';
				}
				swc = swc.substring(0, swc.length - 1);
				var tresp = 0;
				for (var e = 0, el = arr.length; e < el; e++) {
					fr += arr[e].response;
					if (arr[e].response.trim() === scoreQs[q].correct.trim()) { isZero = true; }
					var found = false;
					for (var f = 0; f < uans.length; f++) {
						if (uans[f][0] == arr[e].response) {
							if (arr[e].status > 0) {
								uans[f][1]++;
							}

							found = true;
							break;;
						}
					}
					if (!found) {
						var no = (arr[e].status > 0) ? 1 : 0;
						uans.push([arr[e].response.trim(), no]);
						found = false;
					}
				}
				uans.sort(function (a, b) {
					return b[1] - a[1];
				});
				if (!isZero) {
					uans.unshift([scoreQs[q].correct, 0]);
				}
				s += 'fr=' + fr;
				var cl = uans.length;
				var maxl = 4;
				var tresps = 0;
				//  var swc = correctChoices + "xxx" + mm.responses;
				for (var c = 0; c < cl; c++) {
					if (c > maxl) { break; }
					var drow = new Disrow();
					var name = "";
					if (quest !== qs || pk1 !== ppk1) {
						name = qs;
						quest = qs;
						pk1 = ppk1;
					}
					if (name.length > 0) {
						drow[colHeaders[0]] = qno;
						drow[colHeaders[1]] = scoreQs[q].QTAbbre;
						drow[colHeaders[2]] = name;
					}
					resps = uans[c][1];
					percent = $.precision(((resps / total) * 100), 1e-1);
					tresps += resps;
					value = resps + " (" + percent + "%)  ";
					tvalue = (uans[c][0].trim() === scoreQs[q].correct.trim()) ? true : false;
					ca = ' ';
					if (tvalue) {
						ca = $L.correct_value;
					}
					cf = '';
					var sw = uans[c][0].split(',');
					drow[colHeaders[5]] = value + " " + sw.join(',');
					drow[colHeaders[3]] = (survey) ? '' : ca;
					var pb = mm.pb[c];
					if (typeof pb === 'undefined' || pb === null || pb.length === 0) {
						pb = "--";
					}
					drow[colHeaders[4]] = pb;
					drow[colHeaders[6]] = swc;
					drow.n = resps;
					drow.percent = $.precision(percent / 100, 1e-2);
					myGridData.push(drow);
				}
				if (maxl < uans.length && c < uans.length) {
					var drow = new Disrow();
					var name = "";
					if (quest !== qs || pk1 !== ppk1) {
						name = qs;
						quest = qs;
						pk1 = ppk1;
					}
					if (name.length > 0) {
						drow[colHeaders[0]] = qno;
						drow[colHeaders[1]] = scoreQs[q].QTAbbre;
						drow[colHeaders[2]] = name;
					}
					resps = total - tresps;
					percent = $.precision(((resps / total) * 100), 1e-1);

					value = resps + " (" + percent + "%)  ";
					tvalue = (uans[c][0] === scoreQs[q].correct) ? true : false;
					ca = ' ';
					if (tvalue) {
						ca = $L.correct_value;
					}
					cf = $L.t_distractors.other_responses;
					drow[colHeaders[5]] = value + " " + cf;
					drow[colHeaders[3]] = (survey) ? '' : ca;
					var pb = mm.pb[c];
					if (typeof pb === 'undefined') {
						pb = "--";
					}
					drow[colHeaders[4]] = pb;
					drow[colHeaders[6]] = swc;
					drow.n = resps;
					drow.percent = $.precision(percent / 100, 1e-2);
					myGridData.push(drow);
				}
			}
			else {
				if (scoreQs[q].kind_id == 11) {
					uans = new Array();
					ucount = Array();
					var isZero = false;
					arr.sort(function (a, b) {
						return ((a.response > b.response) ? 1 : -1);
					});
					for (var e = 0, el = arr.length; e < el; e++) {
						u = uans.indexOf(arr[e].response);
						if (uans.length == 0 || u < 0) {
							if (arr[e].response == 0) { isZero = true; }
							uans.push(arr[e].response);
							ucount.push(1);
						} else {
							ucount[u]++;
						}
					}
					if (!isZero) {
						uans.push(0);
						ucount.push(0);
						uans.reverse();
						ucount.reverse();
					}
					for (var c = 0, cl = uans.length; c < cl; c++) {
						var drow = new Disrow();
						var name = "";
						if (quest !== qs || pk1 !== ppk1) {
							name = qs;
							quest = qs;
							pk1 = ppk1;
						}
						if (name.length > 0) {
							drow[colHeaders[0]] = qno;
							drow[colHeaders[1]] = scoreQs[q].QTAbbre;
							drow[colHeaders[2]] = name;
						}
						resps = ucount[c];
						percent = $.precision(((resps / total) * 100), 1e-1);
						value = resps + " (" + percent + "%)  ";
						cf = '0';
						sw = ["0", "1"];//uans[c].split(',');
						cf = sw[c];
						drow[colHeaders[5]] = value;
						tvalue = (cf === scoreQs[q].correct) ? true : false;
						ca = ' ';
						if (tvalue) {
							ca = $L.correct_value;
						}
						var pb = mm.pb[c];
						if (typeof pb === 'undefined') {
							pb = "--";
						}
						drow[colHeaders[3]] = (survey) ? '' : ca;
						var pb = mm.pb[c];
						drow[colHeaders[4]] = pb;
						sw += "xxx" + mm.responses;
						drow[colHeaders[6]] = sw;
						drow.n = resps;
						drow.percent = $.precision(percent / 100, 1e-2);
						myGridData.push(drow);
					}
				}
				else {
					if (scoreQs[q].kind_id == 5) {
						uans = [];
						s = 'len=' + arr.length + '<br>';
						fr = '';
						var isZero = false;
						var p = -1;
						var tresp = 0;
						for (var e = 0, el = arr.length; e < el; e++) {
							fr += arr[e].response;
							if (arr[e].response === scoreQs[q].correct) { isZero = true; }
							var found = false;
							for (var f = 0; f < uans.length; f++) {
								if (uans[f][0] == arr[e].response) {
									if (arr[e].status > 0) {
										uans[f][1]++;
									}
									found = true;
									break;;
								}
							}
							if (!found) {
								uans.push([arr[e].response, (arr[e].status > 0) ? 1 : 0]);
								found = false;
							}
						}
						uans.sort(function (a, b) {
							return b[1] - a[1];
						});
						if (!isZero) {
							uans.unshift([scoreQs[q].correct, 0]);
						}
						s += 'fr=' + fr;
						var c = 0;
						var maxl = 7;
						var tresps = 0;
						for (cl = uans.length; c < cl; c++) {
							if (c > maxl) { break; }
							var drow = new Disrow();
							var name = "";
							if (quest !== qs || pk1 !== ppk1) {
								name = qs;
								quest = qs;
								pk1 = ppk1;
							}
							if (name.length > 0) {
								drow[colHeaders[0]] = qno;
								drow[colHeaders[1]] = scoreQs[q].QTAbbre;
								drow[colHeaders[2]] = name;
							}
							resps = uans[c][1];
							percent = $.precision(((resps / total) * 100), 1e-1);
							tresps += resps;
							value = resps + " (" + percent + "%)  ";
							tvalue = (uans[c][0] === scoreQs[q].correct) ? true : false;
							ca = ' ';
							if (tvalue) {
								ca = $L.correct_value;
							}
							cf = '';
							var sw = uans[c][0];//.split(',');
							for (var f = 0, fl = scoreQs[q].choices.length; f < fl; f++) {
								var theQ = scoreQs[q];
								var p = scoreQs[q].choices.indexOf(scoreQs[q].choices[sw[f]]);
								var x = p % scoreQs[q].choices.length;
								cf += ', ' + scoreQs[q].choices[f] + '::' + scoreQs[q].rChoices[x];
							}
							cf = cf.substring(2);
							drow[colHeaders[5]] = value + " " + sw;
							drow[colHeaders[3]] = (survey) ? '' : ca;
							var pb = mm.pb[c];
							if (typeof pb === 'undefined') {
								pb = "--";
							}
							drow[colHeaders[4]] = pb;
							drow[colHeaders[6]] = sw;
							drow.n = resps;
							drow.percent = $.precision(percent / 100, 1e-2);
							myGridData.push(drow);
						}
						if (maxl < uans.length && c < uans.length) {
							var drow = new Disrow();
							var name = "";
							if (quest !== qs || pk1 !== ppk1) {
								name = qs;
								quest = qs;
								pk1 = ppk1;
							}
							if (name.length > 0) {
								drow[colHeaders[0]] = qno;
								drow[colHeaders[1]] = scoreQs[q].QTAbbre;
								drow[colHeaders[2]] = name;
							}
							resps = total - tresps;
							percent = $.precision(((resps / total) * 100), 1e-1);
							value = resps + " (" + percent + "%)  ";
							tvalue = (uans[c][0] === scoreQs[q].correct) ? true : false;
							ca = ' ';
							if (tvalue) {
								ca = $L.correct_value;
							}
							cf = $L.t_distractors.other_responses;
							drow[colHeaders[5]] = value + " " + sw;
							drow[colHeaders[3]] = (survey) ? '' : ca;
							var pb = mm.pb[c];
							if (typeof pb === 'undefined') {
								pb = "--";
							}
							drow[colHeaders[4]] = pb;
							drow[colHeaders[6]] = sw;
							drow.n = resps;
							drow.percent = $.precision(percent / 100, 1e-2);
							myGridData.push(drow);
						}
					}
					else {
						if (scoreQs[q].kind_id == 4 || scoreQs[q].kind_id == 8) {
							uans = [];
							s = 'len=' + arr.length + '<br>';
							fr = '';
							var isZero = false;
							var p = -1;
							var tresp = 0;
							for (var e = 0, el = arr.length; e < el; e++) {
								fr += arr[e].response;
								if (arr[e].response == scoreQs[q].correct) { isZero = true; }
								var found = false;
								for (var f = 0; f < uans.length; f++) {
									if (uans[f][0] == arr[e].response) {
										if (arr[e].status > 0) {
											uans[f][1]++;
										}
										found = true;
										break;;
									}
								}
								if (!found) {
									uans.push([arr[e].response, (arr[e].status > 0) ? 1 : 0]);
									found = false;
								}
							}
							if (scoreQs[q].kind_id != 4) {
								uans.sort(function (a, b) {
									return b[1] - a[1];
								});
							}
							if (!isZero) {
								uans.unshift([scoreQs[q].correct, 0]);
							}
							s += 'fr=' + fr;
							var c = 0;
							var maxl = (scoreQs[q].kind_id == 4) ? 7 : 2;
							var tresps = 0;
							for (cl = uans.length; c < cl; c++) {
								if (c > maxl) { break; }
								var drow = new Disrow();
								var name = "";
								if (quest !== qs || pk1 !== ppk1) {
									name = qs;
									quest = qs;
									pk1 = ppk1;
								}
								if (name.length > 0) {
									drow[colHeaders[0]] = qno;
									drow[colHeaders[1]] = scoreQs[q].QTAbbre;
									drow[colHeaders[2]] = name;
								}
								resps = uans[c][1];
								percent = $.precision(((resps / total) * 100), 1e-1);
								tresps += resps;
								value = resps + " (" + percent + "%)  ";
								tvalue = (uans[c][0] === scoreQs[q].correct) ? true : false;
								ca = ' ';
								if (tvalue) {
									ca = $L.correct_value;
								}
								cf = '';
								var sw = uans[c][0];
								for (var f = 0, fl = scoreQs[q].choices.length; f < fl; f++) {
									var theQ = scoreQs[q];
									var p = scoreQs[q].choices.indexOf(scoreQs[q].choices[sw[f]]);
									var x = p % scoreQs[q].choices.length;
									cf += ', ' + scoreQs[q].choices[f];
								}
								cf = cf.substring(2);
								drow[colHeaders[5]] = value + " " + sw;
								drow[colHeaders[3]] = (survey) ? '' : ca;
								var pb = mm.pb[c];
								if (typeof pb === 'undefined') {
									pb = "--";
								}
								drow[colHeaders[4]] = pb;
								drow[colHeaders[6]] = sw;
								drow.n = resps;
								drow.percent = $.precision(percent / 100, 1e-2);
								myGridData.push(drow);
							}
							if (maxl < uans.length && c < uans.length) {
								var drow = new Disrow();
								var name = "";
								if (quest !== qs || pk1 !== ppk1) {
									name = qs;
									quest = qs;
									pk1 = ppk1;
								}
								if (name.length > 0) {
									drow[colHeaders[0]] = qno;
									drow[colHeaders[1]] = scoreQs[q].QTAbbre;
									drow[colHeaders[2]] = name;
								}
								resps = total - tresps;
								percent = $.precision(((resps / total) * 100), 1e-1);
								value = resps + " (" + percent + "%)  ";
								tvalue = (uans[c][0] === scoreQs[q].correct) ? true : false;
								ca = ' ';
								if (tvalue) {
									ca = $L.correct_value;
								}
								cf = $L.t_distractors.other_responses;
								drow[colHeaders[5]] = value + " " + sw;
								drow[colHeaders[3]] = (survey) ? '' : ca;
								var pb = mm.pb[c];
								if (typeof pb === 'undefined') {
									pb = "--";
								}
								drow['PtBis'] = pb;
								drow[colHeaders[6]] = sw;
								drow.n = resps;
								drow.percent = $.precision(percent / 100, 1e-2);
								myGridData.push(drow);
							}
						} else {
							if (scoreQs[q].kind_id == 12) {
								uans = [];
								s = 'len=' + arr.length + '<br>';
								fr = '';
								var isZero = false;
								var p = -1;
								var tresp = 0;
								for (var e = 0, el = arr.length; e < el; e++) {
									fr += arr[e].response;
									if (arr[e].response === scoreQs[q].correct) { isZero = true; }
									var found = false;
									for (var f = 0; f < uans.length; f++) {
										if (uans[f][0] == arr[e].response) {
											if (arr[e].status > 0) {
												uans[f][1]++;
											}
											found = true;
											break;;
										}
									}
									if (!found) {
										uans.push([arr[e].response, (arr[e].status > 0) ? 1 : 0]);
										found = false;
									}
								}
								uans.sort(function (a, b) {
									return b[1] - a[1];
								});
								if (!isZero) {
									uans.unshift([scoreQs[q].correct, 0]);
								}
								s += 'fr=' + fr;
								var c = 0;
								var maxl = 3;
								var tresps = 0;
								for (cl = uans.length; c < cl; c++) {
									if (c > maxl) { break; }
									var drow = new Disrow();
									var name = "";
									if (quest !== qs || pk1 !== ppk1) {
										name = qs;
										quest = qs;
										pk1 = ppk1;
									}
									if (name.length > 0) {
										drow[colHeaders[0]] = qno;
										drow[colHeaders[1]] = scoreQs[q].QTAbbre;
										drow[colHeaders[2]] = name;
									}
									resps = uans[c][1];
									percent = $.precision(((resps / total) * 100), 1e-1);
									tresps += resps;
									value = resps + " (" + percent + "%)  ";
									tvalue = (uans[c][0] === scoreQs[q].correct) ? true : false;
									ca = ' ';
									if (tvalue) {
										ca = $L.correct_value;
									}
									cf = '';
									var sw = uans[c][0];
									for (var f = 0, fl = scoreQs[q].choices.length; f < fl; f++) {
										var theQ = scoreQs[q];
										var p = scoreQs[q].choices.indexOf(scoreQs[q].choices[sw[f]]);
										var x = p % scoreQs[q].choices.length;
										cf += ', ' + scoreQs[q].choices[f];
									}
									cf = cf.substring(2);
									drow[colHeaders[5]] = value + " " + sw;
									drow[colHeaders[3]] = (survey) ? '' : ca;
									var pb = mm.pb[c];
									if (typeof pb === 'undefined') {
										pb = "--";
									}
									drow[colHeaders[4]] = pb;
									drow[colHeaders[6]] = sw;
									drow.n = resps;
									drow.percent = $.precision(percent / 100, 1e-2);
									myGridData.push(drow);
								}
							} else {
								if (scoreQs[q].kind_id == 6) {
									uans = [];
									s = 'len=' + arr.length + '<br>';
									fr = '';
									var isZero = false;
									var p = -1;
									var tresp = 0;
									for (var e = 0, el = arr.length; e < el; e++) {
										fr += arr[e].response;
										if (arr[e].score === 1) { isZero = true; }
										var found = false;
										for (var f = 0; f < uans.length; f++) {
											if (uans[f][0] == arr[e].response) {
												if (arr[e].status > 0) {
													uans[f][1]++;
												}
												found = true;
												break;;
											}
										}
										if (!found) {
											var no = (arr[e].status > 0) ? 1 : 0;
											uans.push([arr[e].response, no]);
											found = false;
										}
									}
									uans.sort(function (a, b) {
										return b[1] - a[1];
									});
									if (!isZero) {
										uans.unshift([scoreQs[q].correct, 0]);
									}
									s += 'fr=' + fr;
									var c = 0;
									var maxl = 2;
									var tresps = 0;
									for (cl = uans.length; c < cl; c++) {
										if (c > maxl) { break; }
										var drow = new Disrow();
										var name = "";
										if (quest !== qs || pk1 !== ppk1) {
											name = qs;
											quest = qs;
											pk1 = ppk1;
										}
										if (name.length > 0) {
											drow[colHeaders[0]] = qno;
											drow[colHeaders[1]] = scoreQs[q].QTAbbre;
											drow[colHeaders[2]] = name;
										}
										resps = uans[c][1];
										percent = $.precision(((resps / total) * 100), 1e-1);
										tresps += resps;
										value = resps + " (" + percent + "%)  ";
										//  tvalue = (uans[c][2] > 0) ? true : false;
										tvalue = (uans[c][0] === scoreQs[q].correct) ? true : false;
										ca = ' ';
										if (tvalue) {
											ca = $L.correct_value;
										}
										cf = '';
										var sw = uans[c][0];
										for (var f = 0, fl = scoreQs[q].choices.length; f < fl; f++) {
											var theQ = scoreQs[q];
											var p = scoreQs[q].choices.indexOf(scoreQs[q].choices[sw[f]]);
											var x = p % scoreQs[q].choices.length;
											cf += ', ' + scoreQs[q].choices[f];
										}
										cf = cf.substring(2);
										drow[colHeaders[5]] = value + " " + sw;
										drow[colHeaders[3]] = (survey) ? '' : ca;
										var pb = mm.pb[c];
										if (typeof pb === 'undefined') {
											pb = "--";
										}
										drow['PtBis'] = pb;
										drow[colHeaders[6]] = sw;
										drow.n = resps;
										drow.percent = $.precision(percent / 100, 1e-2);
										myGridData.push(drow);
									}
									if (maxl < uans.length && c < uans.length) {
										var drow = new Disrow();
										var name = "";
										if (quest !== qs || pk1 !== ppk1) {
											name = qs;
											quest = qs;
											pk1 = ppk1;
										}
										if (name.length > 0) {
											drow[colHeaders[0]] = qno;
											drow[colHeaders[1]] = scoreQs[q].QTAbbre;
											drow[colHeaders[2]] = name;
										}
										resps = total - tresps;
										percent = $.precision(((resps / total) * 100), 1e-1);

										value = resps + " (" + percent + "%)  ";
										tvalue = (uans[c][0] === scoreQs[q].correct) ? true : false;
										ca = ' ';
										if (tvalue) {
											ca = $L.correct_value;
										}
										cf = $L.t_distractors.other_responses;
										drow[colHeaders[5]] = value + cf;
										drow[colHeaders[3]] = (survey) ? '' : ca;
										var pb = mm.pb[c];
										if (typeof pb === 'undefined') {
											pb = "--";
										}
										drow['PtBis'] = pb;
										drow[colHeaders[6]] = sw;
										drow.n = resps;
										drow.percent = $.precision(percent / 100, 1e-2);
										myGridData.push(drow);
									}
								} else {
									if (scoreQs[q].kind_id == 1 || scoreQs[q].kind_id == 15 || scoreQs[q].kind_id == 2
										|| scoreQs[q].kind_id == 17 || scoreQs[q].kind_id == 7
										|| scoreQs[q].kind_id == 10 || scoreQs[q].kind_id == 16
									) {
										for (var c = 0, cl = mm.choices.length; c < cl; c++) { // style="background-color:#8ef7bf"
											var drow = new Disrow();
											var name = "";
											if (quest !== qs || pk1 !== ppk1) {
												name = qs;
												quest = qs;
												pk1 = ppk1;
											}
											if (name.length > 0) {
												drow[colHeaders[0]] = qno;
												drow[colHeaders[1]] = scoreQs[q].QTAbbre;
												drow[colHeaders[2]] = name;
											}
											resps = mm.responses[c];
											if ((scoreQs[q].kind_id == 7 || scoreQs[q].kind_id == 10 || scoreQs[q].kind_id == 16)) {

												if (scoreQs[q].rpk1.length > 0 && scoreQs[q].qsub !== null) {
													total = 0;
													var begin = c - c % scoreQs[q].rChoices.length;
													var bend = begin + scoreQs[q].rChoices.length;
													for (var y = begin; y < bend; y++) {
														total += mm.responses[y];
													}
												} else {
													total = 0;
													for (var y = 0; y < mm.responses.length; y++) {
														total += mm.responses[y];
													}
												}
											}
											percent = $.precision(((resps / total) * 100), 1e-1);
											value = resps + " (" + percent + "%)  " + mm.choices[c];
											tvalue = (mm.correct === mm.choices[c]) ? true : false;
											ca = ' ';
											if (tvalue) {
												ca = $L.correct_value;
											}
											drow[colHeaders[5]] = value;
											drow[colHeaders[3]] = (survey) ? '' : ca;
											var pb = mm.pb[c];
											if (typeof pb === 'undefined') {
												pb = "--";
											}
											drow['PtBis'] = pb;
											drow[colHeaders[6]] = sw;
											drow.n = resps;
											drow.percent = $.precision(percent / 100, 1e-2);
											myGridData.push(drow);
										}
									} else {
										if (scoreQs[q].kind_id == 27 || scoreQs[q].kind_id == 36) {
											var theQ = scoreQs[q];
											var drow = new Disrow();
											var name = "";
											if (quest !== qs || pk1 !== ppk1) {
												name = qs;
												quest = qs;
												pk1 = ppk1;
											}
											if (name.length > 0) {
												drow[colHeaders[0]] = qno;
												drow[colHeaders[1]] = scoreQs[q].QTAbbre;
												drow[colHeaders[2]] = name;
											}
											resps = mm.responses[c];
											percent = $.precision(((resps / total) * 100), 1e-1);
											value = resps + " (" + percent + "%)  " + mm.choices[c];
											tvalue = (mm.correct === mm.choices[c]) ? true : false;
											ca = ' ';
											if (tvalue) {
												ca = $L.correct_value;
											}
											drow[colHeaders[5]] = value;
											drow[colHeaders[3]] = (survey) ? '' : ca;
											var pb = mm.pb[c];
											if (typeof pb === 'undefined') {
												pb = "--";
											}
											drow['PtBis'] = pb;
											drow[colHeaders[6]] = sw;
											drow.n = resps;
											drow.percent = $.precision(percent / 100, 1e-2);
											myGridData.push(drow);
										} else if (scoreQs[q].kind_id == 9) {
											var drow = new Disrow();
											var name = "";
											if (quest !== qs || pk1 !== ppk1) {
												name = qs;
												quest = qs;
												pk1 = ppk1;
											}
											if (name.length > 0) {
												drow[colHeaders[0]] = qno;
												drow[colHeaders[1]] = scoreQs[q].QTAbbre;
												drow[colHeaders[2]] = name;
											}
											tvalue = '';
											value = "";
											var pb = "--";
											drow['PtBis'] = pb;
											
											percent = $.precision((scoreQs[q].score/scoreQs[q].responses)*100, 1e-1);
											drow.percent = $.precision(scoreQs[q].score/scoreQs[q].responses, 1e-2);
											drow.n = scoreQs[q].score;
											drow[colHeaders[5]] = `${drow.n} (${percent}%) ${$L.correct_value}`;
											drow[colHeaders[3]] = $L.correct_value;
											
											drow[colHeaders[6]] = sw;
											myGridData.push(drow);
											
											drow = new Disrow();
											drow['PtBis'] = pb;
											drow.n = scoreQs[q].responses - scoreQs[q].score;
											drow.percent = $.precision(drow.n/scoreQs[q].responses, 1e-2);
											drow[colHeaders[5]] = `${drow.n} (${100-percent}%) ${$L.correct_incorrect}`;
											myGridData.push(drow);
										} else {
											var drow = new Disrow();
											var name = "";
											if (quest !== qs || pk1 !== ppk1) {
												name = qs;
												quest = qs;
												pk1 = ppk1;
											}
											if (name.length > 0) {
												drow[colHeaders[0]] = qno;
												drow[colHeaders[1]] = scoreQs[q].QTAbbre;
												drow[colHeaders[2]] = name;
											}
											tvalue = '';
											value = "";
											var pb = "--";
											try {
												drow[colHeaders[5]] = value + cf;
											} catch (e) {
												drow[colHeaders[5]] = value + 0;
											}
											drow[colHeaders[3]] = value;
											try {
												drow['PtBis'] = pb;
											} catch (e) {
												drow['PtBis'] = 'unknown';
											}
											drow[colHeaders[6]] = sw;
											myGridData.push(drow);
										}
									}
								}
							}
						}
					}
				}
			}
		pk1 = scoreQs[q].pk1;
	}
	return myGridData;
}

function ptBiserial(stuTotal, no_questions, scoretable) {
	var rows = stuTotal.length;
	var cols = no_questions;
	var xm = [];
	var ym = [];
	var pbs = [];
	distractors = new Array();
	var biserial = new Array(cols);

	for (var c = 0, colsl = cols; c < colsl; c++) {
		var theQ = scoreQs[c];
		for (var f = 0, fl = theQ.categories.length; f < fl; f++) {
			theQ.categories[f].score = 0;
			theQ.categories[f].scored = 0;
		}
		dis = new distract();
		dis.correct = theQ.correct;
		dis.choices = theQ.choices;
		dis.responses = [];
		dis.count = [];
		if (theQ.kind_id != 3) {
			dis.responses = new Array(theQ.choices.length);
			pbs = new Array(theQ.choices.length);
			for (var ch = 0, chl = dis.responses.length; ch < chl; ch++) {
				dis.responses[ch] = 0;
				pbs[ch] = 0;
				pbs[ch] = new Array(rows);
				for (var a = 0, rowsl = rows; a < rowsl; a++) {
					pbs[ch][a] = 0;
				}
			}
		}
		dem = new demo();
		for (var r = 0, rowsl = rows; r < rowsl; r++) { // try outomes here  ass.Qs[ass.Qs.length] = theQ;
			theR = scoretable[c + (r * cols)];
			if (typeof theR === 'undefined') {
				continue;
			}
			if (theR.status === 1) {
				dem.score += theR.score;
				dem.scored++;
			}
			var done = false;
			if (theQ.kind_id == 3 && theR.status === 1 && !done) {
				var p = -1;
				if (dis.responses !== null || dis.responses !== undefined) {
					p = dis.responses.indexOf(theR.response);
					if (p !== -1) {
						dis.count[p]++;
					} else {
						dis.responses.push(theR.response);
						dis.count.push(1);
					}
				} else {
					dis.responses = [];
					dis.responses.push(theR.response);

				}
				done = true;
			}
			if (theQ.kind_id == 13 && theR.status === 1 && !done) {
				// console.log("MA response " + theR.response);
				var p = -1;
				if (dis.responses !== null || dis.responses !== undefined) {
					p = dis.responses.indexOf(theR.response);
					if (p !== -1) {
						dis.count[p]++;
					} else {
						dis.responses.push(theR.response);
						dis.count.push(1);
					}
				} else {
					dis.responses = [];
					dis.responses.push(theR.response);

				}
				done = true;
			}
			if (theQ.kind_id == 12 && theR.status === 1 && !done) {
				if (theR.position == 17) {
					console.log('ptbi');
				}
				var p = -1;
				if (dis.responses !== null || dis.responses !== undefined) {
					p = dis.responses.indexOf(theR.response);
					if (p !== -1) {
						dis.count[p]++;
					} else {
						dis.responses.push(theR.response);
						dis.count.push(1);
					}
				} else {
					dis.responses = [];
					dis.responses.push(theR.response);

				}
				done = true;
			}
			if ((theQ.kind_id == 7 || theQ.kind_id == 10 || theQ.kind_id == 16) && theR.status === 1 && !done) {
				if (survey && (theQ.kind_id == 7 || theQ.kind_id == 10 || theQ.kind_id == 16)) {
					dis.responses[theR.response]++;
				} else if (theR.rpk1 > 0 && theQ.qsub !== null) {
					if (!(bburl.indexOf('tamu') > -1)) {

						try {
							for (var i = 0; i < theR.response.length; i++) {
								var cc = parseInt(theR.response[i]);
								dis.responses[i * theQ.rChoices.length + cc]++;
							}
						} catch (e) {
							console.log('theR.response no defined');
						}
					} else {
						// tamu situation
						// y = 0 - 3 for x = 0 - 1   so m = +3  = choices.length -1
						var b = 0;
						var m = theQ.rChoices.length - 1;
						var y = m * theR.score + b;
						dis.responses[y]++;

					}
				} else {

					var sc = theQ.choices.indexOf(theR.response);
					dis.responses[sc]++;
				}
				done = true;
			}
			if (theQ.kind_id == 5 && theR.status === 1 && !done) {
				// console.log("MAT response " + theR.response);
				var rrs = theR.response.split(",");
				for (var t = 0; t < rrs.length; t++) {
					dis.responses[rrs[t]]++;
					// console.log("in ptbi " + t + " " + dis.responses[rrs[t]]);
				}
				done = true;
			}

			if ((theQ.kind_id == 4 || theQ.kind_id == 6 || theQ.kind_id == 8) && theR.status === 1 && !done) {
				var p = -1;
				if (dis.responses !== null || dis.responses !== undefined) {
					p = dis.responses.indexOf(theR.response);
					if (p !== -1) {
						dis.responses[p]++;
					} else {
						dis.responses.push(theR.response);
					}
				} else {
					dis.responses = [];
					dis.responses.push(theR.response);

				}
				done = true;
			}

			if (theQ.kind_id == 11 && theR.status === 1 && !done) {
				for (var z = 0; z < theQ.choices.length; z++) {
					if (theR.response == theQ.choices[z]) {
						dis.responses[z]++;
						break;
					}
				}
				done = true;
			}

			if (theQ.kind_id == 2 && theR.status === 1 && !done) {
				for (var z = 0; z < theQ.choices.length; z++) {
					if (theR.response == theQ.choices[z]) {
						dis.responses[z]++;
						break;
					}
				}
				done = true;
			}
			if (theQ.kind_id == 6 && !done) {
				if (theR.score > 0 && theR.status === 1) {
					dis.responses[0]++;
					done = true;
				}
			} else {
				if (theQ.kind_id == 1) {
					if (theR.skipped
						&& (scoreQs[c].choices[theQ.choices.length - 1] !== 'Skipped')
						&& !isPool
						&& (minRecs === maxRecs)

					) {
						console.log('Skipped ' + theR.skipped + ' Status ' + theR.status);
						scoreQs[c].choices.push('Skipped');
						dis.responses.push(0);
					}
					if (!((pbs[theR.response]) === undefined || (pbs[theR.response]) === null) && !theR.skipped) {
						pbs[theR.response][r]++;
					}
					if (!theR.skipped && theR.status === 1) {
						dis.responses[theR.response]++;
					}
					if (theR.skipped && (scoreQs[c].choices[theQ.choices.length - 1] === 'Skipped')) {
						dis.responses[dis.responses.length - 1]++;
					}
				} else if (theQ.kind_id == 15) {
					if (!theR.skipped && theR.status === 1) {
						dis.responses[theR.response]++;
					}
				} else {
					if (theR.status === 1) {
						if (!done) {
							dis.responses[theR.response]++;
						}
					}
				}
			}


			var x = theR.score * theR.status;
			if ((theR.kind_id == 7 || theR.kind_id == 10 || theR.kind_id == 16)) {
				x = (x > .5) ? 1 : 0;
			}
			for (var f = 0, fl = theQ.categories.length; f < fl; f++) {
				theQ.categories[f].score += x;
				theQ.categories[f].scored = rows;
			}
			y = utot[theR.fbid] - x;
			if (minRecs === maxRecs) {// 9/19/2007
				xm.push(x);
				ym.push(y);
			} else if (!theR.skipped) {// 8/28/2017
				xm.push(x);
				ym.push(y);
			}
		}
		var pbCount = 0;
		for (var pb = 0; pb < pbs.length; pb++) {
			if (theQ.kind_id == 1) {
				ptb = Math.round($.corr_coeff(pbs[pb], stuTotal) * 1000) / 1000;
				if (!isNaN(ptb)) {
					pbCount++;
					dis.pb.push(ptb);
				} else {
					if (typeof ptb === 'undefined') {
						dis.pb.push('--');
					} else {
						dis.pb.push(0);
					}
				}
			} else {
				if (typeof pb === 'undefined') {
					dis.pb.push('--');
				} else {
					dis.pb.push('--');
				}
			}
		}
		if (theQ.kind_id == 1 && pbCount < 3) {
			dis.pb.length = 0;
		}

		distractors.push(dis);
		if (excluded.length > 0) {
			excluded[0].score[c] = (dem.score / dem.scored);
		}
		b = $.precision($.corr_coeff(xm, ym), 1e-2);
		xm = [];
		ym = [];
		if (isNaN(b)) {
			b = 0;
		}
		biserial[c] = b;
		scoreQs[c] = theQ;
	}
	return biserial;
}

function kr20(stuTotal, no_questions, scoretable, delQ) {
	if (!doKr) return $L.stat.na;
	var pos = no_questions;
	var stuTotals = new Array();
	var nn = stuTotal.length;
	doDel = (delQ > -1 && delQ < pos);
	var yys = [];
	for (var quest = 0, posl = pos; quest < posl; quest++) {
		var y = new Array(nn);
		yys.push(y);
	}
	var sds = [];
	var sumAlpha = 0;

	for (var quest = 0, posl = pos; quest < posl; quest++) {
		if (doDel && delQ == quest) continue;
		var t = [];
		for (var i = 0; i < stuTotal.length; i++) stuTotals[i] = stuTotal[i];
		for (var stu = 0; stu < nn; stu++) {
			if (doDel) {
				var dR = scoretable[delQ + (stu * pos)];
				stuTotals[stu] -= dR.score;
			}
			var anR = scoretable[quest + (stu * pos)];
			var thisScore = anR.score;
			yys[quest][stu] = thisScore;
			t.push(thisScore);
		}
		//console.log($.stdev(t) * $.stdev(t));
		sumAlpha += $.stdev(t) * $.stdev(t);
	}
	//console.log('smAlpha ' + sumAlpha);
	pp = pos;
	pp = (doDel) ? pp - 1 : pp;
	itemRatio = pp / (pp - 1);
	stddev = $.stdev(stuTotals);// * Math.sqrt(nn/(nn-1));
	k = Math.round(itemRatio * (1 - (sumAlpha / (stddev * stddev))) * 1000) / 1000;
	return k;
}

function calcDI(stuTotal, no_questions, scoretable, percentile) {
	di = new Array(no_questions);
	cp = percentile / 100;
	nRows = stuTotal.length;;
	nCount = Math.round(cp * nRows);
	sums = new Array(no_questions);
	for (j = 0; j < no_questions; j++) {
		sums[j] = 0;
	}
	for (i = 0; i < nCount; i++) {
		for (j = 0; j < no_questions; j++) {
			try {
				sums[j] += (scoretable[j + (i * no_questions)].score - scoretable[j + ((stuTotal.length - 1 - i) * no_questions)].score);
			} catch (e) {
				continue;
			}
		}
	}
	for (j = 0; j < no_questions; j++) {//
		di[j] = $.precision((sums[j] / nCount), 1e-2);
	}
	return di;
}

function get_type(thing) {
	if (thing === null) return "[object Null]"; // special case
	return Object.prototype.toString.call(thing);
}

function smIvyRow(ivyRowInfo) { // [rowHeader [,rowHeader]
	this.Course_id = '--';
	this.Cpk1 = '--';
	this.User_pk1 = '--';
	this.First_Name = '--';
	this.Last_Name = '--';
	this.User_email = '--';
	if (showDomains) {
		this.Node = '';
	}
	this.Usr_Batch_uid = '--';
	this.student_id = '--';
	this.Attempt_Date = '--';
	this.GM_Title = '--';
	this.GM_pk1 = '--';
	this.Title = '--';
	this.Question = '--';
	this.QPos = '--';
	this.Points = '--';
	this.Possible = 0.0;
	this.Correct = '--';
	this.Answer = '--';
	this.Correct_Ans = '--';
	this.QD_pk1 = '--';
	this.QR_pk1 = '--';
	this.Feedback = '--';
}

// smQIvyData
function GetStudentLandscape(rawScores) {
	var smIvyData = new Array();
	for (var p = 0; p < scoreQs.length; p++) {
		for (r = 0; r < md.length; r++) {
			var qq = 0;
			var theR = rawScores[p + (r * pos)];
			if (!(theR instanceof Mcr)) continue;
			var thisQ = Enumerable.from(scoreQs).where(function (x) {
				return x.pk1 == theR.qpk1;
			}).toArray()[0];
			var crs = Enumerable.from(crsData).where(function (x) {
				return x.cpk1 === theR.cpk1;
			}).select(function (x) {
				return {
					"crs_batch_uid": x.crs_batch_uid,
					"course": x.course,
					"assignment": x.assignment,
					"instructors": x.instructors,
					"user_id": x.user_id[0],
					"gmpk1": x.gmpk1,
					"batch_uid": x.batch_uid[0]
				}
			}).toArray()[0];
			var row = new smIvyRow();
			var cn = crs.course.split(" (")[0];
			var cid = crs.course.split(" (")[1];//.substring(0,
			cid = cid.substring(0, cid.length - 1);
			row.Course_id = cid;
			row.Cpk1 = theR.cpk1;
			row.User_pk1 = theR.upk1;// + ', ' + theR.firstname + ' ' + theR.mdate;
			row.First_Name = theR.firstname;
			row.Last_Name = theR.lastname;
			row.Usr_Batch_uid = theR.usr_batch_uid;
			row.student_id = theR.student_id;
			row.User_email = theR.email;
			if (showDomains) {
				row.Node = theR.program;
			}
			row.Attempt_Date = theR.mdate;
			row.GM_Title = ass.title;
			row.GM_pk1 = thisQ.gmpk1;
			let testRow = mainscope.itemAnalysis.grid.rowData.find(x => x.no == thisQ.position);
			let oldRow = row.Title=mainscope.itemAnalysis.grid.rowData[thisQ.position-1];
			if (testRow !== oldRow && isDebug()) console.log('problem fidning landscape row', testRow, oldRow);
			row.Title = testRow.title;
			row.Question = thisQ.q;
			row.QPos = thisQ.position;
			//  row.Points = $.precision(parseFloat(theR.points), 1e-2);
			if (isNaN(theR.points)) {
				theR.points = '--';
			} else {
				if (theR.points < 0) {
					row.Points = $.precision(parseFloat(theR.score * theR.max_score), 1e-2);
				} else {
					row.Points = $.precision(parseFloat(theR.points), 1e-2);
				}
			}
			row.Possible = $.precision(parseFloat(theR.max_score), 1e-2);//theR.max_score;
			if (isNaN(row.Possible)) {
				row.Possible = '--';
			}
			if (theR.kind_id == 7 || theR.kind_id == 10 || theR.kind_id == 16) {
				row.Correct = '';
			} else {
				if (theR.max_score <= EPSILON) row.Correct = (thisQ.choices[theR.response] == thisQ.correct) ? $L.correct_yes : $L.correct_no;
				else row.Correct = (theR.score > 0) ? $L.correct_yes : $L.correct_no;
			}
			var ans = '';
			switch (thisQ.QTAbbre) {
				case 'MC': { ans = thisQ.choices[theR.response]; break; }
				case 'ESS': { ans = 'ESS ' + $.precision(100 * theR.score, 1e-0) + '%'; break; }//$.precision(parseFloat(theR.max_score), 1e-1)
				case 'SR': {
					if (thisQ.title === 'Demographic' && typeof theR.choice_text !== 'undefined') {
						ans = 'D ' + theR.choice_text;
					} else {
						ans = 'SR ' + $.precision(100*theR.score, 1e-0) + '%';
					}
					break;
				}
				case 'TF': {
					if (thisQ.ultra_status === 'U' && theR.kind_id == 17) {
						ans = thisQ.choices[theR.response];
					}
					if (thisQ.ultra_status !== 'U' && theR.kind_id == 2) {
						ans = theR.response;
					}
					; break;
				}
				default: { ans = theR.response; break; }
			}
			if (theR.realAns) ans = theR.realAns;
			if (theR.surv.length > 0 && survey) {
				ans = theR.surv;
			}
			if (theR.kind_id == 15) {
				ans = thisQ.choices[theR.response];
			}
			if (theR.skipped) {
				ans = "--";
			}
			row.Answer = ans;
			if (theR.kind_id == 9) row.Correct_Ans = theR.Correct_Ans;
			else row.Correct_Ans = thisQ.correct;
			if (theR.kind_id == 13) {
				row.Correct = (row.Answer === row.Correct_Ans) ? 'Y' : 'N';
			}
			row.QD_pk1 = theR.qpk1;
			row.QR_pk1 = theR.pk1;
			// row.Elapsed = theR.elapsed
			//row.Feedback = thisQ.feedback;
			row.Feedback = theR.response_feedback ? theR.response_feedback : '';
			smIvyData.push(row);
		}
	}
	/*
	smIvyData.sort(function (a, b) {
		if (a.Course_id < b.Course_id) {
			return -1;
		}
		if (a.Course_id > b.Course_id) {
			return 1;
		}
		if (a.GM_Title < b.GM_Title) {
			return -1;
		}
		if (a.GM_Title > b.GM_Title) {
			return 1;
		}
		if (a.QPos < b.QPos) {
			return -1;
		}
		if (a.QPos > b.QPos) {
			return 1;
		}
		return 0;
	});
	*/
	return smIvyData;
}

function smIvyRowUtmb(ivyRowInfoUtmb) { // [rowHeader [,rowHeader]
	this.Course_id = '--';
	this.Attempt_Date = '--';
	this.First_Name = '--';
	this.Last_Name = '--';
	this.User_email = '--';
	this.GM_Title = '--';
	this.GM_pk1 = '--';
	this.Question = '--';
	this.QPos = '--';
	this.Correct = '--';
	this.Answer = '--';
	this.Correct_Ans = '--';
	this.Feedback = '--';
}

// smQIvyDataUtmb
function GetCoachingData() {
	let result = [];
	var smIvyData = new Array();
	for (var p = 0; p < scoreQs.length; p++) {
		for (r = 0; r < md.length; r++) {
			var qq = 0;
			var theR = rawScores[p + (r * pos)];
			if (theR.score > 0 || !(theR instanceof Mcr)) continue;
			var thisQ = Enumerable.from(scoreQs).where(function (x) {
				return x.pk1 == theR.qpk1;
			}).toArray()[0];
			var crs = Enumerable.from(crsData).where(function (x) {
				return x.cpk1 === theR.cpk1;
			}).select(function (x) {
				return {
					"crs_batch_uid": x.crs_batch_uid,
					"course": x.course,
					"assignment": x.assignment,
					"instructors": x.instructors,
					"user_id": x.user_id[0],
					"gmpk1": x.gmpk1,
					"batch_uid": x.batch_uid[0]
				}
			}).toArray()[0];
			var row = new smIvyRowUtmb();
			var cn = crs.course.split(" (")[0];
			var cid = crs.course.split(" (")[1];//.substring(0,
			cid = cid.substring(0, cid.length - 1);
			row.Course_id = cid;
			row.Attempt_Date = theR.mdate;
			row.First_Name = theR.firstname;
			row.Last_Name = theR.lastname;
			row.User_email = theR.email;
			row.Student_id = theR.student_id;
			row.GM_Title = ass.title;
			row.Question = thisQ.q;
			row.QPos = thisQ.position;
			//row.Title = mainscope.itemAnalysis.grid.rowData[row.QPos-1].title;
			let testRow = mainscope.itemAnalysis.grid.rowData.find(x => x.no == thisQ.position);
			let oldRow = row.Title=mainscope.itemAnalysis.grid.rowData[thisQ.position-1];
			if (testRow !== oldRow && isDebug()) console.log('problem fidning coaching row', testRow, oldRow);
			row.Title = testRow.title;
			//  row.Points = $.precision(parseFloat(theR.points), 1e-2);
			if (theR.kind_id == 7 || theR.kind_id == 10 || theR.kind_id == 16) {
				row.Correct = '';
			} else {
				row.Correct = (theR.score > 0) ? $L.correct_yes : $L.correct_no;
			}
			var ans = '';
			switch (thisQ.QTAbbre) {
				case 'MC': { ans = thisQ.choices[theR.response]; break; }
				case 'ESS': { ans = 'ESS ' + $.precision(100 * theR.score, 1e-0) + '%'; break; }//$.precision(parseFloat(theR.max_score), 1e-1)
				case 'SR': { ans = 'SR ' + $.precision(100 * theR.score, 1e-0) + '%'; break; }
				case 'TF': {
					if (thisQ.ultra_status === 'U' && theR.kind_id == 17) {
						ans = thisQ.choices[theR.response];
					}
					if (thisQ.ultra_status !== 'U' && theR.kind_id == 2) {
						ans = theR.response;
					}
					; break;
				}
				default: { ans = theR.response; break; }
			}
			row.Answer = ans;
			if (theR.kind_id == 9) row.Correct_Ans = theR.Correct_Ans;
			else row.Correct_Ans = thisQ.correct;
			// row.Elapsed = theR.elapsed
			row.Feedback = thisQ.feedback;
			smIvyData.push(row);
		}
	}
	smIvyData.sort(function (a, b) {
		if (a.Last_Name < b.Last_Name) return -1;
		if (a.First_Name > b.First_Name) return 1;
		if (a.GM_Title < b.GM_Title) return -1;
		if (a.GM_Title > b.GM_Title) return 1;
		if (a.QPos < b.QPos) return -1;
		if (a.QPos > b.QPos) return 1;
		return 0;
	});
	if (!survey) {
		var m = smIvyData;
		for (var i = 0; i < m.length; i++) {
			var arow = {};
			for (var n in m[i]) {
				if (m[i].hasOwnProperty(n)) {
					arow[n] = m[i][n];
				}
			}
			result.push(arow);
		}
	}
	return result;
}

function smRow() {
	this.Respondent = '';
	this.Attempt_Date = '';
	this.Total = 0;
	//  this.Peer_Avg = 0;
	this.Diff = 0;
	this.rowMcr = '';
	this.user_id = '';
	this.usr_batch_uid = '';
	this.student_id = '';
	this.usr_email = '';
	this.course_id = '';
	this.crs_batch_uid = '';
	this.Node = '';
	this.n = 0;
}

// smQData
function GetStudentQuestions(rawScores) {
	var smData = new Array();
	var avg = 0;
	var r = 0;
	var rlength = fbidsRaw.length;
	//   var process = function () {
	console.log('at process r = ' + r);
	for (; r < rlength; r++) {
		var rot = 0;
		var qsw = '';
		var rowR = [];
		var theR = rawScores[0 + (r * pos)];
		var row = new smRow();
		row.Respondent = theR.lastname + ', ' + theR.firstname;
		row.Attempt_Date = theR.mdate;
		row.usr_batch_uid = theR.usr_batch_uid;
		row.student_id = theR.student_id;
		row.usr_email = theR.email;
		row.crs_batch_uid = Enumerable.from(crsData).where(function (x) {
			return x.cpk1 === theR.cpk1;
		}).select(function (x) {
			return { "crs_batch_uid": x.crs_batch_uid }
		}).toArray()[0].crs_batch_uid;
		var p = 0;
		for (p = 0; p < pos; p++) {
			theR = rawScores[p + (r * pos)];
			row.rowMcr += ':::' + theR.response;
			if (theR.status === 1) {
				row[smcolHeaders[p + 5]] = $.precision(theR.score, 1e-2);
				if (theR.score === 0) {
					qsw += "," + (p + 1);
				}
			} else {
				row[smcolHeaders[p + 5]] = "--";
			}
			rot += theR.score;
		}
		row.rowMcr = row.rowMcr.substring(3);
		avg += rot;
		row[smcolHeaders[p + 5]] = qsw.substring(1);
		// row[smcolHeaders[p + 5]] = rowR;
		row.Total = rot;
		row.n = r + 1;
		row.Node = theR.program;
		smData.push(row);
	}
	avg = avg / fbidsRaw.length;//md.length;
	for (r = 0; r < fbidsRaw.length; r++) {
		smData[r]["Peer Avg"] = $.precision(avg, 1e-2);
		smData[r]["Diff"] = $.precision(smData[r]["Total"] - avg, 1e-2);
		smData[r]["Total"] = $.precision(smData[r]["Total"], 1e-2);
		avgt += smData[r]["Total"];
	}
	avgt /= fbidsRaw.length;
	smData.sort(function (a, b) {
		var comp = 0;
		if (a.Total > b.Total) {
			comp = -1;
		} else {
			if (b.Total > a.Total) {
				comp = 1;
			}
		}
		return comp;
	});
	var m = smData;
	//smQs.clearGridData(false);
	let data = Array(fbidsRaw.length);
	for (var i = 0, mdl = fbidsRaw.length; i < mdl; i++) {
		var arow = {};
		for (var n in m[i]) {
			if (m[i].hasOwnProperty(n)) {
				arow[n] = m[i][n];
			}
		}
		data[i] = arow;
		data[i]['row_id'] = i;
	}
	return data;
}

function makeMyGridDataS() {
	myGridDataS = new Array();
	var avg = 0;
	for (var r = 0, mdl = md.length; r < mdl; r++) {
		var theR = rawScores[0 + (r * pos)];
		if (theR !== undefined) {
			var name = theR.lastname + ', ' + theR.firstname;
		}
		souts = souts.sort(function (a, b) {
			return (a.cat < b.cat) ? -1 : (a.cat > b.cat) ? 1 : 0;
		});
		var row = new myGridDataSRow(name, souts, r, theR);
		myGridDataS.push(row);// $.parseJSON(obj);
	}
	return myGridDataS;
}

function myGridDataSRow(name, souts, r, theR) {
	var o = new Object();
	o["Respondent"] = name;
	o["rowMcr"] = '';
	o["usr_batch_uid"] = theR.usr_batch_uid;
	o["student_id"] = theR.student_id;
	o["usr_email"] = theR.email;
	o["crs_batch_uid"] = Enumerable.from(crsData).where(function (x) {
		return x.cpk1 === theR.cpk1;
	}).select(function (x) {
		return { "crs_batch_uid": x.crs_batch_uid }
	}).toArray()[0].crs_batch_uid;
	var sout;
	var avg = 0;
	var count = 0;
	var tot = 0;
	for (var p = 0, soutsl = souts.length; p < soutsl; p++) {
		if (souts[p].scored <= 0) {
			continue;
		}
		avg = 0;
		count = 0;
		tot = 0;
		sout = souts[p];
		for (var x = 0, soutl = sout.Qs.length; x < soutl; x++) {
			pp = (sout.Qs[x]);
			if ((pp + (r * pos)) <= rawScores.length) {
				theR = rawScores[pp + (r * pos)];
				if (typeof theR === 'undefined') {
					continue;
				}
				if (theR.status > 0) {
					// avg += (theR.score / sout.Qs.length);
					tot += theR.score;
					count += 1;
				}
			}
		}
		if (count > 0) {
			avg = tot / count;
			o[sout.cat] = $.precision(avg, 1e-2);
		} else {
			o[sout.cat] = "--";
		}
		o["rowMcr"] += ':::' + o[sout.cat];
	}
	o["rowMcr"] = o["rowMcr"].substring(3);
	return o;
}

function nameValue(name, value) {
	this.name = name;
	this.value = value;
}

function Disrow() {
	this.Correct = '';
	this.No = '';
	this.QT = '';
	this.Question = '';
	this.Responses = '';
	this.cnos = '';
}

function aSkip(r, c) {
	this.row = r;
	this.col = c;
}

getRData = function (myData, kind_id, aQ) {
	var theData = '';
	if (myData.charAt(0) === '\\') {
		theData = mcr(hex2a(myData.substring(2)), kind_id);
	} else {
		if (myData.charAt(0) !== 'P') {
			theData = mcr(hex2a(myData), kind_id);
		} else {
			theData = mcr(Base64Decode(myData), kind_id);
		}
	}
	return theData;
}

function mcq(xmlString, kind_id) {
	var xml = getXml(xmlString);
	var feedback = '';
	var fbs = xml.getElementsByTagName('itemfeedback');
	for (var fb = 0; fb < fbs.length; fb++) {
		if (fbs[fb].hasAttribute("ident") && fbs[fb].getAttribute("ident") === "correct") {
			feedback = fbs[fb].textContent;
		}
	}
	if (kind_id == 9) {
		let answerIdents = xml.getElementsByTagName('answer');
		for (let ai of answerIdents) calculatedFormulaAnswers[ai.parentElement.attributes[0].value] = ai.innerHTML;
	}
	var assType = null;
	try {
		assType = xml.getElementsByTagName('bbmd_assessmenttype')[0].textContent;
	} catch (e) {
		console.log(e.message + ' on ' + kind_id);
	}
	// console.log(assType + ' ' + kind_id);
	var ft = '';
	var ftNode = xml.getElementsByTagName('mat_formattedtext')[0];
	try { ft = ftNode.textContent; }
	catch (e) {
		console.log(xmlString);
	}
	var bft = xml.getElementsByTagName('mat_formattedtext')[0].textContent;
	var pattern = 'href=".+"';
	var r = new RegExp(pattern);
	var rr = r.exec(bft);
	if (rr !== null) {
		bft = rr[0];
	}
	ans = '';
	wrong = '';
	a = 0;
	title = '';
	s = 't||';
	title = (xml.getElementsByTagName('item')[0].hasAttribute('title')) ? xml.getElementsByTagName('item')[0].getAttribute('title') : title;
	s += title.replace(/\*+$/, '');
	s += '***';
	s += 'q||' + TAG(ft).trim() + '***';
	if (!(kind_id == 15 || kind_id == 17 || kind_id == 3 || kind_id == 5 || kind_id == 4 || kind_id == 6 || kind_id == 8 || kind_id == 7 || kind_id == 10 || kind_id == 16 || kind_id == 12 || kind_id == 13)) {
		var resp = xml.getElementsByTagName('respcondition');
		for (var i = 0, il = resp.length; i < il; i++) {
			if (resp[i].getAttribute('title') === "correct") {
				ans = resp[i].getElementsByTagName('conditionvar')[0].textContent;
			}
		}
		var rls = xml.getElementsByTagName('response_label'); //.each(function () {
		for (var i = 0, il = rls.length; i < il; i++) {
			var thisChoice = TAG(rls[i].textContent).replace(/_/g, '-').trim();
			if (thisChoice != null && thisChoice.length > 0) {
				if (rls[i].getAttribute('ident') === ans) {
					s += 'rc_' + (a++) + '_' + thisChoice + '__';
				} else {
					s += 'r_' + (a++) + '_' + thisChoice + '__';
				}
			} else {
				if (rls[i].getAttribute('ident') === ans) {
					s += 'rc_' + (a++) + '_' + (i + 1) + '__';
				} else {
					s += 'r_' + (a++) + '_' + (i + 1) + '__';
				}


			}
		}
	}
	if (kind_id == 17) {
		var resp = xml.getElementsByTagName('respcondition');
		for (var i = 0, il = resp.length; i < il; i++) {
			if (resp[i].getAttribute('title') === "correct") {
				ans = resp[i].getElementsByTagName('conditionvar')[0].textContent;
			}
		}
		var rls = xml.getElementsByTagName('response_label'); //.each(function () {
		for (var i = 0, il = rls.length; i < il; i++) {
			var raw = (rls[i].textContent).split('.');
			if (rls[i].getAttribute('ident') === ans) {
				s += 'rc_' + (a++) + '_' + ((ans.indexOf('.false') > -1) ? raw[0].split('_')[1] : raw[0].split('_')[0]) + '__';
			} else {
				s += 'r_' + (a++) + '_' + ((ans.indexOf('.false') > -1) ? raw[0].split('_')[0] : raw[0].split('_')[1]) + '__';
			}
		}
	}
	if (kind_id == 15) {
		var choices = [];
		var rls = xml.getElementsByTagName('response_label'); //.each(function () {
		for (var i = 0, il = rls.length; i < il; i++) {
			choices.push(TAG(rls[i].textContent));
		}
		s += choices.join(':::');
	}
	if (kind_id == 3) {
		var yes = [];
		var no = [];
		if (assType !== "Survey") {
			var ans = xml.getElementsByTagName('conditionvar')[0];
			var ands = ans.getElementsByTagName('and');
			for (var i = 0, il = ands.length; i < il; i++) {
				var ys = ands[i].getElementsByTagName('varequal');
				for (var j = 0, jl = ys.length; j < jl; j++) {
					var nos = (ys[j].parentNode.tagName.toLowerCase() === 'not');
					if (!nos) {
						yes.push("rc_" + j);
					} else {
						yes.push("r_" + j);
					}
				}
			}
		}
		var rls = xml.getElementsByTagName('response_label'); //.each(function () {
		for (var i = 0, il = rls.length; i < il; i++) {
			var raw = (rls[i].textContent).split('.');
			ll = rls[i].getAttribute('ident');
			if (ll.length < 32 && ll.split('_').length > 1) {
				lls = ll.split('_');
				p = parseInt(lls[1]);
				p--;
				ll = lls[0] + '_' + p;

			}
			var chocieText = TAG(rls[i].textContent.replace(/_/g, " "));
			if (chocieText === null || chocieText.length === 0) {
				s += yes[i] + '_' + (i + 1) + '__';
			} else {
				s += yes[i] + '_' + chocieText + '__';
			}
		}
	}
	if (kind_id == 5) {
		s += '';
		var eq = '';
		var lident = '';
		var eqs = xml.getElementsByTagName('varequal');
		for (var j = 0, jl = eqs.length; j < jl; j++) {
			eq += "," + eqs[j].getAttribute("respident") + "::" + eqs[j].textContent;
		}
		eq = eq.substring(1);
		rChoice = '';
		var rChoices = [];
		var flows = xml.getElementsByTagName("flow");
		for (var j = 0, jl = flows.length; j < jl; j++) {
			if (flows[j].getAttribute('class') === 'RIGHT_MATCH_BLOCK') {
				var mt = flows[j].getElementsByTagName("mat_formattedtext");
				for (var k = 0, kl = mt.length; k < kl; k++) {
					tmp = TAG(mt[k].textContent).trim();
					rChoices.push(tmp);

				}
			}
			if (flows[j].getAttribute('class') === 'RESPONSE_BLOCK') {
				var choice = [];
				var identChoice = '';
				var fbs = flows[j].getElementsByTagName("flow");
				for (var f = 0, fl = fbs.length; f < fl; f++) {
					if (fbs[f].getAttribute('class') === "Block") {
						identChoice += '__' + fbs[f].getElementsByTagName('response_lid')[0].getAttribute('ident') + '::';
						var rb = fbs[f].getElementsByTagName('response_label');
						for (var g = 0; g < rb.length; g++) {
							if (g === 0) {
								identChoice += rb[g].getAttribute("ident");
							} else {
								identChoice += ',' + rb[g].getAttribute("ident");
							}
						}
						choice.push(TAG(fbs[f].getElementsByTagName("mat_formattedtext")[0].textContent));
					}
				}
			}
		}
		var theIdents = identChoice.substring(2).split('__');
		var responses = [];
		for (var w = 0; w < choice.length; w++) {
			var rids = theIdents[w].split('::')[1].split(',');
			var p = rids.indexOf(eqs[w].textContent);
			responses.push(choice[w] + "::" + rChoices[p]);
		}
		s += '||correct==' + responses.join('$$$');
		s += '||identChoice==' + theIdents.join('$$$');
		s += '||choice==' + choice.join('$$$');
		// console.log('||identChoice==' + '');
		s += '||rchoices==' + rChoices.join(':::');
	}


	if (kind_id == 12) {

		var correct = '';
		var vrs = xml.getElementsByTagName('varequal');
		var corr = [];
		for (v = 0; v < vrs.length; v++) {
			corr.push(vrs[v].getAttribute('respident') + '=' + vrs[v].textContent);
		}
		s += '||correct==' + corr.join('::');
	}
	if (kind_id == 13) {
		var lids = xml.getElementsByTagName("response_lid");
		var vrs = xml.getElementsByTagName('varequal');
		var corr = [];
		for (v = 0; v < vrs.length; v++) {

			var lid = Enumerable.from(lids).where(function (x) {
				return x.getAttribute('ident') == vrs[v].getAttribute('respident');
			}).toArray()[0];
			if (typeof lid === 'undefined') {
				continue;
			}
			var alid = lid.getElementsByTagName('response_label');
			for (var i = 0; i < alid.length; i++) {
				if (alid[i].getAttribute('ident') == vrs[v].textContent) {
					corr.push(vrs[v].getAttribute('respident') + '=' + vrs[v].textContent + '**' + alid[i].textContent);
				}
			}
		}
		if (corr.length > 9) {
			corr.sort(function (a, b) {
				var p = a.indexOf('=');
				var q = b.indexOf('=');
				if (parseInt(a.substring(1, p)) < parseInt(b.substring(1, q))) {
					return -1;
				}
				if (parseInt(a.substring(1, p)) > parseInt(b.substring(1, q))) {
					return 1;
				}
				return 0;
			})
		}
		var correct = '';
		var flows = xml.getElementsByTagName("flow");
		for (var j = 0, jl = flows.length; j < jl; j++) {
			if (flows[j].getAttribute('class') === 'RESPONSE_BLOCK') {
				var bigChoice = [];
				var majorChoice = [];
				var choice = [];
				var idents = [];
				var identChoice = [];
				var lids = flows[j].getElementsByTagName("response_lid");
				for (var f = 0, fl = lids.length; f < fl; f++) {
					majorChoice.push(lids[f].getAttribute('ident'));
					var rls = lids[f].getElementsByTagName("response_label");
					for (var rl = 0; rl < rls.length; rl++) {
						identChoice.push(rls[rl].getAttribute('ident'));
						idents.push(majorChoice[f] + '_' + rls[rl].getAttribute('ident'));
						choice.push(rls[rl].textContent);
					}
					bigChoice.push(majorChoice[f] + '_' + identChoice.join('*') + '_' + choice.join('*'));

				}
			}
		}
		var ps = [];
		var vars = xml.getElementsByTagName("varequal");
		for (var i = 0; i < vars.length; i++) {
			var lookup = vars[i].textContent;
			var p = identChoice.lastIndexOf(lookup);
			var correct = majorChoice[i] + '=' + choice[p];
			ps.push(correct);
		}
		s += '||choice==' + bigChoice.join('$$$');
		s += '||correct==' + corr.join('::');
		s += '||idents==' + idents.join('$$$');
	}
	if (kind_id == 4) {
		var order = [];
		var resp = xml.getElementsByTagName('respcondition');
		for (var j = 0, jl = resp.length; j < jl; j++) {
			if (resp[j].getAttribute('title') === "correct") {
				var c = resp[j].getElementsByTagName('and');
				for (var o = 0, ol = c.length; o < ol; o++) {
					var r = c[o].childNodes;
					for (k = 0, kl = r.length; k < kl; k++) {
						order.push(r[k].textContent); // resps in correct order
					}
				}
			}
		}
		a = 0;
		var corrs = [order.length];
		var rl = xml.getElementsByTagName('response_label');
		for (var j = 0, jl = rl.length; j < jl; j++) {
			var ll = rl[j].getAttribute('ident');
			var p = order.indexOf(ll);
			corrs[p] = TAG(rl[j].textContent);
			s += 'r_'+a+'_'+$.inArray(ll, order)+'_'+TAG(rl[j].textContent)+'__';
			a++;
		}
		s += "||correct==" + corrs.join(',');
	}
	if (kind_id == 6) {
		var list = xml.getElementsByTagName('varequal');
		var ans = [];
		var cs = '';
		s += "rc_0_";
		for (var i = 0; i < list.length; i++) {
			ans.push(TAG(xml.getElementsByTagName('varequal')[i].textContent));
			cs = xml.getElementsByTagName('varequal')[i].getAttribute('case');
		}
		s += ans.join(" or ");
		s += "***";
		var setvar = "EXACT";
		if (ans.length > 1) {
			setvar = "CONTAINS";
		}
		var setvars = xml.getElementsByTagName('setvar');
		for (var i = 0; i < setvars.length; i++) {
			if (setvars[i].hasAttribute("variablename") && setvars[i].getAttribute("variablename") === "EvaluationType") {
				setvar = setvars[i].textContent;
			}
		}

		s += setvar + "||" + cs;
	}
	if (kind_id == 8) {
		var list = xml.getElementsByTagName('varequal');
		var ans = [];
		var cs = '';
		s += "rc_0_";
		for (var i = 0; i < list.length; i++) {
			ans.push(TAG(xml.getElementsByTagName('varequal')[i].textContent));
			cs = xml.getElementsByTagName('varequal')[i].getAttribute('case');
		}
		s += ans.join("||");
		s += "***";
		var setvar = "EXACT";
		if (ans.length > 1) {
			setvar = "CONTAINS";
		}
		var setvars = xml.getElementsByTagName('setvar');
		for (var i = 0; i < setvars.length; i++) {
			if (setvars[i].hasAttribute("variablename") && setvars[i].getAttribute("variablename") === "EvaluationType") {
				setvar = setvars[i].textContent;
			}
		}
		s += setvar + "||" + cs;
	}
	s += '***';
	var mmax = xml.getElementsByTagName('decvar')[0].getAttribute('maxvalue');
	if (typeof mmax === 'undefined') {
		s += "maxvalue=0";// + $($(xml).find('decvar')).first().attr('maxvalue');
	} else {
		s += "maxvalue=" + mmax;
	}
	s += '***';
	s += "feedback=" + feedback;
	s += "***";
	s += 'checkQ=' + bft;
	return s;
}

function mcr(xmlString, kind_id) {// <?xml version="1.0" encoding="UTF-8"?>
	var xml = getXml(xmlString);
	var rvNode = xml.getElementsByTagName("response_value")[0];
	var rvNodes = xml.getElementsByTagName("response_value");
	var rv = '';
	let response_feedback = '';
	if (rvNode !== undefined) {
		rv = rvNode.textContent;
	}
	if (!(kind_id == 17 || kind_id == 2 || kind_id == 3 || kind_id == 4 || kind_id == 12 || kind_id == 13)) {
		s = 'r_' + TAG(rv) + '***';
	}
	if (kind_id == 17) {
		var raw = rv;
		if (raw === null || raw.length === 0) {
			s = 'r_' + '***';
		} else {
			var raw1 = raw.split('.');
			s = 'r_' + ((raw1[1].indexOf('false') > -1) ? '1' : '0') + '***';
		}
	}
	if (kind_id == 2) {
		var raw = rv;
		if (raw.split('.').length > 1) {
			s = 'r_' + ((raw.indexOf('.false') > -1) ? '1' : '0') + '***';
		}
		else {
			s = 'r_' + ((raw.indexOf('false') > -1) ? '1' : '0') + '***';
		}
	}
	if (kind_id == 3) {
		s = '';
		for (var i = 0, il = rvNodes.length; i < il; i++) {
			s += 'r_' + ((rvNodes[i].textContent.indexOf('false') > -1) ? '0' : '1') + '_';
		}
		s += '***';

	}
	if (kind_id == 9) {
		let cvs = xml.getElementsByTagName("calculated_variable_set")[0];
		let cva = calculatedFormulaAnswers[cvs.innerHTML];
		let cvr = rvNode.innerHTML.replace(/:::_/g, '');
		s = (cvr ? cvr : '--') + '***' + cva + '***';
	}
	if (kind_id == 5) {
		s = '';
		var ident_refs = [];
		var resvs = [];
		var responses = xml.getElementsByTagName("response");
		for (var r = 0, rl = responses.length; r < rl; r++) {
			ident_refs.push(responses[r].getAttribute("ident_ref"));
		}
		for (var i = 0, il = rvNodes.length; i < il; i++) {
			resvs.push(rvNodes[i].textContent);
		}
		for (var r = 0, rl = responses.length; r < rl; r++) {
			s += "," + ident_refs[r] + '::' + resvs[r];
		}
		s = s.substring(1);
		// s += ans;
		s += '***';
		var answer_order = xml.getElementsByTagName("answer_order")[0];
		s += "filler" + '***';
	}
	if (kind_id == 4) {
		s = '';
		var raw = $(rvNodes);
		raw.each(function (i, el) {
			s += 'r_' + $(el).text() + '_';
		});
		s += '***';

	}
	if (kind_id == 12) {
		s = '';
		var r = '';
		var resps = xml.getElementsByTagName("response");
		for (var i = 0; i < resps.length; i++) {
			r += '::' + resps[i].getAttribute('ident_ref') + '=' + resps[i].textContent;
		}
		r = r.substring(2, r.length);
		s += r;
		s += '***';

	}
	var scores = xml.getElementsByTagName("score");
	if (kind_id == 7 || kind_id == 10 || kind_id == 16) {
		let manual_score = '';
		let auto_maximum = '';
		
		for (var t = 0, tl = scores.length; t < tl; t++) {
			if (scores[t].hasAttribute('varname')) {
				if (scores[t].getAttribute('varname') === "MANUALGRADE") {
					try {
						let score_value = scores[t].getElementsByTagName("score_value")[0].textContent;
						// Only use manual score if it has a value
						if (score_value !== '') {
							manual_score = 's_' + score_value;
						}
					} catch (e) {
						console.log('in qr.data - manual score ' + e.message);
					}
				}
				if (scores[t].getAttribute('varname') === "AUTOGRADE") {
					try {
						let score_value = scores[t].getElementsByTagName("score_value")[0].textContent;
						let score_maximum = scores[t].getElementsByTagName("score_maximum")[0].textContent;
						
						// If no manual score was found, use auto score
						if (manual_score === '') {
							if (score_value === '' && score_maximum !== '') {
								manual_score = 's_' + score_maximum;
							} else if (score_value !== '') {
								manual_score = 's_' + score_value;
							}
						}
						
						// Always get the maximum for the suffix
						if (score_maximum !== '') {
							auto_maximum = '_' + score_maximum;
						}
					} catch (e) {
						console.log('in qr.data - auto score ' + e.message);
						if (manual_score === '') {
							manual_score = 's_10';
						}
						auto_maximum = '_10';
					}
					break;
				}
			}
		}
		
		// If we still don't have a score, use default
		if (manual_score === '') {
			manual_score = 's_10';
		}
		if (auto_maximum === '') {
			auto_maximum = '_10';
		}
		
		s += manual_score + auto_maximum;
		let feedback_query = xml.querySelectorAll("extension_item_result feedback");
		if (feedback_query[0]) response_feedback = TAG(feedback_query[0].textContent);
	} else {

		for (var t = 0, tl = scores.length; t < tl; t++) {
			if (scores[t].hasAttribute('varname')) {
				if (scores[t].getAttribute('varname') === "AUTOGRADE") {
					let score_value = scores[t].getElementsByTagName("score_value")[0].textContent;
					let score_maximum = scores[t].getElementsByTagName("score_maximum")[0].textContent;
					if (score_value === '' && score_maximum !== '') s += 's_' + score_maximum;
					else s += 's_' + score_value;
					// <score_maximum>1.0</score_maximum>
					try {
						s += '_' + scores[t].getElementsByTagName("score_maximum")[0].textContent;
					} catch (e) {
						s += '_10';
					}
					break;
				}
			}
		}
	}
	if (kind_id == 13) {
		s = '';

		var responses = [];
		var resps = xml.getElementsByTagName("response");
		for (var i = 0; i < resps.length; i++) {
			responses.push(resps[i].getAttribute('ident_ref') + '=' + resps[i].textContent);

		}
		s += responses.join('_');
		s += '***';
		for (var t = 0, tl = scores.length; t < tl; t++) {
			if (scores[t].hasAttribute('varname')) {
				if (scores[t].getAttribute('varname') === "AUTOGRADE") {
					let score_value = scores[t].getElementsByTagName("score_value")[0].textContent;
					let score_maximum = scores[t].getElementsByTagName("score_maximum")[0].textContent;
					if (score_value === '' && score_maximum !== '') s += 's_' + score_maximum;
					else s += 's_' + score_value;
				}
				if (scores[t].getAttribute('varname') === "AUTOGRADE") {
					s += '_' + scores[t].getElementsByTagName("score_maximum")[0].textContent;
					break;
				}
			}
		}
	}
	if (response_feedback.length > 0) s += '***' + response_feedback;
	return s;
}

function isNotScoreable(kind_id) {
	return false;
}
