page = 'goal'; // \b(?!goal)\w+Overview
var n_ready = false, errData = null, appHome = false, WO = window.opener, settings = WO.settings, TSIZE = 8.64e15;
var MS, PS = WO.mainscope, $L = WO.$L, uid = WO.uid, dbtype = WO.dbtype, bburl = WO.bburl, token = WO.token;
var outs = rfdc()(PS.showOutcomes), selected = rfdc()(PS.nOutcomes.selected), tpk1s = rfdc()(PS.termPk1s), n_title = 0;
var date_to = new Date(PS.date_to), date_from = new Date(PS.date_from), mode = new ModeData(WO.modeData), target = 0.6;
var from = getSqlDate(date_from), to = getSqlDate(date_to), maxt = new Date(-TSIZE), mint = new Date(TSIZE);
var params = { $0$:from, $1$:to, $2$:tpk1s, $3$:mode.filter, '@uid':uid, '--@I':mode.itoken, '--@E':mode.etoken, '--@A':mode.atoken };
var dateRange = (a, b, sep = '-', f = 'toLocaleDateString') => `${a[f]()} ${sep} ${b[f]()}`, username = WO.username;
var data = { raw:[], progs:{}, p1:{}, overview:[], roadmap:{} }, metaAvg = 0, dates = '', sessionHash = WO.sessionHash;
var crits = { assessment:{ key:'gmpk1', label:'gm_title', alt:'rname', data:{} },
  course:{ key:'cpk1', label:'course_id', alt:'course_name', data:{} }, goal:{ key:'gpk1', label:'goal', data:{} },
  rubric:{ key:'rpk1', label:'rname', data:{} }, term:{ key:'tpk1', label:'term', data:{} },
  type:{ key:'type', label:'type', data:{} }, user:{ key:'user_pk1', label:'uname_lf', data:{} } };

document.title = LangArg($L.g_title, selected.length, dateRange(date_from, date_to));
data.loa = storedObject.get('scale') || $L.g_scale.default;
// check if a equals or includes b if a is an array
var equalsOrIn = (a, b) => _.isArray(a) ? a.includes(b) : a == b;
// determine if criterion data is falsy
var isFalsy = val => val === undefined || val === null || val === '' || (_.isArray(val) && val.every(x => x === ''));

window.onerror = function (message, source, lineno, colno, error) {
  errData = { message, source, lineno, colno, error, bburl, uid, page:location.pathname, subject:'EAC Error',
    datemin:Date2MDY(date_from), datemax:Date2MDY(date_to), goals:selected.map(x => x.label) };
  console.log(errData);
  MS.err.show = true;
  MS.loading = false;
  send(errData);
};

// calculate level metadata
function updateLevels(enabled = false) {
  let filter = 'agTextColumnFilter', len = enabled ? data.loa.length : 0, perc = data.loa.map(x => x.dec*100);
  let base = { cellClass:['cell-vertical-align-text-left'], filter, filterParams:{ caseSensitive:false } };
  data.loam = { keys:[], cols:[], stack:[], pie:[], colDefs:[], update:[], perc, enabled, len };
  data.loam.colors = chroma.scale(['#c83232', '#32c832']).mode('lrgb').colors(data.loa.length);
  for (let i = 0; i < data.loam.len; i++) {
    data.loam.cols.push((i+1)+'_'+toTitleCase(data.loa[i].name));
    data.loam.pie.push('lNum'+i);
    data.loam.keys.push('lCell'+i);
    data.loam.stack.push('lpNum'+i);
    data.loam.update.push('lCell'+i, 'lNum'+i, 'lpNum'+i, 'lMet'+i, 'lpMet'+i);
    data.loam.colDefs.push({ ...base, field:data.loam.keys[i], headerName:data.loam.cols[i] });
  }
}
updateLevels();

// set grid & title & resize
function setGrid(grid, model, title, resize = true) {
  // Ensure grid is initialized before updating
  if (!grid || !grid.grid) {
    console.warn('setGrid: grid not initialized yet');
    return;
  }
  grid.AddModel(model);
  if (resize && grid.grid.api) grid.AutoSize();
  if (title == undefined) return;
  grid.title = title;
  grid.sheetHeader = title;
}

// fix xlsx download if columns change
function fixSheetKeys(ag) {
  // In ag-grid v34, columnApi methods are merged into api
  const allColumns = ag.grid.api ? ag.grid.api.getColumns() : [];
  let cols = allColumns.map(x => x.getColDef());
  Object.assign(ag, { sheet:cols.map(x => x.field), sheetNames:cols.map(x => x.headerName), pdfkeys:cols });
}

// sort object array by array of keys
function SortKeyAry(ary, keys) {
	var sorts = keys.map(x=>{
		if (_.isFunction(x)) return {key:x, order:1};
		else if (x[0] === '-') return {key:y=>y[x.substr(1)], order:-1};
		return {key:y=>y[x], order:1};
	});
	ary.sort((a,b) => {
		let cpr;
		for (let sort of sorts) {
			let na = Number(sort.key(a)), nb = Number(sort.key(b));
			let sa = sort.key(a).toString(), sb = sort.key(b).toString();
			if (isNaN(na)||isNaN(nb)) cpr = sa.localeCompare(sb)*sort.order;
			else cpr = (na - nb)*sort.order;
			if (cpr != 0) return cpr;
		}
		return cpr;
	});
	return ary;
}

// get levels from student data
function makeLevelCols(row, userData) {
  if (!data.loam.enabled) return;
  let users = Object.keys(userData).length, ldec = key => users ? $.precision(row[key]/users, 1e-2) : '--';
  data.loa.forEach((x, i) => Object.assign(row, { ['lMet'+i]:0, ['lNum'+i]:0 }));
  for (let id in userData)
    for (let avg = $S.mean(userData[id]), i = data.loa.length - 1, highest = true; i >= 0; --i)
      if (avg >= data.loa[i].dec && ++row['lMet'+i] && highest && ++row['lNum'+i]) highest = false;
  let ldsp = i => ({ ['lCell'+i]:users ? `${row['lNum'+i]} (${$.precision(100*row['lNum'+i]/users, 0.1)}%)` : '--' });
  data.loa.forEach((x, i) => Object.assign(row, { ['lpMet'+i]:ldec('lMet'+i), ['lpNum'+i]:ldec('lNum'+i) }, ldsp(i)));
}

// Get all combinations from array of choice-arrays
function getCombinations(arrays) {
  const indices = new Array(arrays.length).fill(0), result = [];
  while (true) {
    let curr = [], j = arrays.length - 1;
    for (let i = 0; i < arrays.length; i++) curr.push(arrays[i][indices[i]]);
    result.push(curr);
    while (j >= 0 && indices[j] === arrays[j].length - 1) indices[j--] = 0;
    if (j < 0) break;
    indices[j]++;
  }
  return result;
}

class Item {
  constructor(match = () => true, group = [], sort = [], src = data.raw) {
    Object.assign(this,{match,group,sort,src,showChart:false,showGrid:true,maxt:new Date(-TSIZE),mint:new Date(TSIZE)});
    this.initialKeys = ['avg', 'rawMet', 'rawUnmet', 'met', 'unmet', 'users', 'scored'];
    this.extraKeys = ['course_name', 'department', 'item', 'ndate', 'program'];
    for (let crit in crits) this.extraKeys.push(crits[crit].label);
    this.process();
  }

  process() {
    Object.assign(this, { totalAvg:0, totalNum:0, totalMet:0, totalUsers:0 });
    let groups = {}, students = {};
    this.src.forEach((x, i) => {
      // determine which grouping combos the raw-score belongs to
      if (!this.match(x) || isNaN(x.goalscore) || x.goalscore < 0 || x.goalscore > 1) return;
      let comboData = [[{empty:true, dspKey:'i'+i, dspVal:'Index '+i, name:'index'}]];
      if (_.isArray(this.group) && this.group.length) {
        comboData = this.group.map(g => {
          if (!g.key) return [{empty:true, dspKey:'i'+i, dspVal:'Index '+i, name:'index'}];
          let rowKeys = x[g.key], rowVal = x[g.label];
          if (!_.isArray(rowKeys)) rowKeys = [rowKeys];
          return rowKeys.map(key => { // setup combo group from criterion values
            let data = {key:g.key, label:g.label, name:g.name, val:key, falsy:isFalsy(x[g.key])};
            data.dspKey = key; //data.falsy ? 'No-' + g.label : key;
            data.dspVal = data.falsy ? $L.g_crit['no_'+g.name] : rowVal;
            if (_.isArray(data.dspVal)) data.dspVal = data.dspVal[rowKeys.indexOf(key)];
            return data;
          });
        });
      }
      let combos = getCombinations(comboData);

      // tabulate each raw-score for each grouping combo it belongs to
      for (let combo of combos) {
        let hash = combo.map(c => c.dspKey).join('_');
        if(!groups[hash]) { // create group if doesn't exist
          groups[hash] = { userScores:{}, key:hash, gpk1:x.gpk1, gpk1s:[x.gpk1] };
          for (let key of this.initialKeys) groups[hash][key] = 0;
          groups[hash].filters = combo.map(c => ({ key:c.key, val:c.val }));
          groups[hash].label = combo.map(c => c.dspVal).join('; ');
          groups[hash].check = !combo.some(c => c.empty);
          for (let key of this.extraKeys) groups[hash][key] = x[key];
        } else if (!groups[hash].gpk1s.includes(x.gpk1)) { // add goal to group if needed
          groups[hash].gpk1s.push(x.gpk1);
          groups[hash].goal += '; ' + x.goal;
        }
        // count score for user-stats and general-stats
        if (!groups[hash].userScores[x.user_pk1]) groups[hash].userScores[x.user_pk1] = [x.goalscore];
        else groups[hash].userScores[x.user_pk1].push(x.goalscore);
        if (x.goalscore >= target) groups[hash].rawMet++;
        else groups[hash].rawUnmet++;
        groups[hash].avg += x.goalscore;
        this.totalAvg += x.goalscore;
        groups[hash].scored++;
        this.totalNum++;
      }

      // global stats
      if (x.ndate > this.maxt) this.maxt = x.ndate;
      if (x.ndate < this.mint) this.mint = x.ndate;
      if (!students[x.user_pk1]) students[x.user_pk1] = [x.goalscore];
      else students[x.user_pk1].push(x.goalscore);
    });

    // finish calculating user-stats
    for (let group in groups) {
      let users = groups[group].userScores;
      for (let user in users) {
        groups[group].users++;
        if ($S.mean(users[user]) >= target) groups[group].met++;
        else groups[group].unmet++;
      }
      makeLevelCols(groups[group], users);
    }
    for (let student in students) {
      this.totalUsers++;
      if ($S.mean(students[student]) >= target) this.totalMet++;
    }

    // reassign global stats to each row
    this.totalAvg = $.precision(this.totalAvg / this.totalNum, 1e-2);
    this.totalMet = $.precision(this.totalMet / this.totalUsers, 1e-2);
    this.data = Object.values(groups);
    for (let x of this.data) {
      x.avg = $.precision(x.avg / x.scored, 1e-2);
      x.pMet = $.precision(x.met / x.users, 1e-2);
      x.pUnmet = $.precision(x.unmet / x.users, 1e-2);
      x.avgMet = x.avg < target ? $L.g_target.no : $L.g_target.yes;
      Object.assign(x, { target, tavg:this.totalAvg, tmet:this.totalMet, tnum:this.totalNum });
    }

    // sort
    if (this.sort.length) SortKeyAry(this.data, this.sort);
  }
}

class RoadMapItem {
  constructor(item) {
    Object.assign(this,{title:item.gm_title,rname:item.rname,type:item.type,date:item.ndate,course_id:item.course_id});
    for (let x of ['scored','avg','met','pMet','unmet','pUnmet','problem','target','users','tavg']) this[x] = 0;
  }
}

async function getGoalsData() {
  // initial queries
  let counter = 0, vals = Object.values(crits), users = crits.user.data, proms = [], queries = [
    'e3a288a0-3b80-467c-b109-635f2775648d',	// Test Questions
    'e81f2aec-f801-4e9c-8e9b-5a7e45763b66',	// Normal Rubric Rows
    '39b86975-792f-4bfe-b7e2-e5f46f3a9756',	// Group Rubric Rows
    '2d774b05-dfe7-4726-b8f8-a2bbf4169044',	// Delegated Rubric Rows
    '3f0e18fd-de06-4d14-88fe-2f5a30f2aa0d',	// Delegated-Group Rubric Rows 
    '2ac60428-e400-476d-acfa-6b8ba1667611',	// Grade Center Columns
    'ab3a89b7-4ec1-4d34-94a6-5de5609e5936'  // Discussion Forums
  ];
  if (outs) queries.push('115e21f5-42a3-43f4-b803-96b96e2378d5'); // Outcomes Rubric Rows
  for (let goal of selected) {
    let gpk1 = goal.data.clppk1, param = Object.assign(rfdc()(params), { '@gpk1':gpk1 });
    data.p1[gpk1] = [];
    proms.push(SQLCallback(counter++, 0, param, queries, ary => {
      data.p1[gpk1] = data.p1[gpk1].concat(ary);
      data.raw = data.raw.concat(ary);
    }));
    while (parseProgress.sent - parseProgress.ret > 5) await Timer(500);
  }
  await Promise.all(proms);
  // identify criterions
  for (let row of data.raw) {
    row.type = SetDefault($L.h_item_type[row.type], row.type); /// #L
    for (let crit of vals) {
      let data = { [crit.label]:row[crit.label] };
      if (crit.alt) data[crit.alt] = row[crit.alt];
      crit.data[row[crit.key]] = data;
    }
  }

  // user data queries
  let userChunks = arrayChunk(Object.keys(users), 100).map(x => ({'$0$':x.join()}) );
  let makeName = x => ({ uname_fl:`${x.ufirstname} ${x.ulastname}`, uname_lf:`${x.ulastname}, ${x.ufirstname}` });
  await Promise.all([
    SQLChunk(false, false, counter++, 0,'4f549211-4908-4138-b19d-179f7cc13abd', {}, userChunks, ary => {
      for (let row of ary) Object.assign(users[row.user_pk1], row, makeName(row));
    }),
    SQLChunk(false, false, counter++, 0,'302c0903-390e-472b-b25f-494148618b7c', {}, userChunks, ary => {
      for (let row of ary) {
        if (!users[row.user_pk1]) users[row.user_pk1] = { programs:[], program_pk1s:[] };
        else if (!users[row.user_pk1].programs) Object.assign(users[row.user_pk1], { programs:[], program_pk1s:[] });
        data.progs[row.program_pk1] = { program:row.program };
        users[row.user_pk1].programs.push(row.program);
        users[row.user_pk1].program_pk1s.push(row.program_pk1);
      }
    })
  ]);
  // finish joining data
  for (let user of Object.values(users)) user.program = user.programs ? user.programs.join('; ') : '';
  let noprogs = _.pick(crits.user.data, val => val.program_pk1s === undefined);
  if (!_.isEmpty(noprogs)) {
    data.progs[''] = { program:$L.g_crit.no_program };
    _.each(noprogs, val => Object.assign(val, { program_pk1s:[''], programs:data.progs[''] }));
  }
  if (crits.term.data[''] !== undefined) crits.term.data[''].term = $L.g_crit.no_term;
  crits.program = { key:'program_pk1s', label:'programs', data:data.progs };
  for (let crit in crits) Object.assign(crits[crit], { name:crit, Name:$L.g_crit[crit], Names:$L.g_crit[crit+'s'] });
  for (let row of data.raw) {
    Object.assign(row, users[row.user_pk1]);
    row.goalscore = $.precision(parseFloat(row.goalscore), 1e-2);
    row.ndate = new Date(row.ndate);
    if (!row.course_id) row.course_id = '--';
  }
  
  // static processing
  parseProgress.reset(true);
  staticProcessing();
  
  // Raw Downloads
  MS.rawGoals = new GridBox({ mode:'rawGoals', title:'Raw Goal Data',
    keys:['goal', 'term', 'course_id', 'course_name', 'gm_title', 'rname', 'item', 'type', 'ulastname', 'ufirstname',
      'uemail', 'goalscore', 'ndate', 'program'],
    headers:['Goal', 'Term', 'Course_ID', 'Course_Name', 'Grade_Center', 'Rubric_Name', 'Item', 'Type', 'Last_Name',
      'First_Name', 'Email', 'Score', 'Date', 'Programs'],
    model:SortObjAry(data.raw, 'goal', 'term', 'course_id', 'type', 'uemail'),
  });
  data.progMatrix = Object.values(crits.user.data).map(user => {
    let row = { uemail:user.uemail || `[${user.uname_lf}]` };
    for (let prog of user.program_pk1s) row[prog] = data.progs[prog].program;
    return row;
  });
  let progData = SortObjAry(_.pairs(data.progs).map(pair => ({ pk1:pair[0], name:pair[1].program })), 'name');
  MS.progMatrix = new GridBox({ mode:'progMatrix', title:'Program Matrix',
    keys:['uemail', ...progData.map(prog => prog.pk1)],
    headers:['Email', ...progData.map(prog => prog.name)],
    model:SortObjAry(data.progMatrix, 'uemail')
  });

  n_ready = true;
}
getGoalsData();

function staticProcessing() {
  // clean state
  data.overview = [];
  data.roadmap = {};
  metaAvg = 0;
  MS.metaScored = 0;

  // process data by goal
  for (let goal of selected) {
    let overview = { scored:0, avg:0, users:0, met:0, unmet:0, problem:0, target:target }, gdata = goal.data;
    let roadmapGoal = {}, rmStudents = {}, studentScores = {}, clppk1 = gdata.clppk1, cdata = crits.goal.data;
    let goalData = SortObjAry(data.p1[clppk1],'course_id','gm_title','uemail');

    for (let item of goalData) {
      // validate rawscore data
      if (studentScores[item.user_pk1] === undefined) studentScores[item.user_pk1] = [];
      item.goalscore = $.precision(parseFloat(item.goalscore), 1e-2);
      item.ndate = new Date(item.ndate);
      item.type = SetDefault($L.h_item_type[item.type], item.type); /// #L
      if (item.ndate > maxt) maxt = item.ndate;
      if (item.ndate < mint) mint = item.ndate;
      if (!item.course_id) item.course_id = '--';
      // calculate stats
      let hash = item.cpk1+'_'+item.gmpk1;
      if (roadmapGoal[hash] === undefined) {
        roadmapGoal[hash] = new RoadMapItem(item);
        rmStudents[hash] = {};
      }
      else if (item.ndate > roadmapGoal[hash].date) roadmapGoal[hash].date = item.ndate;
      if (item.goalscore >= 0 && item.goalscore <= 1) {
        overview.scored++;
        overview.avg += item.goalscore;
        roadmapGoal[hash].scored++;
        roadmapGoal[hash].avg += item.goalscore;
        studentScores[item.user_pk1].push(item.goalscore);
        if (!rmStudents[hash][item.user_pk1]) rmStudents[hash][item.user_pk1] = [item.goalscore];
        else rmStudents[hash][item.user_pk1].push(item.goalscore);
      } else {
        roadmapGoal[hash].problem++;
        overview.problem++;
      }
    }

    // finish averages
    for (upk1 in studentScores) {
      if ($S.mean(studentScores[upk1]) >= target) overview.met++;
      else overview.unmet++;
      overview.users++;
    }
    overview.pMet = overview.users > 0 ? $.precision(overview.met / overview.users, 1e-2) : '--';
    overview.pUnmet = overview.users > 0 ? $.precision(overview.unmet / overview.users, 1e-2) : '--';
    metaAvg += overview.avg;
    MS.metaScored += overview.scored;
    overview.avg = overview.scored > 0 ? $.precision(overview.avg / overview.scored, 1e-2) : '--';
    makeLevelCols(overview, studentScores);

    // finish roadmap student stats
    for (let hash in roadmapGoal) {
      let curMap = roadmapGoal[hash];
      for (let user in rmStudents[hash]) {
        if ($S.mean(rmStudents[hash][user]) >= target) roadmapGoal[hash].met++;
        else curMap.unmet++;
        curMap.users++;
      }
      curMap.target = target;
      curMap.tavg = overview.avg;
      curMap.pMet = (curMap.users > 0) ? $.precision(curMap.met / curMap.users, 1e-2) : '--';
      curMap.pUnmet = (curMap.users > 0) ? $.precision(curMap.unmet / curMap.users, 1e-2) : '--';
      curMap.avg = (curMap.scored > 0) ? $.precision(curMap.avg / curMap.scored, 1e-2) : '--';
      makeLevelCols(curMap, rmStudents[hash]);
    }

    // assign row data
    if (cdata[clppk1]) Object.assign(cdata[clppk1], { scored:overview.scored, title:gdata.title });
    else cdata[clppk1] = { goal:gdata.unique_id, scored:0, title:gdata.title };
    data.overview.push(Object.assign(overview, { goal:goal.label, desc:gdata.desc, gpk1:clppk1 }));
    data.roadmap[clppk1] = Object.values(roadmapGoal);
  }

  // assign global data
  if (MS.metaScored > 0) metaAvg = $.precision(metaAvg / MS.metaScored, 1e-2);
  else {
    metaAvg = null;
    MS.loading = false;
    alert($L.h_student_goals._empty);
    setTimeout(window.close, 9);
  }
  data.overview.forEach(row => row.tavg = metaAvg);
}

// Angular App Definition
var mainscope, app = angular.module('App', ['ngMaterial', 'ngMessages', 'ngRoute', 'ngSanitize', 'ngAnimate'])
  .controller('Ctrl', function ($scope, $window, $element, $interval, $timeout, $mdDialog, $anchorScroll) {
    MS = $scope;
    mainscope = MS;
    Object.assign($scope, { $L, LangArg, data, loading:true, spt:'', metaScored:0, title:document.title, crits:crits,
      map:{ available:[], curr:crits.assessment, loa:true }, err:{ show:false, comment:true, text:'', send:sendErr },
      goals:selected, assessments:[], courses:[], programs:[], users:[], terms:[], types:[], goalDesc:'', courseName:'',
      loa:{ show:false, fly:false, data:data.loa, meta:data.loam, num:data.loa.length, prev:data.loa.length }, rname:'',
      showUnscored:true, target:target, popnav:true, autonav:true, pivot:{}, zone:0, targetColor:'gray', drops:{},
      warning:{ show:false, msg:$L.msg.error, ok:false, dismiss:false, close:false }, trunc:x => elipses(x, 24),
      stopProp:$event => { $event.stopPropagation() }, hint:(crit, hint) => crit.length ? '' : hint });
    var ags = ['goalOverview','outMap','goalsByAssessment','goalsByCourse','goalsByProgram','goalsByTerm','goalsByType'];
    $scope.SideNav = (state) => { Object.assign(MS, { popnav:state, autonav:false }) };

    function sendErr() {
      errData.comment = $scope.err.text;
      console.log(errData);
      send(errData);
      $scope.err.comment = false;
      $scope.err.text = "";
    };
    $scope.Warn = function(msg, dissmissable) {
      $scope.warning.msg = msg;
      $scope.warning.dismiss = dissmissable;
      $scope.warning.show = true;
    }

    // scroll
    let anchors = [0, 'goal', 'assessment', 'course', 'program', 'student', 'term', 'type'];
    angular.element(document.querySelector('#report')).bind('scroll', (event) => {
      let pos = event.target.scrollTop, height = window.innerHeight / 4, zone = 0;
      for (let i = 1; i < anchors.length; i++) {
        let offset = _.isNumber(anchors[i]) ? anchors[i] : document.getElementById(anchors[i])?.offsetTop;
        if (offset === undefined) continue;
        if (pos > offset - height) zone = i;
        else break;
      }
      if ($scope.zone == zone) return;
      $scope.zone = zone;
      if ($scope.$apply) $scope.$apply();
    });
    $scope.scrollTo = function(target) {
      let box = document.getElementById('report');
      if (typeof target === 'number') box.scrollTo({ top:target, behavior:'smooth' });
      else document.getElementById(target).scrollIntoView({ block:'start', behavior:'smooth' });
    };

    // Custom Scale
    $scope.applyLevel = () => {
      let show=MS.loa.show, toggle=show!=data.loam.enabled, doLevel=toggle||show, rm=!toggle&&show ? MS.loa.prev : 0;
      data.loa.sort((a, b) => a.dec - b.dec);
      updateLevels(MS.loa.show);
      staticProcessing();
      if (!data.overview.length || !data.roadmap[MS.drops.xbg].length) return;

      updateGrid(MS.goalOverview.grid, data.overview, data.loam.update);
      if (MS.map.loa) updateGrid(MS.outMap.grid, getGoalData(), data.loam.update);
      updateTabs(data.loam.update);
      $scope.updateGridsLoa(rm);
      storedObject.set('scale', data.loa);

      $timeout(() => {
        $scope.updateGraphs(doLevel, rm);
        MS.loa.prev = data.loa.length;
      }, 0);
    }
    $scope.closeLevel = () => {
      $scope.loa.fly = false;
      $scope.applyLevel();
    };
    $scope.addLevel = (num) => {
      let diff = data.loa.length - num;
      if (num < data.loa.length) data.loa.splice(data.loa.length - diff, diff);
      else if (num > data.loa.length) {
        for (let i = data.loa.length; i < num; i++) {
          let prev = i > 0 ? data.loa[i-1].dec : 0, dec = (prev + 1) / 2;
          data.loa.push({ dec:$.precision(dec, 1e-2), name:LangArg($L.g_scale.level_name, i+1) });
        }
      }
    };
    $scope.onToggleLoa = (state) => {
      if (state == data.loam.enabled) return;
      updateLevels(state);
      if (state) updateTabs(targetCols.concat(data.loam.update));
      MS.onUpdate(true);
      MS.updateGridsLoa();
      $timeout(MS.updateGraphs, 0, true, true);
    };
    $scope.openLoa = () => {
      $scope.loa.fly = true;
      if ($scope.loa.used) return;
      $scope.loa.used = true;
      $scope.loa.show = true;
      $scope.loa.toggle = true;
    }

    function initTab(crit, value, byCrit, defaultValue) {
      if (!Object.keys(crit.data).length) return;
      if (!MS.drops[value]) MS.drops[value] = defaultValue;
      setGrid(byCrit, (new Item(x => equalsOrIn(x[crit.key], MS.drops[value]), [crits.goal], byCrit.sort)).data);
      byCrit.sheetHeader = `${$L.g_for_crit[crit.name]}: ${crit.data[MS.drops[value]][crit.label]}`;
    }

    $scope.initGrids = function() {
      dates = ` (${dateRange(mint, maxt)})`;
      setGrid(MS.goalOverview, data.overview, $L.h_goal_overview.title + dates);
      $scope.goalOverview.grid.api.getRowNode(data.overview.findIndex(x => x.scored)).setSelected(true);
      if (!MS.drops.xbg) MS.drops.xbg = MS.goalOverview.grid.rowData.find(x => x.scored).gpk1;
      if (MS.drops.xbg) MS.goalDesc = crits.goal.data[MS.drops.xbg].title;
      
      setGrid(MS.outMap, data.roadmap[MS.drops.xbg]);
      fixSheetKeys(MS.outMap);
      initTab(crits.assessment, 'gba', MS.goalsByAssessment, MS.assessments[0].gmpk1);
      initTab(crits.course, 'gbc', MS.goalsByCourse, MS.courses[0].cpk1);
      initTab(crits.program, 'gbp', MS.goalsByProgram, MS.programs[0].ppk1);
      initTab(crits.user, 'gbu', MS.goalsByUser, MS.users[0].user_pk1);
      initTab(crits.term, 'gbt', MS.goalsByTerm, MS.terms[0].tpk1);
      initTab(crits.type, 'gby', MS.goalsByType, MS.types[0].type);
      if (MS.drops.gbc) MS.courseName = crits.course.data[MS.drops.gbc].course_name;
      if (MS.drops.gba) MS.rname = crits.assessment.data[MS.drops.gba].rname;
    }

    // convert criterion to array of objects
    function mapCrit(crit, overrides, sort) {
      let args = Object.assign({ key:crit.key, search:[crit.label] }, overrides);
      let r = _.map(crit.data, (v, k) => ({ [args.key]:k, ...v, search:args.search.map(prop => v[prop]).join('\n') }));
      if (r.length) MS.map.available.push(crit);
      return sort ? SortKeyAry(r, sort) : r;
    }

    $scope.initGraphs = function() {
      if ($scope.goalOverview.grid.rowData.length == 0) return;
      makeGraphs('goalOverview', 'overviewGraph', $L.g_overview.goals, false, 'overviewMetGraph', $L.g_overview.met);
      [MS.gbaChange, MS.gbcChange, MS.gbpChange, MS.gbuChange, MS.gbtChange, MS.gbyChange].forEach(x => x());
      $timeout($scope.stopLoading, 0);
    };

    $scope.stopLoading = () => {
      $scope.loading = false;
      function apply() {
        if (MS.overviewGraph?.chart?.ctx) MS.$apply();
        else $timeout(apply, 99);
      }
      $timeout(apply, 99);
    };

    $scope.OnReady = function() {
      if (!n_ready) return $timeout($scope.OnReady, 50);
      if (MS.metaScored == 0) return;

      $scope.assessments = mapCrit(crits.assessment, { search:['gm_title', 'rname'] });
      $scope.courses = mapCrit(crits.course, { search:['course_id', 'course_name'] });
      $scope.programs = mapCrit(crits.program, { key:'ppk1' }, ['program']);
      $scope.users = mapCrit(crits.user, { search:['ubatch_id','uuid','uemail','uname_fl','uname_lf'] }, ['uname_lf']);
      $scope.terms = mapCrit(crits.term);
      $scope.types = mapCrit(crits.type);
      $scope.initGrids();
      if ($scope.$apply) $scope.$apply();
      $timeout($scope.initGraphs, 0);
    };
    $scope.OnReady();

    // Change Criterion
    function getGoalData(gpk1 = MS.drops.xbg) {
      if (MS.map.curr == crits.assessment) return data.roadmap[gpk1];
      return (new Item(x => x.gpk1 == gpk1, [MS.map.curr], MS.outMap.sort)).data;
    }
    function makeStudentPie() {
      let cfg = MS.mapMetGraph.chart.config, row = data.overview.filter(x => x.gpk1 == MS.drops.xbg)[0], ds = {};
      cfg.options.plugins = { title:{ display:!0, text:`${$L.g_met.goal}: ${crits.goal.data[MS.drops.xbg].goal}` } };
      cfg.data.labels = data.loam.enabled ? data.loam.cols : [$L.g_target.notmet, $L.g_target.met];
      if (!data.loam.enabled) ds = { data:[row.unmet, row.met], backgroundColor:['#c8323280', '#32c83280'] };
      else ds = { data:data.loam.pie.map(x => row[x]), backgroundColor:data.loam.colors.map(x => x+'80') };

      if (cfg.type != 'pie') {
        cfg.type = 'pie';
        cfg.options.scales = {};
        cfg.data.datasets = [ds];
      } else Object.assign(cfg.data.datasets[0], ds);
      $('#'+MS.mapMetGraph.pid).height(400);
      MS.mapMetGraph.chart.update();
    }
    $scope.onUpdate = (skipGraphs) => {
      let colDefs = MS.outMap.grid.columnDefs, c = comKeys.concat(data.loam.keys), k = ['label'].concat(c);
      if (!n_ready || !Object.keys(MS.map.curr.data).length) return;
      let keys = { assessment:['title', 'rname', 'type', 'date', 'course_id'].concat(c), term:k, type:k, program:k,
        course:['course_id', 'course_name'].concat(c), user:['label', 'scored', 'avg', 'tavg', 'target', 'avgMet'] };

      MS.mapGraph.filename = $L.g_for_goal[MS.map.curr.name].replaceAll(' ', '');
      MS.outMap.sheetHeader = `${MS.map.curr.Names} ${$L.g_for_goal._}: ${crits.goal.data[MS.drops.xbg].goal}`;
      MS.outMap.sheetTitle = `${MS.map.curr.Names} ${$L.g_for_goal._}`;
      colDefs[6].headerName = MS.map.curr.Name;
      colDefs.forEach(x => x.hide = !keys[MS.map.curr.name].includes(x.field));
      if (MS.outMap.grid.api) {
        if (typeof MS.outMap.grid.api.setGridOption === 'function') {
          MS.outMap.grid.api.setGridOption('columnDefs', colDefs);
        } else if (typeof MS.outMap.grid.api.setColumnDefs === 'function') {
          MS.outMap.grid.api.setColumnDefs(colDefs);
        }
      }
      MS.outMap.grid.columnDefs = colDefs;
      fixSheetKeys(MS.outMap);

      if (MS.map.curr == crits.assessment) setGrid(MS.outMap, data.roadmap[MS.drops.xbg]);
      else setGrid(MS.outMap, (new Item(x => x.gpk1 == MS.drops.xbg, [MS.map.curr], MS.outMap.sort)).data);
      if (skipGraphs) return;
      if (MS.map.curr == crits.user) $timeout(makeStudentPie, 0);
      $timeout(goalCallback, 0);
      Object.assign(MS.map, { prev:MS.map.curr, loa:MS.map.curr!=crits.user });
    };

    function selectEvent(callback, overview, val, key = 'key') {
      return (event) => {
        let rows = event.api.getSelectedRows();
        if (rows.length > 0) MS[callback](rows[0][key]);
        else event.api.getRowNode(MS[overview].grid.rowData.findIndex(x => x[key]==MS.drops[val])).setSelected(true);
      }
    }
    $scope.overviewGetSelect = selectEvent('xbgChange', 'goalOverview', 'xbg', 'gpk1');

    $scope.xbgChange = (gpk1, enabled=true) => {
      if (!enabled) return;
      $scope.drops.xbg = gpk1;
      MS.goalOverview.grid.api.getRowNode(MS.goalOverview.grid.rowData.findIndex(x => x.gpk1==gpk1)).setSelected(true);
      if (!gpk1) $scope.goalDesc = '';
      else $scope.goalDesc = crits.goal.data[gpk1].title;
      
      let sel = crits.goal.data[gpk1].goal, lcrit = $L.g_for_goal[MS.map.curr.name], isS = MS.map.curr == crits.user;
      setGrid($scope.outMap, getGoalData(gpk1));
      $scope.outMap.sheetHeader = `${lcrit}: ${sel}`;
      if (isS) _.compose(makeStudentPie, makeGraphs)('outMap', 'mapGraph', [lcrit, ''], sel);
      else makeGraphs('outMap', 'mapGraph', [lcrit, ''], sel, 'mapMetGraph', $L.g_met.goal);
    };

    $scope.isScored = (g, o = crits.goal.data) => g && o[g.data.clppk1] ? o[g.data.clppk1].scored : false;
    $scope.filterScored = (goal) => $scope.showUnscored || $scope.isScored(goal);
    $scope.gbxChange = (grid, key, value, crit) => {
      if (value !== undefined) {
        $scope.drops[key] = value;
        setGrid(grid, (new Item(x => equalsOrIn(x[crit.key], value), [crits.goal])).data);
      } else value = $scope.drops[key];
      let critValue = crit.data[value] || crit.data[''], selection = critValue[crit.label] || critValue[crit.name];
      grid.sheetHeader = `${$L.g_for_crit[crit.name]}: ${selection}`;
      return { perc:$L.g_for_crit[crit.name], met:$L.g_met[crit.name], sel:selection, value };
    };
    $scope.gbaChange = (gmpk1) => {
      let header = $scope.gbxChange($scope.goalsByAssessment, 'gba', gmpk1, crits.assessment);
      $scope.rname = header.value ? crits.assessment.data[header.value].rname : '';
      makeGraphs('goalsByAssessment', 'gbaGraph', header.perc, header.sel, 'gbaMetGraph', header.met);
    };
    $scope.gbcChange = (cpk1) => {
      let header = $scope.gbxChange($scope.goalsByCourse, 'gbc', cpk1, crits.course);
      $scope.courseName = header.value ? crits.course.data[header.value].course_name : '';
      makeGraphs('goalsByCourse', 'gbcGraph', header.perc, header.sel, 'gbcMetGraph', header.met);
    };
    $scope.gbpChange = (ppk1) => {
      let header = $scope.gbxChange($scope.goalsByProgram, 'gbp', ppk1, crits.program);
      makeGraphs('goalsByProgram', 'gbpGraph', header.perc, header.sel, 'gbpMetGraph', header.met);
    };
    $scope.gbuChange = (upk1) => {
      let header = $scope.gbxChange($scope.goalsByUser, 'gbu', upk1, crits.user);
      makeGraphs('goalsByUser', 'gbuGraph', header.perc, header.sel);
    };
    $scope.gbtChange = (tpk1) => {
      let header = $scope.gbxChange($scope.goalsByTerm, 'gbt', tpk1, crits.term);
      makeGraphs('goalsByTerm', 'gbtGraph', header.perc, header.sel, 'gbtMetGraph', header.met);
    };
    $scope.gbyChange = (type) => {
      let header = $scope.gbxChange($scope.goalsByType, 'gby', type, crits.type);
      makeGraphs('goalsByType', 'gbyGraph', header.perc, header.sel, 'gbyMetGraph', header.met);
    };

    $scope.updateGridLoa = (ag = MS.outMap, old = 0) => {
      if (!ag?.grid?.api) return;
      let cds = ag.grid.columnDefs, rm = data.loam.enabled ? old : data.loa.length, gs = ag==MS.outMap && !MS.map.loa;
      if (rm) cds.splice(cds.length - rm, rm);
      if (data.loam.enabled) cds = cds.concat(data.loam.colDefs.map(x => ({ ...x, hide:gs })));
      if (typeof ag.grid.api.setGridOption === 'function') {
        ag.grid.api.setGridOption('columnDefs', cds);
      } else if (typeof ag.grid.api.setColumnDefs === 'function') {
        ag.grid.api.setColumnDefs(cds);
      }
      ag.grid.columnDefs = cds;
      fixSheetKeys(ag);
    };
    $scope.updateGridsLoa = (old = 0) => {
      ags.forEach(ag => MS.updateGridLoa(MS[ag], old));
    };

    // target
    const targetCols = ['target', 'pMet', 'met', 'unmet', 'avgMet'];
    function updateGrid(grid, newData, keys = targetCols) {
      // Update rowData in place to preserve scroll position
      grid.rowData.forEach((x, i) => { for (let key of keys) x[key] = newData[i][key]; });
      // Use setGridOption to update data while preserving scroll position
      if (grid.api) {
        if (typeof grid.api.setGridOption === 'function') {
          grid.api.setGridOption('rowData', grid.rowData);
        } else {
          // Fallback: refresh cells if setGridOption not available
          grid.api.refreshCells();
        }
      }
    }

    function updateTab(crit, value, byCrit, cols = targetCols) {
      if (!Object.keys(crit.data).length || !byCrit.grid.api) return;
      let bcData = (new Item(x => equalsOrIn(x[crit.key], MS.drops[value]), [crits.goal], byCrit.sort)).data;
      updateGrid(byCrit.grid, bcData, cols);
    }
    function updateTabs(cols) {
      updateTab(crits.assessment, 'gba', MS.goalsByAssessment, cols);
      updateTab(crits.course, 'gbc', MS.goalsByCourse, cols);
      updateTab(crits.program, 'gbp', MS.goalsByProgram, cols);
      updateTab(crits.user, 'gbu', MS.goalsByUser, cols);
      updateTab(crits.term, 'gbt', MS.goalsByTerm, cols);
      updateTab(crits.type, 'gby', MS.goalsByType, cols);
    }

    $scope.targetCallback = () => {
      staticProcessing();
      if (!data.overview.length || !data.roadmap[MS.drops.xbg].length) return;
      updateGrid(MS.goalOverview.grid, data.overview);
      updateGrid(MS.outMap.grid, getGoalData());
      updateTabs();
      $timeout($scope.updateGraphs, 0);
    };
    $scope.debouncedTargetCallback = _.debounce($scope.targetCallback, 250);

    $scope.onTargetChange = (value) => {
      target = value;
      $scope.target = value;
      $scope.debouncedTargetCallback();
    };

    var barConfig = (c1, c2, o) => ({ type:'bar', borderWidth:1, borderColor:c1, backgroundColor:c2, ...o });
    var comKeys = ['scored', 'avg', 'tavg', 'users', 'target', 'pMet', 'met', 'unmet'], comTypes = 'iffiffii';
    var comCols = $L.g_cols.common, uKeys = ['scored', 'avg', 'tavg', 'target', 'avgMet'], uTypes = 'iffff';
    Object.assign(MS.map, { clen:comTypes.length, srm:comTypes.length-uTypes.length });
    let loak = data.loam.keys, crsCols = [$L.g_cols.course[1], crits.assessment.Name], amet = ['avgMet'];
    let commonGrid = { model:[], auto:true, autoIfNeeded:true, stypes:'s'+comTypes, cacheDownload:false,
      keys:['goal'].concat(comKeys, loak), headers:[$L.g_crit.goal].concat(comCols, data.loam.cols) };
    let studentGrid = { model:[], auto:true, autoIfNeeded:true, stypes:'s'+uTypes, cacheDownload:false,
      keys:['goal'].concat(uKeys), headers:[$L.g_crit.goal].concat($L.g_cols.user) };

    function sortCallback(src, perc, name, met) {
      var p = () => $L.g_for_crit[name], f = () => makeGraphs(src, perc, p(), true, met, $L.g_met[name]);
      return { onSortChanged:f, onFilterChanged:f };
    }
    function goalCallback() {
      if (MS.map.curr == crits.user) makeGraphs('outMap', 'mapGraph', [$L.g_for_goal[MS.map.curr.name], ''], true);
      else makeGraphs('outMap', 'mapGraph', [$L.g_for_goal[MS.map.curr.name], ''], true, 'mapMetGraph', $L.g_met.goal);
    }

    // overview
    $scope.goalOverview = new GridBox({ mode:'goalOverview', title:$L.h_goal_overview.title, model:[],
      sheetTitle:$L.h_goal_overview.title,
      keys:['goal', 'desc'].concat(comKeys, loak),
      headers:$L.g_cols.goalOverview.concat(comCols, data.loam.cols),
      auto:['goal'].concat(comKeys, loak),
      props:{ rowSelection:'single', suppressRowClickSelection:true,
        onSelectionChanged:MS.overviewGetSelect, isRowSelectable:rowNode=>rowNode.data.scored,
        ...sortCallback('goalOverview', 'overviewGraph', 'overview', 'overviewMetGraph')  },
      colProps:[[0],{checkboxSelection:true, cellClassRules:{'ag-no-check':'data.scored == 0'}}, [1],{minWidth:200}],
      stypes:'ss'+comTypes, /*headerTooltip: 'This is a tooltip'*/
      cacheDownload:false
    });

    // goal
    $scope.outMap = new GridBox({ mode:'goalMap', title:'', sheetTitle:$L.g_for_goal.assessment, model:[],
      keys:['title', 'rname', 'type', 'date', 'course_id', 'course_name', 'label'].concat(comKeys, amet, loak),
      headers:$L.g_cols.assessment.concat(crsCols, comCols, $L.g_cols.user.slice(4), data.loam.cols),
      auto:['type','date','course_id','scored','avg','tavg'],
      autoIfNeeded:true,
      stypes:'sssusss'+comTypes+'s',
      colProps:[[3], { cellRenderer:x => Date2MDY(x.value) }, [5, 6, 15], { hide: true }],
      props:{ onSortChanged:goalCallback, onFilterChanged:goalCallback, applyColumnDefOrder:true },
      cacheDownload:false
    });

    // Common Grids
    $scope.goalsByAssessment = new GridBox({ ...commonGrid, mode:'goalsByAssessment', title:$L.g_for_crit.assessment,
      props:{ ...sortCallback('goalsByAssessment', 'gbaGraph', 'assessment', 'gbaMetGraph') } });
    $scope.goalsByCourse = new GridBox({ ...commonGrid, mode:'goalsByCourse', title:$L.g_for_crit.course,
      props:{ ...sortCallback('goalsByCourse', 'gbcGraph', 'course', 'gbcMetGraph') } });
    $scope.goalsByProgram = new GridBox({ ...commonGrid, mode:'goalsByProgram', title:$L.g_for_crit.program,
      props:{ ...sortCallback('goalsByProgram', 'gbpGraph', 'program', 'gbpMetGraph') } });
    $scope.goalsByUser = new GridBox({ ...studentGrid, mode:'goalsByUser', title:$L.g_for_crit.user,
      props:{ ...sortCallback('goalsByUser', 'gbuGraph', 'student') } });
    $scope.goalsByTerm = new GridBox({ ...commonGrid, mode:'goalsByTerm', title:$L.g_for_crit.term,
      props:{ ...sortCallback('goalsByTerm', 'gbtGraph', 'term', 'gbtMetGraph') } });
    $scope.goalsByType = new GridBox({ ...commonGrid, mode:'goalsByType', title:$L.g_for_crit.type,
      props:{ ...sortCallback('goalsByType', 'gbyGraph', 'type', 'gbyMetGraph') } });

    function updateUserGraph(usr, doLevel, rm) {
      if (!usr) return;
      let d = usr.chart.config.data, ds = d.datasets, target100 = target * 100, loam = data.loam, color = loam.colors;
      ds[0].data.forEach(row => row.x = target100);
      if (loam.enabled) {
        let lvls = ds[1].data.map(x => loam.perc.findLastIndex(y => x > y)), datalabels = { display:false };
        Object.assign(ds[1], { borderColor:lvls.map(x => color[x]), backgroundColor:lvls.map(x => color[x]+'80') });
        if (doLevel) {
          if (rm) ds.splice(ds.length - rm, rm);
          for (let i = 0; i < loam.len; i++) {
            let line = { type:'line', borderColor:color[i], backgroundColor:color[i]+'80', datalabels };
            ds.push({ ...line, label:loam.cols[i], data:d.labels.map(y => ({ x:loam.perc[i], y })) });
          }
        }
      } else {
        ds[1].borderColor = ds[1].data.map(x => x < target100 ? '#c83232' : '#32c832');
        ds[1].backgroundColor = ds[1].data.map(x => x < target100 ? '#c8323280' : '#32c83280');
        if (doLevel) ds.splice(ds.length - data.loa.length, data.loa.length);
      }
      usr.chart.update();
    }

    function updateGraph(rowData, perc, met, doLevel, rm) {
      if (!perc || !perc.chart || !perc.chart.config) return;
      let percDs = perc.chart.config.data.datasets, loam = data.loam, color = loam.colors;
      percDs[2].data = rowData.map(x => x.pMet*100);
      if (doLevel && !data.loam.enabled) percDs.splice(percDs.length - data.loa.length, data.loa.length);
      if (doLevel && data.loam.enabled) {
        if (rm) percDs.splice(percDs.length - rm, rm);
        for (let i = 0; i < loam.len; i++) {
          let bdat = rowData.map(x => isNaN(x[loam.stack[i]]) ? '--' : x[loam.stack[i]]*100);
          percDs.push({ ...barConfig(color[i], color[i]+'80', { stack:'loa' }), label:loam.cols[i], data:bdat });
        }
      }
      perc.chart.update();

      if (!met) return;
      met.chart.config.data.datasets[0].data = rowData.map(x => x.unmet);
      met.chart.config.data.datasets[1].data = rowData.map(x => x.met);
      met.chart.update();
    }

    $scope.updateGraphs = (doLevel, rm = 0) => {
      updateGraph(getDspData('goalOverview'), $scope.overviewGraph, $scope.overviewMetGraph, doLevel, rm);
      if (MS.map.curr == crits.user) _.compose(makeStudentPie, updateUserGraph)(MS.mapGraph, doLevel, rm);
      else updateGraph(getDspData('outMap'), $scope.mapGraph, $scope.mapMetGraph, doLevel, rm);
      updateGraph(getDspData('goalsByAssessment'), $scope.gbaGraph, $scope.gbaMetGraph, doLevel, rm);
      updateGraph(getDspData('goalsByCourse'), $scope.gbcGraph, $scope.gbcMetGraph, doLevel, rm);
      updateGraph(getDspData('goalsByProgram'), $scope.gbpGraph, $scope.gbpMetGraph, doLevel, rm);
      updateUserGraph(MS.gbuGraph, doLevel, rm);
      updateGraph(getDspData('goalsByTerm'), $scope.gbtGraph, $scope.gbtMetGraph, doLevel, rm);
      updateGraph(getDspData('goalsByType'), $scope.gbyGraph, $scope.gbyMetGraph, doLevel, rm);
    };

    function makeGraph(id, pid, config, title, paginator, sel, title2 = title) {
      if (MS[id]?.chart) {
        $('#'+pid).height(Math.max(config.data.labels.length*64 + 96, 400));
        Object.assign(MS[id].chart.config, config);
        MS[id].chart.config.options.plugins.title.text = title2 + sel;
        MS[id].chart.update();
        Object.assign(MS[id], { paginator, sel });
      } else {
        let delayChart = () => {
          _.delay(() => {
            $('#'+pid).height(Math.max(config.data.labels.length*64 + 96, 400));
            MS[id].chart = new Chart(id, config);
          }, 0);
        };
        MS[id] = { id, pid, title, paginator, sel, filename:title2.replaceAll(' ', ''), init:delayChart };
      }
    }

    function getDspData(src) {
      let rowData = [];
      $scope[src].grid?.api?.forEachNodeAfterFilterAndSort(x => rowData.push(x.data));
      return rowData;
    }

    function makeGraphs(src, id, perc, selection, metId, met, paginator) {
      let sel = selection === false ? '' : (selection === true ? MS[id].sel : ': ' + selection);
      let rowData = getDspData(src), pageSize = 20, page = direction => (delta = pageSize * direction) => {
        paginator.start = Math.min(Math.max(paginator.start+delta, 0), paginator.max-1);
        paginator.end = Math.min(paginator.start + pageSize, paginator.max);
        makeGraphs(src, id, perc, selection, metId, met, paginator);
      } // get data from aggrid and set up new paginator if needed
      let per0 = _.isArray(perc) ? perc[0] : perc, per1 = _.isArray(perc) ? perc[1] : perc;
      let len = rowData.length, loam = data.loam, color = loam.colors, t1 = { display:true, text:per0 + sel };
      if (!paginator) paginator = { start:0, end:Math.min(len, pageSize), max:len, prev:page(-1), next:page(1) };
      if (len > pageSize) rowData = rowData.slice(paginator.start, paginator.end);

      let fnd = (...keys) => len ? keys.find(key => rowData[0][key] !== undefined) : 'label';
      let round = x => $.precision(x, 1e-1), roundp = x => round(x)+'%', addp = x => x+'%';
      let roundPmet = x => isNaN(x.pMet) ? '' : round(x.pMet*100);

      let first = paginator.start + 1, matchLabel = /^\d+\.\s*|\s*\(\d+\)$/g, matchNum = /\((\d+)\)$/;
      let labelKey = fnd('label', 'goal', 'title'), ln = len ? (met ? rowData[0].tavg : target) * 100 : 0;
      let labels = rowData.map((x,i)=>`${i+first}. ${Trunc(x[labelKey])} (${x.scored})`), scaleLabel = { display:true };
      let bar1 = barConfig('#0069aa', '#0069aa80'), bar2 = barConfig('#6600ff', '#6600ff80'); /*#febc38 #e17009*/
      let line1 = { type:'line', borderColor:'#00446e', backgroundColor:'#00446e', datalabels:{ display:false } };
      let opts = { indexAxis:'y', responsive:true, maintainAspectRatio:false, interaction:{ mode:'index' } };
      let scales = { x:{ position:'top', min:0, max:100, ticks:{ callback:addp } }, y:{ scaleLabel } };
      let plug1 = { plugins:{ title:t1, datalabels:{ formatter:roundp, display:showDatalabel } } };
      let configPerc = { type:'bar', options:{ ...opts, ...plug1, scales } }, pid = id+'Parent', pd = [
        { ...line1, label:$L.h_goal_graph.data[0], data:rowData.map((x,i) => ({ x:ln, y:labels[i] })) },
        { ...bar1, label:$L.h_goal_graph.data[1], data:rowData.map(x=>isNaN(x.avg) ? '' : x.avg*100) }
      ];

      if (!met) { // config for student graph
        pd[0].label = $L.g_target._;
        pd[1].borderColor = rowData.map(x => x.avg < target ? '#c83232' : '#32c832');
        pd[1].backgroundColor = rowData.map(x => x.avg < target ? '#c8323280' : '#32c83280');

        if (loam.enabled) {
          let levels = pd[1].data.map(x => loam.perc.findLastIndex(y => x > y));
          pd[1].borderColor = levels.map(x => color[x]);
          pd[1].backgroundColor = levels.map(x => color[x]+'80');
        } else {
          pd[1].borderColor = pd[1].data.map(x => x < ln ? '#c83232' : '#32c832');
          pd[1].backgroundColor = pd[1].data.map(x => x < ln ? '#c8323280' : '#32c83280');
        }
        for (let i = 0; i < loam.len; i++) {
          let line = { type:'line', borderColor:color[i], backgroundColor:color[i]+'80', datalabels:{ display:false } };
          pd.push({ ...line, label:loam.cols[i], data:rowData.map((x,j) => ({ x:loam.perc[i], y:labels[j] })) });
        }
      } else { // push additional bars to other graphs
        pd.push({ ...bar2, label:$L.h_goal_overview.cols[5], data:rowData.map(roundPmet) });
        for (let i = 0; i < loam.len; i++) {
          let bdat = rowData.map(x => isNaN(x[loam.stack[i]]) ? '--' : x[loam.stack[i]]*100);
          pd.push({ ...barConfig(color[i], color[i]+'80', { stack:'loa' }), label:loam.cols[i], data:bdat });
        }
      }

      configPerc.options.plugins.tooltip = { enabled: false, callbacks: {
        title: items => items[0]?.label.replace(matchLabel, ''),
        beforeBody: items => $L.h_goal_overview.cols[2] + ': ' + (items[0]?.label.match(matchNum) || [])[1],
        label: item => item.dataset.label + ': ' + $.precision(SetDefault(item.raw.x, item.raw), 1) + '%'
      } };
      configPerc.data = { labels:labels, datasets:pd };
      makeGraph(id, pid, configPerc, per1, paginator, sel, per0);

      if (!met) return; // number met graph
      let t2 = { display:true, text:met + sel }, stack = { stack:'met' };
      let bar3 = barConfig('#c83232', '#c8323280', stack), bar4 = barConfig('#32c832', '#32c83280', stack);
      let line2 = { type:'line', borderWidth:0, backgroundColor:'#80808040', stack:'line' };
      let scale2 = { scales:{ x:{ position:'top', stacked:true }, y:{ scaleLabel, stacked:true } } };
      let plug2 = { plugins:{ title:t2, datalabels:{ formatter:round, display:showDatalabel } } };
      let configMet = { type:'bar', options:{ ...opts, ...plug2, ...scale2 } }, metPid = metId+'Parent';

      configMet.options.plugins.tooltip = { enabled: false, callbacks: {
        title: items => items[0]?.label.replace(matchLabel, ''),
        label: item => item.dataset.label + ': ' + $.precision(SetDefault(item.raw.x, item.raw), 1)
      } };
      configMet.data = {
        labels: rowData.map((x,i)=>`${i+first}. ${Trunc(x[labelKey])} (${x.users})`),
        datasets: [
          { ...bar3, label:$L.g_target.notmet, data:rowData.map(x => x.unmet) },
          { ...bar4, label:$L.g_target.met, data:rowData.map(x => x.met) },
          { ...line2, label:$L.g_target.students, data:rowData.map(x => x.users) }
        ]
      };
      makeGraph(metId, metPid, configMet, met, paginator, sel);
    }

    $scope.WordDownload = function(ag, ...graphs) {
      let doc = graphs.reduce((a, x) => {
        let can = document.getElementById(x), height = Math.min(900, 650 * can.height / can.width);
        return a + `<img src="${can.toDataURL()}" width="${height * can.width / can.height}" height="${height}">`;
      }, '');
      saveAs(htmlDocx.asBlob(doc), stripFilename(ag.sheetHeader, '.docx'));
    }

    $scope.GoalsDownload = function() {
      let wb = XLSX.utils.book_new();
      $scope.goalOverview.GetSheet(wb, true);
      for (let x of SortObjAry(selected, 'label')) {
        if (crits.goal.data[x.data.clppk1].scored == 0) continue;
        let tmp = new GridBox({ mode:'tmp', title:`${$L.h_student_goals.title} (${x.label})`, sheetTitle:x.label,
          keys:['goal', 'term', 'course_id', 'course_name', 'gm_title', 'rname', 'item', 'type', 'ulastname',
            'ufirstname', 'uemail', 'goalscore', 'ndate', 'program'],
          headers:$L.g_cols.download, model:MS.rawGoals.grid.rowData.filter(y => y.gpk1 == x.data.clppk1)
        });
        tmp.GetSheet(wb, true);
      }
      XLSX.writeFile(wb, stripFilename($L.g_download.classic_xlsx));
    };

    $scope.RawDownload = function() {
      let wb = XLSX.utils.book_new();
      [MS.rawGoals, MS.progMatrix].forEach(x => x.GetSheet(wb, true));
      XLSX.writeFile(wb, stripFilename($L.g_download.raw_xlsx));
    };
  });
EacAppSetup(app);
