<%@page contentType="text/html"%>
<%@page pageEncoding="UTF-8"%>
<%@ page errorPage="error.jsp" %>
<%@page import="java.util.*,
        java.security.*,
        java.util.Base64,
        java.io.*,
        java.net.*,
        java.nio.charset.*,
        blackboard.platform.plugin.*,
        blackboard.platform.context.*,
        blackboard.platform.session.*,
        blackboard.data.user.*,
        blackboard.platform.config.*,
        blackboard.base.*,
        blackboard.platform.*" %>

<%@ include file="util.jsp" %>

<%
    String myReferrer = request.getHeader("referer");
    if (myReferrer == null || myReferrer.equals("")) {
        throw new RuntimeException("Error referrer");
    }
    ContextManager ctxMgr = (ContextManager) BbServiceManager.lookupService(ContextManager.class);
    BbSession bbSession = ctxMgr.getContext().getSession();
    if (!bbSession.isAuthenticated() || bbSession.getUserName().toUpperCase().equals("GUEST")) {
        throw new RuntimeException("Error referrer");
    }
    if (ctxMgr.getContext().getUser().getSystemRole() != blackboard.data.user.User.SystemRole.SYSTEM_ADMIN) {
        throw new RuntimeException("Error referrer");
    }
    
    // Get version information for optional parameters
    String pgId = "ea";
    String pgHandle = "eacvis";
    PlugInManager pgm = (PlugInManager) BbServiceManager.lookupService(PlugInManager.class);
    PlugIn pg = pgm.getPlugIn(pgId, pgHandle);
    String pluginVersion = pg.getVersion().toString(); // Plugin version (not currently used, but kept for reference)
    // Get EAC version from env.json (for license API calls)
    String eacVersion = getVersion(application);
    String bbVersion = ((ConfigurationService) BbServiceManager.lookupService(ConfigurationService.class)).getBbProperty("bbconfig.version.number");
    String username = bbSession.getUserName();
    
    // Get the endpoint path
    String endpoint = getPath(request, "/api.jsp");
    
    // Generate token using shared function from util.jsp
    // Pass endpoint URL to ensure hostname extraction matches server validation
    String token = generateLicenseToken(endpoint);
    if (token == null) {
        throw new RuntimeException("Token generation failed");
    }
    
    // Get URLs from env.json
    String licenseCheckUrl = getEnvConfigValue(application, "LICENSE_CHECK_URL", null);
    String licenseRegisterUrl = getEnvConfigValue(application, "LICENSE_REGISTER_URL", null);
    if (licenseCheckUrl == null || licenseRegisterUrl == null) {
        throw new RuntimeException("Required configuration values missing from env.json: LICENSE_CHECK_URL and LICENSE_REGISTER_URL are required");
    }
%>
<%@ taglib uri="/bbData" prefix="bbData"%>
<%@ taglib uri="/bbUI" prefix="bbUI"%>

<bbData:context id="ctx">
    <bbUI:docTemplate>
        <bbUI:breadcrumbBar environment="sys_admin" handle="admin_plugin_manage">
            <bbUI:breadcrumb>EAC Configure</bbUI:breadcrumb>
        </bbUI:breadcrumbBar>
        <bbUI:titleBar iconUrl="Images/EAC_logo.png">&nbsp;&nbsp;EAC Configuration</bbUI:titleBar>
        
        <script type="text/javascript">
            const ENDPOINT = '<%= endpoint %>';
            const TOKEN = '<%= token %>';
            // License API URLs are defined in util.jsp - no duplication here
            
            // Base message - always shown
            const BASE_MESSAGE = 'EAC Building Block is ready.';
            const LTI_READY_MESSAGE = 'EAC LTI is ready.';
            const LTI_PROBLEM_MESSAGE = 'There was a problem configuring LTI.';
            const CONTACT_SUPPORT_MESSAGE = 'Please contact EAC support';
            const ENTER_LICENSE_MESSAGE = 'To enable LTI please enter your license key.';
            const NO_LICENSE_MESSAGE = 'No active EAC license found. For information about EAC please contact info@edassess.net\nTo enable EAC Building Block and LTI please enter your license key.';
            
            // Contact information - always visible
            const CONTACT_INFO = 'If you have questions about EAC, contact us at support@edassess.net';
            
            function showLoading() {
                document.getElementById('loadingState').style.display = 'block';
                document.getElementById('readyState').style.display = 'none';
                document.getElementById('licenseFormState').style.display = 'none';
                document.getElementById('errorState').style.display = 'none';
            }
            
            function showReady(ltiReady) {
                document.getElementById('loadingState').style.display = 'none';
                document.getElementById('readyState').style.display = 'block';
                document.getElementById('licenseFormState').style.display = 'none';
                document.getElementById('errorState').style.display = 'none';
                
                const messageElement = document.getElementById('readyMessage');
                if (ltiReady) {
                    messageElement.innerHTML = BASE_MESSAGE + '<br/>' + LTI_READY_MESSAGE;
                } else {
                    messageElement.innerHTML = BASE_MESSAGE;
                }
                // Reset to green background
                const readyStateDiv = document.getElementById('readyState').querySelector('div');
                readyStateDiv.style.color = '#155724';
                readyStateDiv.style.background = '#d4edda';
                readyStateDiv.style.border = '1px solid #c3e6cb';
            }
            
            function showNoLicense() {
                document.getElementById('loadingState').style.display = 'none';
                document.getElementById('readyState').style.display = 'block';
                document.getElementById('licenseFormState').style.display = 'block';
                document.getElementById('errorState').style.display = 'none';
                
                const messageElement = document.getElementById('readyMessage');
                // Replace newlines with <br/> for HTML display
                messageElement.innerHTML = NO_LICENSE_MESSAGE.replace(/\n/g, '<br/>');
                // Change background to red
                const readyStateDiv = document.getElementById('readyState').querySelector('div');
                readyStateDiv.style.color = '#721c24';
                readyStateDiv.style.background = '#f8d7da';
                readyStateDiv.style.border = '1px solid #f5c6cb';
            }
            
            function showLicenseForm() {
                document.getElementById('loadingState').style.display = 'none';
                document.getElementById('readyState').style.display = 'block';
                document.getElementById('licenseFormState').style.display = 'block';
                document.getElementById('errorState').style.display = 'none';
                
                const messageElement = document.getElementById('readyMessage');
                messageElement.innerHTML = BASE_MESSAGE + '<br/>' + ENTER_LICENSE_MESSAGE;
                // Reset to green background
                const readyStateDiv = document.getElementById('readyState').querySelector('div');
                readyStateDiv.style.color = '#155724';
                readyStateDiv.style.background = '#d4edda';
                readyStateDiv.style.border = '1px solid #c3e6cb';
            }
            
            function showError() {
                document.getElementById('loadingState').style.display = 'none';
                document.getElementById('readyState').style.display = 'block';
                document.getElementById('licenseFormState').style.display = 'none';
                document.getElementById('errorState').style.display = 'block';
                
                const messageElement = document.getElementById('readyMessage');
                messageElement.innerHTML = BASE_MESSAGE + '<br/>' + LTI_PROBLEM_MESSAGE + '<br/>' + CONTACT_SUPPORT_MESSAGE;
            }
            
            async function checkLicense() {
                showLoading();
                
                // License API URL from env.json
                const LICENSE_CHECK_URL = '<%= licenseCheckUrl %>';
                
                try {
                    const response = await fetch(LICENSE_CHECK_URL, {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                        },
                        body: JSON.stringify({
                            endpoint: ENDPOINT,
                            token: TOKEN,
                            eacVersion: '<%= eacVersion %>',
                            bbVersion: '<%= bbVersion %>',
                            username: '<%= username %>'
                        })
                    });
                    
                    if (!response.ok) {
                        // API not reachable or error
                        showReady(false);
                        return;
                    }
                    
                    const result = await response.json();
                    
                    // Check for error flag
                    if (result.error === true) {
                        showError();
                        return;
                    }
                    
                    // Show license form if not registered (based on registered property)
                    if (result.registered === false) {
                        showLicenseForm();
                    } else if (result.license === true || (typeof result.license === 'string' && result.license.length > 0)) {
                        // License is valid and registered
                        showReady(true);
                    } else {
                        // License is false but registered - show no license state (red box)
                        showNoLicense();
                    }
                } catch (error) {
                    console.error('Failed to check license:', error);
                    // API not reachable
                    showReady(false);
                }
            }
            
            async function registerLicense() {
                const licenseKey = document.getElementById('licenseKeyInput').value.trim();
                
                if (!licenseKey) {
                    alert('Please enter a license key');
                    return;
                }
                
                // Show loading while registering
                showLoading();
                
                // License API URL from env.json
                const LICENSE_REGISTER_URL = '<%= licenseRegisterUrl %>';
                
                try {
                    const response = await fetch(LICENSE_REGISTER_URL, {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                        },
                        body: JSON.stringify({
                            endpoint: ENDPOINT,
                            token: TOKEN,
                            licenseKey: licenseKey,
                            eacVersion: '<%= eacVersion %>',
                            bbVersion: '<%= bbVersion %>',
                            username: '<%= username %>'
                        })
                    });
                    
                    if (!response.ok) {
                        showError();
                        return;
                    }
                    
                    const result = await response.json();
                    
                    // Check if registration was successful
                    if (result.registered === true) {
                        // Registration successful - show ready state
                        if (result.license === true || (typeof result.license === 'string' && result.license.length > 0)) {
                            showReady(true);
                        } else {
                            // License is false after registration - show no license state
                            showNoLicense();
                        }
                    } else {
                        showError();
                    }
                } catch (error) {
                    console.error('Failed to register license:', error);
                    showError();
                }
            }
            
            function exitIt() {
                // Go back three times in browser history to properly close the configuration page
                // Since the config page doesn't create a separate history entry, we need to go back 3 steps
                window.history.go(-3);
            }
            
            function refreshLicense() {
                // Refresh the license check
                checkLicense();
            }
            
            // Check license when page loads
            window.onload = function() {
                checkLicense();
            };
        </script>
        
        <form id="form1" style="display:block">
            <div id="theForm" style="font-size: medium">
                <center>
                    <table style="width: 760px">
                        <tr><td colspan="2" align="center">&nbsp;</td></tr>
                        <tr><td colspan="2" align="center"><img alt="EAC Logo" src="Images/eaclogo.png"/></td></tr>
                        <tr><td colspan="2" align="center">&nbsp;</td></tr>
                        
                        <!-- Loading State -->
                        <tr><td colspan="2" align="center" id="loadingState">
                            <div style="color: #0c5460; padding: 20px; background: #d1ecf1; border: 1px solid #bee5eb; border-radius: 8px; margin: 20px 0;">
                                <div style="border: 4px solid #f3f3f3; border-top: 4px solid #0c5460; border-radius: 50%; width: 40px; height: 40px; animation: spin 1s linear infinite; margin: 0 auto 20px;"></div>
                                <h3 style="margin: 0 0 10px 0;">Checking license...</h3>
                            </div>
                        </td></tr>
                        
                        <!-- Ready State (Base message) -->
                        <tr><td colspan="2" align="center" id="readyState" style="display: none;">
                            <div style="color: #155724; padding: 20px; background: #d4edda; border: 1px solid #c3e6cb; border-radius: 8px; margin: 20px 0;">
                                <h3 style="margin: 0 0 10px 0;" id="readyMessage"></h3>
                            </div>
                        </td></tr>
                        
                        <!-- License Form State (shown when license is false) -->
                        <tr><td colspan="2" align="center" id="licenseFormState" style="display: none;">
                            <div style="padding: 20px; margin: 20px 0; display: flex; justify-content: center; align-items: center; flex-direction: row; gap: 10px;">
                                <input type="text" id="licenseKeyInput" placeholder="Enter license key" 
                                       style="padding: 10px; width: 300px; border: 1px solid #ccc; border-radius: 4px; font-size: 14px;" />
                                <button type="button" onclick="registerLicense()" 
                                        style="background: #007bff; color: white; border: none; padding: 10px 20px; border-radius: 4px; font-size: 14px; cursor: pointer;">
                                    Submit
                                </button>
                            </div>
                        </td></tr>
                        
                        <!-- Error State -->
                        <tr><td colspan="2" align="center" id="errorState" style="display: none;">
                            <div style="color: #721c24; padding: 20px; background: #f8d7da; border: 1px solid #f5c6cb; border-radius: 8px; margin: 20px 0;">
                            </div>
                        </td></tr>
                        
                        <tr><td colspan="2" align="center">&nbsp;</td></tr>
                        
                        <!-- Contact Information (Always Visible) -->
                        <tr><td colspan="2" align="center"><b>Contact Information</b></td></tr>
                        <tr><td colspan="2" align="center">If you have questions about EAC, contact us at support@edassess.net</td></tr>
                        <tr><td colspan="2" align="center">&nbsp;</td></tr>
                        
                        <!-- Close and Refresh Buttons (Always Visible) -->
                        <tr><td colspan="2" align="center">
                            <button id="refreshButton" onclick="refreshLicense()" style="background: #28a745; color: white; border: none; padding: 12px 24px; border-radius: 6px; font-size: 16px; cursor: pointer; margin-right: 10px;">Refresh</button>
                            <button id="closeButton" onclick="exitIt()" style="background: #6c757d; color: white; border: none; padding: 12px 24px; border-radius: 6px; font-size: 16px; cursor: pointer;">Close</button>
                        </td></tr>
                        <tr><td colspan="2" align="center">&nbsp;</td></tr>
                    </table>
                </center>
            </div>
        </form>
        
        <style>
            @keyframes spin {
                0% { transform: rotate(0deg); }
                100% { transform: rotate(360deg); }
            }
            
            button:hover {
                opacity: 0.9;
            }
            
            input:focus {
                outline: 2px solid #007bff;
                outline-offset: 2px;
            }
        </style>
    </bbUI:docTemplate>
</bbData:context>
