<%-- 
    Document   : getVisualData
    Created on : Mar 19, 2013, 10:56:54 AM
    Author     : pheisen
--%>
<%@ page errorPage = "error.jsp" %>
<%@ page import="java.util.Enumeration,
    java.io.*,
    java.math.*,
    java.nio.charset.StandardCharsets,
    java.sql.*,
    java.net.*,
    java.util.*,
    javax.net.ssl.*,
    java.util.regex.*,
    org.apache.commons.lang3.StringEscapeUtils.*,
    org.json.simple.*,
    java.security.*,
    blackboard.data.*,
    blackboard.base.*,
    blackboard.data.user.*,
    blackboard.data.course.*,
    blackboard.data.content.*,
    blackboard.platform.context.*,
    blackboard.data.navigation.*,
    blackboard.data.gradebook.impl.*,
    blackboard.persist.*,
    blackboard.persist.user.*,
    blackboard.persist.gradebook.impl.*,
    blackboard.persist.course.*,
    blackboard.persist.content.*,
    blackboard.persist.navigation.*,
    blackboard.platform.filesystem.*,
    blackboard.platform.intl.*,
    blackboard.platform.session.*,
    blackboard.platform.security.*,
    blackboard.platform.security.authentication.*,
    blackboard.platform.*,
    blackboard.platform.config.*,
    blackboard.platform.context.impl.*,
    blackboard.platform.vxi.data.*,
    blackboard.platform.vxi.persist.impl.*,
    blackboard.platform.vxi.service.*,
    blackboard.db.*,
    blackboard.platform.plugin.*,
    blackboard.platform.security.EscapeUtility.*,
    blackboard.xss.request.*,
    blackboard.platform.plugin.impl.*,
    blackboard.servlet.util.CourseCatalogUtil"
    %>
<%@ taglib uri="/bbNG" prefix="bbNG" %>
<%@ taglib uri="/loginUI" prefix="loginUI" %>
<%@ page contentType="text/html"%>
<%@ page pageEncoding="UTF-8"%>
<%@ include file="util.jsp" %>
<%
    request.setAttribute("com.newrelic.agent.IGNORE", true);
    ContextManager ctxMgr = (ContextManager) BbServiceManager.lookupService(ContextManager.class);
    String host = ctxMgr.getContext().getRequestUrl();
    String input = request.getHeader("referer");
    String myReferrer =org.apache.commons.lang3.StringEscapeUtils.escapeXml11(input);//ESCAPE_XML11.ESAPI.validator().getValidInput("myReferrer", input, "CommentRegex", 400, false, errorV);
    if (myReferrer == null || myReferrer.equals("")) {
        throw new RuntimeException("Error referrer");
    }
    
    BbSession bbSession = ctxMgr.getContext().getSession();
    if (!bbSession.isAuthenticated() || bbSession.getUserName().toUpperCase().equals("GUEST")) {
        throw new RuntimeException("Error No login");
    }

    blackboard.platform.intl.BbResourceBundle bbCommonBundle = blackboard.platform.BbServiceManager.getBundleManager().getBundle("rubrics");
    String langTemp = "en_US";
    String langcode = bbCommonBundle.getLocale().getLocale();
    if (langcode.equals("es_ES")) {
        langTemp = langcode;
    }
    String row1label = bbCommonBundle.getString("grid.row1.label");
    String row2label = bbCommonBundle.getString("grid.row2.label");
    String row3label = bbCommonBundle.getString("grid.row3.label");
    String col1label = bbCommonBundle.getString("grid.column1.label");
    String col2label = bbCommonBundle.getString("grid.column2.label");
    String col3label = bbCommonBundle.getString("grid.column3.label");

    String pgId = "ea";
    String pgHandle = "eacvis";
    blackboard.platform.plugin.PlugIn plg = blackboard.platform.plugin.PlugIn.class.newInstance();
    PlugInManager pgm = (PlugInManager) BbServiceManager.lookupService(PlugInManager.class);
    PlugIn pg = pgm.getPlugIn(pgId, pgHandle);
    String pluginVersion = pg.getVersion().toString();
    String cmsUrl = blackboard.platform.plugin.PlugInUtil.getUriStem(pgId, pgHandle);
    String bbVersion = ((ConfigurationService) blackboard.platform.BbServiceManager.lookupService(ConfigurationService.class)).getBbProperty("bbconfig.version.number");
    
    String username = null;
    String sessionHash = null;
    String url;
    String uid = null;
    String BbUrl;
    
    // pgsql, oracle, mssql
    String dbtype = ((ConfigurationService) BbServiceManager.lookupService(ConfigurationService.class)).getBbProperty("bbconfig.database.type");

    boolean loggedIn = true;
    username = bbSession.getUserName();
    Id userId = bbSession.getUserId();
    uid = userId.toExternalString().split("_")[1];
    sessionHash = bbSession.getBbSecureSessionIdMd5();
    // Get EAC version from env.json (for cache busting and license check)
    String eacVersion = getVersion(application);
    url = cmsUrl + "EACHome.html?v=" + eacVersion;
    
    // Generate token using util.jsp's generateUserToken function
    // This ensures the token matches what b2-api.jsp expects when validating
    // Token is: hash(userId + getPath("/b2-api.jsp") + TOKEN_SALT)
    String token = generateUserToken(uid, request);
    if (token == null) {
        throw new RuntimeException("Token generation failed");
    }
    
    // Use new checkLicense API from util.jsp with fallback to "true" if request fails
    String license = checkLicense(request, eacVersion, bbVersion, username);
    if (license == null) {
        // Request failed - default to "true" as fallback
        license = "true";
    }
    boolean active = license != "false";
    boolean permSet = license == "true";
    JSONObject permissions = new JSONObject();
    permissions.put("tt", permSet);
    permissions.put("rt", permSet);
    permissions.put("gt", permSet);
    permissions.put("ot", permSet);
    permissions.put("im", permSet);
    permissions.put("em", permSet);
    permissions.put("am", permSet);
    permissions.put("ig", permSet);
    permissions.put("eg", permSet);
    permissions.put("ag", permSet);
    permissions.put("gg", permSet);
    if (license.startsWith("pl:")) {
        String[] permList = license.substring(3).split(",");
        for (String perm : permList) {
            permissions.put(perm, true);
        }
    }
%>

<bbNG:genericPage authentication="N">

<div style="width:100%; height:50%; display:flex; flex-direction:column; align-items:center; justify-content:center; font-size:200%; text-align:center;" onclick="go()">
    <img alt="EAC Logo" src="Images/eaclogo.png" style="margin:24px;"/>
    <div id="loading">
        <p id="loading_text">Loading...</p>
    </div>
    <div id="success" style="display: none;">
        <p id="link_label">Please click the following link:</p>
        <p><a href="UI2/EacHome.html?v=<%=eacVersion%>" target= "_blank" id="link_text">EAC Visual Data</a></p>
    </div>
    <div id="error" style="display: none;">
        <p id="expired">License expired.</p>
        <p id="contact">Contact your Blackboard administrator.</p>
    </div>
</div>

<bbNG:jsBlock>
    <script type="text/javascript" src="Lib/Polyfill/Helpers.min.js"></script>
    <script type="text/javascript" src="Lib/Underscore_1.9.1/underscore-min.js"></script>
    <script type="text/javascript" src="Core/Core.min.js?v=<%=eacVersion%>"></script>
    <script type="text/javascript">
        // Store original parameters
        // Use BACKEND_URL from env.json (loaded by Core.min.js) - can be relative or full URL
        let BbUrl;
        if (window.EAC_ENV_CONFIG && window.EAC_ENV_CONFIG.BACKEND_URL) {
            const backendUrl = window.EAC_ENV_CONFIG.BACKEND_URL;
            if (backendUrl.startsWith('http://') || backendUrl.startsWith('https://')) {
                // Full URL - use as-is
                BbUrl = backendUrl;
            } else {
                // Relative URL - construct full URL
                const pathParts = window.location.pathname.split('/');
                const contextPath = '/' + pathParts[1] + (pathParts[2] ? '/' + pathParts[2] : '');
                BbUrl = window.location.protocol + '//' + window.location.host + contextPath + (backendUrl.startsWith('/') ? backendUrl : '/' + backendUrl);
            }
        } else {
            // Fallback to old behavior if env.json not loaded
            const pathParts = window.location.pathname.split('/');
            const contextPath = '/' + pathParts[1] + (pathParts[2] ? '/' + pathParts[2] : '');
            BbUrl = window.location.protocol + '//' + window.location.host + contextPath + '/b2-api.jsp';
        }
        const key = 'EAC', BbLang = '<%=langTemp%>', ua = navigator.userAgent;
        const query = {key:key, BbUrl:BbUrl, lang:BbLang, active:<%=active%>,
            dbtype:'<%=dbtype%>', sessionHash:'<%=sessionHash%>', uid:'<%=uid%>',
            username:'<%=username%>', url:'<%=url%>', referrer:'<%=myReferrer%>',
            token:'<%=token%>', perms:<%=permissions%>, host:'<%=host%>',
            gridrow1label:'<%=row1label%>', gridcolumn1label:'<%=col1label%>',
            gridrow2label:'<%=row2label%>', gridcolumn2label:'<%=col2label%>',
            gridrow3label:'<%=row3label%>', gridcolumn3label:'<%=col3label%>'}
        window.name = key;
        window.backed = false;
        // Language and settings
        function Base64Encode(obj, encoding = 'utf-8') {
            var str = _.isString(obj) ? obj : JSON.stringify(obj);
            var bytes = new (TextEncoder || TextEncoderLite)(encoding).encode(str);
            return base64js.fromByteArray(bytes);
        }
        var parent = window.opener, ui = 'UI2', storedObject = {
            set:(k,o)=>localStorage.setItem(k, Base64Encode(o)),
            get:(k)=>JSON.parse(localStorage.getItem(k)),
        };
        storedObject.set(key, query);
        
        var settings = storedObject.get(query.uid), lang = 'en', $L = {}, loading = true;
        if (settings) lang = settings.language;
        else if (query) lang = query.lang;
        lang = lang.startsWith('es') ? 'es' : 'en';
        document.documentElement.lang = lang;

        function go() {
            if (loading) return;
            window.open(ui+'/EacHome.html?v=<%=eacVersion%>','_blank');
        }

        fetch(new Request('Lang/'+lang+'.json?v=<%=eacVersion%>'))
            .then(response => response.json())
            .then(json => {
                $L = json;
                storedObject.set('lang', $L);
                document.getElementById('loading_text').innerText = $L.grid.loadingOoo;
                document.getElementById('loading').style.display = 'none';
                loading = false;

                if (!query.active) {
                    document.getElementById('expired').innerText = $L.msg.expired;
                    document.getElementById('contact').innerText = $L.msg.contact;
                    document.getElementById('error').style.display = '';
                    return;
                }

                window.open(ui+'/EacHome.html?v=<%=eacVersion%>','_blank');
                document.getElementById('link_label').innerText = $L.link_label;
                document.getElementById('link_text').innerText = $L.link_new;
                document.getElementById('success').style.display = '';
            });
    </script>
</bbNG:jsBlock>
</bbNG:genericPage>

<%
    if (ctxMgr != null) {
        ctxMgr.releaseContext();
    }
%>
